<?php
session_start();
include('../config/dbcon.php');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userID = $_SESSION['userID'];
    $timesheetID = $_POST['timesheetID']; // Add a hidden field for timesheetID in your form
    $tentryDate = $_POST['tentryDate'];
    $clientID = $_POST['client'];
    $projectID = $_POST['project'];
    $milestoneID = $_POST['milestone'];
    $hrs = $_POST['hrs'];
    $descp = $_POST['descp'];
    $leaveDays = $_POST['leaveDays'];

    // Create a prepared statement
    $updateQuery = "UPDATE timesheet 
                    SET tentryDate = ?, 
                        clientID = ?, 
                        projectID = ?, 
                        milestoneID = ?, 
                        hrs = ?, 
                        descp = ?, 
                        leaveDays = ? 
                    WHERE timesheetID = ? AND userID = ?";

    // Prepare the statement
    $stmt = mysqli_prepare($conn, $updateQuery);

    if ($stmt) {
        // Bind parameters
        mysqli_stmt_bind_param($stmt, "siiidsiii", $tentryDate, $clientID, $projectID, $milestoneID, $hrs, $descp, $leaveDays, $timesheetID, $userID);

        // Execute the statement
        if (mysqli_stmt_execute($stmt)) {
            // Timesheet entry updated successfully
            header('Location: timesheet.php');
        } else {
            // Error occurred, handle accordingly
            echo "Error: " . mysqli_stmt_error($stmt);
        }

        // Close the statement
        mysqli_stmt_close($stmt);
    } else {
        // Error occurred while preparing the statement
        echo "Error: " . mysqli_error($conn);
    }

    mysqli_close($conn);
}
?>