<?php include('includes/header.php'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>
                    Add Timesheet
                    <a href="timesheet.php" class="btn btn-danger float-end">View Timesheet</a>
                </h4>
            </div>
            <div class="card-body">
                <?= alertMessage(); ?>
                <form action="submit_timesheet.php" method="POST" id="timesheetForm">
                    <!-- Initial form fields for the first timesheet entry -->
                    <div class="row">
                        <div class="col-md-2">
                            <div class="mb-3">
                                <label for="tentryDate">Date of Entry</label>
                                <input type="date" name="tentryDate[]" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="mb-3">
                                <label for="client">Select Client:</label>
                                <select class="form-control client" name="client[]" required>
                                    <option value="">Select a Client</option>
                                    <!-- Populate client options dynamically using AJAX -->
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="mb-3">
                                <label for="project">Select Project:</label>
                                <select class="form-control project" name="project[]" required>
                                    <option value="">Select a Project</option>
                                    <!-- Populate project options dynamically using AJAX -->
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="mb-3">
                                <label for="milestone">Select Milestone:</label>
                                <select class="form-control milestone" name="milestone[]" required>
                                    <option value="">Select a Milestone</option>
                                    <!-- Populate milestone options dynamically using AJAX -->
                                </select>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <div class="mb-3">
                                <label>Hrs Spent</label>
                                <input type="text" name="hrs[]" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="mb-3">
                                <label>Description</label>
                                <input type="text" name="descp[]" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-1">
                            <div class="mb-3">
                                <label>Remove</label>
                                <button type="button" class="btn btn-danger remove-row">
                                    <i class="fas fa-trash-alt"></i> <!-- Assuming Font Awesome is used for the delete icon -->
                                </button>
                            </div>
                        </div>
                    </div>
                    <!-- Additional timesheet entries will be dynamically added here -->
                    <div id="additionalEntries"></div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <br>
                                <button type="submit" value="Submit" class="btn btn-primary">Save</button>
                                <button type="button" id="addEntry" class="btn btn-success">Add More Entries</button>
                            </div>
                        </div>
                </form>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Enter Leaves</h4>
                    </div>
                    <div class="card-body">
                <!-- Leave Days Form -->
                <form action="submit_leave_days.php" method="POST" id="leaveDaysForm">
                    <div class="row">
                        <div class="col-md-2">
                            <div class="mb-3">
                                <label for="lentryDate">Date of Entry</label>
                                <input type="date" name="lentryDate" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="mb-3">
                                <label>Leave Days</label>
                                <input type="text" name="leaveDays" class="form-control" value="0">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <br>
                            <button type="submit" value="Submit" class="btn btn-primary">Save Leave Days</button>
                        </div>
                    </div>
                </form>
                </div>
                </div>
                
    </div>
</div>

<!-- ... (previous code) ... -->

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    // Function to populate clients dropdown
    function populateClients() {
        var clientSelect = $('.client'); // Select all client dropdowns

        // Make an AJAX request to get clients
        $.ajax({
            url: "get_clients.php",
            type: "get", // Use GET method for fetching clients
            success: function (response) {
                // Update all client dropdowns with the fetched options
                clientSelect.html('<option value="">Select a Client</option>' + response);
            }
        });
    }

    // Call the function to populate clients initially
    populateClients();

    // Function to populate projects dropdown based on the selected client
    function populateProjects(selectElement) {
        var clientID = $(selectElement).val();
        var projectSelect = $(selectElement).closest('.row').find('.project');

        // Make an AJAX request to get projects for the selected client
        $.ajax({
            url: "get_projects.php",
            type: "post",
            data: { clientID: clientID },
            success: function (response) {
                // Update the projects dropdown with the fetched options
                projectSelect.html('<option value="">Select a Project</option>' + response);
            }
        });
    }

    // Function to populate milestones dropdown based on the selected project
    function populateMilestones(selectElement) {
        var projectID = $(selectElement).val();
        var milestoneSelect = $(selectElement).closest('.row').find('.milestone');

        // Make an AJAX request to get milestones for the selected project
        $.ajax({
            url: "get_milestones.php",
            type: "post",
            data: { projectID: projectID },
            success: function (response) {
                // Update the milestones dropdown with the fetched options
                milestoneSelect.html('<option value="">Select a Milestone</option>' + response);
            }
        });
    }

    // Event listener for client dropdown change (including dynamically added rows)
    $(document).on('change', '.client', function () {
        populateProjects(this);
    });

    // Event listener for project dropdown change (including dynamically added rows)
    $(document).on('change', '.project', function () {
        populateMilestones(this);
    });

    // Event listener for the "Add More Entries" button
$("#addEntry").on("click", function () {
    // Clone the last row of the form
    var newRow = $("#timesheetForm .row:last").clone();

    // Clear the values in the cloned fields
    newRow.find("input:not([name='leaveDays[]'])").val('');
    newRow.find("select").val(''); // Clear the selected options in selects

    // Append the cloned row to the form
    $("#additionalEntries").append(newRow);
});

// Event listener for client dropdown change (including dynamically added rows)
$(document).on('change', '.client', function () {
    populateProjects(this);
});

// Event listener for project dropdown change (including dynamically added rows)
$(document).on('change', '.project', function () {
    populateMilestones(this);
});

// Event listener for date field change (including dynamically added rows)
$(document).on('change', 'input[name="tentryDate[]"]', function () {
    // Get the changed date value
    var changedDate = $(this).val();

    // Set the same date in all date fields
    $('input[name="tentryDate[]"]').val(changedDate);
});

// Event listener for removing a row
$(document).on('click', '.remove-row', function () {
    // Check if there's more than one row before removing
    if ($('#timesheetForm .row').length > 1) {
        // Find the parent row and remove it
        $(this).closest('.row').remove();
    } else {
        alert("You cannot remove the last row.");
    }
});

    
</script>

<!-- ... (remaining code) ... -->

<?php include('includes/footer.php'); ?>