<?php
// Include your database connection code or configuration here
include('../config/dbcon.php');

if (isset($_POST['clientID'])) {
    // Get the clientID from POST
    $clientID = $_POST['clientID'];

    // Prepare and execute the SQL query to fetch projects for the selected client
    $projectQuery = "SELECT * FROM projects WHERE clientID = ?";
    $stmt = $conn->prepare($projectQuery);
    $stmt->bind_param("i", $clientID);
    $stmt->execute();

    $options = "";
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $options .= "<option value='" . $row['projectID'] . "'>" . $row['projectName'] . "</option>";
    }

    // Close the prepared statement
    $stmt->close();
    
    // Close the database connection
    $conn->close();

    // Return the HTML options
    echo $options;
} else {
    // Handle the case where clientID is not set in POST data
    echo "Invalid request.";
}
?>