<?php include('includes/header.php'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>
                    Clients Lists
                </h4>
            </div>
            <div class="card-body">
                <?= alertMessage(); ?>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th class="align-middle text-center">S.No.</th>
                            <th class="align-middle text-center">Client Name</th>
                            <!-- <th class="align-middle text-center">Client Action</th> -->
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        $clients = getALL('clients');
                        
                        if (mysqli_num_rows($clients) > 0) {
                            // Create an empty array to store client data for sorting
                            $clientArray = array();
                        
                            while ($clientItem = mysqli_fetch_assoc($clients)) {
                                $clientArray[] = $clientItem;
                            }
                        
                            // Sort the client data by "clientName" in ascending order
                            usort($clientArray, function ($a, $b) {
                                return strcmp($a['clientName'], $b['clientName']);
                            });
                        
                            foreach ($clientArray as $clientItem) {
                                ?>
                                <tr>
                                    <td class="align-middle text-center"><?= $no; ?></td>
                                    <td class="align-middle text-center"><?= $clientItem['clientName']; ?></td>
                                </tr>
                                <?php
                                $no++;
                            }
                        } else {
                            ?>
                            <tr>
                                <td colspan="2">No record Found</td>
                            </tr>
                            <?php
                        }
                        ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>



<?php include('includes/footer.php'); ?>