<?php include('includes/header.php'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>
                    User Lists
                </h4>
            </div>
            <div class="card-body">
                <?= alertMessage(); ?>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr class="align-middle text-center">
                            <th>S.No.</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Role</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        $users = getALL('users');
                        if (mysqli_num_rows($users) > 0) {
                            // Create an empty array to store user data for sorting
                            $userArray = array();
                        
                            while ($userItem = mysqli_fetch_assoc($users)) {
                                $userArray[] = $userItem;
                            }
                        
                            // Sort the user data by "fname" in ascending order
                            usort($userArray, function ($a, $b) {
                                return strcmp($a['fname'], $b['fname']);
                            });
                        
                            foreach ($userArray as $userItem) {
                                ?>
                                <tr class="align-middle text-center">
                                    <td><?= $no; ?></td>
                                    <td><?= $userItem['fname'] . ' ' . $userItem['lname']; ?></td>
                                    <td><?= $userItem['email']; ?></td>
                                    <td><?= $userItem['role']; ?></td>
                                </tr>
                                <?php
                                $no++;
                            }
                        } else {
                            ?>
                            <tr>
                                <td colspan="7">No record Found</td>
                            </tr>
                            <?php
                        }
                        ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>



<?php include('includes/footer.php'); ?>