<?php include('includes/header.php'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>
                    Resource Plan Projects List
                <button id="download-csv" class="btn btn-primary mt-4 float-end">Download CSV</button>
                </h4>
            </div>
            <div class="card-body">
                <?= alertMessage(); ?>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr class="align-middle text-center">
                            <th>S.No.</th>
                            <th>Client Name</th>
                            <th>Project Name</th>
                            <th>Resource Plan Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        $projects = linkALL('projects');
                        if (mysqli_num_rows($projects) > 0) {
                            foreach ($projects as $projectItem) {
                                ?>
                                <tr class="align-middle text-center text-xs">
                                    <td><?= $no; ?></td>
                                    <td><?= $projectItem['clientName']; ?></td>
                                    <td><?= $projectItem['projectName']; ?></td>
                                    <td>
                                        <a href="resource-plan-view.php?projectID=<?= $projectItem['projectID']; ?>" class="btn btn-info btn-sm">View</a>
                                    </td>
                                </tr>

                                <?php
                                $no++;
                            }

                        } else {
                            ?>
                        <tr>
                            <td colspan="7">No record Found</td>
                        </tr>

                        <?php
                        }
                        ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript to handle confirmation dialog -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function () {
            // Add a click event listener to all elements with the "delete-link" class
            $('.delete-link').on('click', function (event) {
                // Prevent the default link behavior
                event.preventDefault();
                
                // Show a confirmation dialog
                if (confirm($(this).data('confirm'))) {
                    // If the user confirms, proceed with the link's href
                    window.location.href = $(this).attr('href');
                }
            });
        });
        
                // Function to trigger CSV download
        function downloadCSV() {
            const table = document.querySelector('.table');
            const rows = table.querySelectorAll('tr');
            const csv = [];

            // Generate CSV content
            rows.forEach((row, rowIndex) => {
                const rowData = [];
                row.querySelectorAll('td, th').forEach((cell, cellIndex) => {
                    // Wrap cell data in double quotes and escape existing double quotes
                    const cellData = cell.textContent.replace(/"/g, '""');
                    rowData.push(`"${cellData}"`);
                });b

                // Include the header row if it's the first row
                if (rowIndex === 0) {
                    csv.push(rowData.join(','));
                } else {
                    csv.push(rowData.join(','));
                }
            });

            // Create a blob containing the CSV data
            const blob = new Blob([csv.join('\n')], { type: 'text/csv' });

            // Create a download link and trigger the download
            const link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = 'projects_list.csv';
            link.style.display = 'none';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }

        // Add click event listener to the download button
        document.getElementById('download-csv').addEventListener('click', downloadCSV);
    </script>



<?php include('includes/footer.php'); ?>