<?php include('includes/header.php'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>
                    Edit User
                    <a href="users.php" class="btn btn-danger float-end">Back</a>
                </h4>
            </div>
            <div class="card-body">

            <?= alertMessage(); ?>

                <form action="code.php" method="POST">

                <?php
                    $paramResult = checkParamId('userID');
                    if(!is_numeric($paramResult))
                    {
                        echo '<h5>'.$paramResult.'</h5>';
                        return false;
                    }
                    
                    $users = getById('users',checkParamId('userID'));
                    if($users['status'==200])
                    {
                        ?>
                        <?php
                    }
                    else
                    {
                        echo '<h5>'.$users['message'].'</h5>';
                    }
                ?>

                <input type="hidden" name="UID" value="<?= $users['data']['userID'] ;?>"required >

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>First Name</label>
                                <input type="text" name="fname" value="<?= $users['data']['fname'] ;?>"required class="form-control">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Last Name</label>
                                <input type="text" name="lname"value="<?= $users['data']['lname'] ;?>" required class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Email</label>
                                <input type="email" name="email"value="<?= $users['data']['email'] ;?>" required class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Password</label>
                                <input type="password" name="password" value="<?= $users['data']['password'] ;?>"required class="form-control">
                            </div>
                        </div>

                        <div class="col-md-6">

                            <div class="mb-3">
                                <label>User Role</label>
                                <select name="role" required class="form-select">
                                    <option value="">Select Role</option>
                                    <option value="admin"<?= $users['data']['role'] == 'admin' ? 'selected' : '' ;?>>Admin</option>
                                    <option value="manager"<?= $users['data']['role'] == 'manager' ? 'selected' : '' ;?>>Project Manager</option>
                                    <option value="user"<?= $users['data']['role'] == 'user' ? 'selected' : '' ;?>>Staff</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Employee Rate</label>
                                <input type="text" name="employeeRate" value="<?= $users['data']['employeeRate'] ;?>" required class="form-control">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Date of Joining</label>
                                <input type="date" name="joiningDate" value="<?= $users['data']['joiningDate'] ;?>" required class="form-control">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Budgeted RGL Q1</label>
                                <input type="text" name="budgetedRGLq1" value="<?= $users['data']['budgetedRGLq1'] ;?>"required class="form-control">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Budgeted RGL Q2</label>
                                <input type="text" name="budgetedRGLq2" value="<?= $users['data']['budgetedRGLq2'] ;?>"required class="form-control">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Budgeted RGL Q3</label>
                                <input type="text" name="budgetedRGLq3" value="<?= $users['data']['budgetedRGLq3'] ;?>"required class="form-control">
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Budgeted RGL Q4</label>
                                <input type="text" name="budgetedRGLq4" value="<?= $users['data']['budgetedRGLq4'] ;?>"required class="form-control">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Working Days(Per Month)</label>
                                <input type="text" name="workingDays"value="<?= $users['data']['workingDays'] ;?>" required class="form-control">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <br>
                                <button type="submit" name="updateUser" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>



<?php include('includes/footer.php'); ?>