<?php
include('includes/header.php');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check if contractID is provided in the URL
if (isset($_GET['contractID'])) {
    $contractID = validate($_GET['contractID']);

    // Handle form submission
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Retrieve receipt details from the form
        $milestoneID = validate($_POST['milestoneID']);
        $receivedAmt = validate($_POST['receivedAmt']);
        $chequeNo = validate($_POST['chequeNo']);
        $receivedDate = validate($_POST['receivedDate']);

        // Check if a bill exists for the selected milestone
        $bill_query = "SELECT * FROM ncbilldetails WHERE ncmilestoneID = '$milestoneID'";
        $bill_result = mysqli_query($conn, $bill_query);

        if ($bill_result && mysqli_num_rows($bill_result) > 0) {
            // Update receipt details
            $bill_row = mysqli_fetch_assoc($bill_result);
            $billID = $bill_row['billID'];
            $update_query = "UPDATE ncbilldetails SET receivedAmt = '$receivedAmt', chequeNo = '$chequeNo', receivedDate = '$receivedDate' WHERE billID = '$billID'";
            $update_result = mysqli_query($conn, $update_query);

            if ($update_result) {
                // Redirect to the contracts view page with success message
                $_SESSION['success_message'] = "Receipt details updated successfully.";
                echo '<script>window.location.href = "contracts-view.php?contractID=' . $contractID . '";</script>';
                exit();
            } else {
                echo '<div class="alert alert-danger">Failed to update receipt details.</div>';
            }
        } else {
            echo '<div class="alert alert-danger">No bill exists for the selected milestone.</div>';
        }
    }
} else {
    // If contractID is not provided in the URL, redirect to contracts.php
    header('Location: contracts.php');
    exit();
}
?>

<!-- HTML Form for adding receipt details -->
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3>Add Receipt Details</h3>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]) . '?contractID=' . $contractID; ?>">
                        <div class="mb-3">
                            <label for="milestoneID" class="form-label">Select Milestone</label>
                            <select class="form-select" id="milestoneID" name="milestoneID" required>
                                <option value="">Select a milestone</option>
                                <!-- Populate milestone options dynamically -->
                                <?php
                                $milestone_query = "SELECT ncmilestoneID, milestone FROM ncmilestones WHERE contractID = $contractID";
                                $milestone_result = mysqli_query($conn, $milestone_query);

                                if ($milestone_result && mysqli_num_rows($milestone_result) > 0) {
                                    while ($milestone_row = mysqli_fetch_assoc($milestone_result)) {
                                        echo '<option value="' . $milestone_row['ncmilestoneID'] . '">' . $milestone_row['milestone'] . '</option>';
                                    }
                                } else {
                                    echo '<option value="">No milestones found</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="receivedAmt" class="form-label">Received Amount</label>
                            <input type="text" class="form-control" id="receivedAmt" name="receivedAmt" required>
                        </div>
                        <div class="mb-3">
                            <label for="chequeNo" class="form-label">Cheque Number</label>
                            <input type="text" class="form-control" id="chequeNo" name="chequeNo">
                        </div>
                        <div class="mb-3">
                            <label for="receivedDate" class="form-label">Received Date</label>
                            <input type="date" class="form-control" id="receivedDate" name="receivedDate" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Add Receipt Details</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>