<?php include('includes/header.php'); ?>

<?php
// Check if milestoneID is present in the URL
if (isset($_GET['ncmilestoneID'])) {
    $ncmilestoneID = $_GET['ncmilestoneID'];

    // Retrieve milestone data from the database based on milestoneID
    $query = "SELECT * FROM ncmilestones WHERE ncmilestoneID = $ncmilestoneID";
    $result = mysqli_query($conn, $query);

    if (!$result) {
        die("Query failed: " . mysqli_error($conn));
    }

    if (mysqli_num_rows($result) == 1) {
        $row = mysqli_fetch_assoc($result);
        // Fetch milestone data here and populate the form fields
        $milestone = $row['milestone'];
        $expectedAmt = $row['expectedAmt'];
        $expectedDateBilling = $row['expectedDateBilling'];

        // Fetch the contractID associated with this milestone
        $contractID = $row['contractID'];
    } else {
        echo "Milestone not found.";
        // You can handle this case as needed, e.g., display a message or redirect.
    }
} else {
    echo "Milestone ID not provided.";
    // You can handle this case as needed, e.g., display a message or redirect.
}
?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>
                    Edit Milestone
                    <a href="contracts-view.php?contractID=<?= $contractID; ?>" class="btn btn-danger float-end">Back</a>
                </h4>
            </div>
            <div class="card-body">
                <?php
                // Check if there's an error message in the session
                if (isset($_SESSION['error_message'])) {
                    echo '<div class="alert alert-danger">' . $_SESSION['error_message'] . '</div>';
                    // Clear the error message from the session so it won't display again
                    unset($_SESSION['error_message']);
                }
                ?>

                <form action="code.php" method="POST">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Milestone</label>
                                <input type="text" name="milestone" class="form-control" value="<?= $milestone; ?>" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Milestone Value</label>
                                <input type="number" step="0.01" name="expectedAmt" class="form-control" value="<?= $expectedAmt; ?>" required>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Completion Date</label>
                                <input type="date" name="expectedDateBilling" class="form-control" value="<?= $expectedDateBilling; ?>" required>
                            </div>
                        </div>
                        <input type="hidden" name="ncmilestoneID" value="<?= $ncmilestoneID; ?>">
                        <input type="hidden" name="contractID" value="<?= $contractID; ?>">

                        <div class="col-md-6">
                            <div class="mb-3">
                                <br>
                                <button type="submit" name="updateNCMilestone" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>