<?php
// Include your necessary PHP functions and configuration here, such as the database connection and session start.
include('includes/header.php'); // Include the header

// Check if a project ID is present in the URL
if (!isset($_GET['projectID'])) {
    // Handle the case when projectID is missing in the URL
    echo '<h5>No project ID found!</h5>';
    exit(0);
}

// Retrieve the project ID from the URL
$projectID = $_GET['projectID'];

// Include any necessary validation or data retrieval functions
// For example: include('validation_functions.php');
?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h3>
                    Project Milestones
                    <a href="milestones.php" class="btn btn-danger float-end">Back</a>
                    <a href="milestones-create.php?projectID=<?= $projectID; ?>"
                        class="btn btn-success float-end mx-2">Add Milestone</a>
                </h3>
            </div>
            <div class="project-card">
                <?php
                $paramResult = checkParamId('projectID');
                if (!is_numeric($paramResult)) {
                    echo '<h5>' . $paramResult . '</h5>';
                    return false;
                }

                $projects = getBymId('projects', checkParamId('projectID'));
                ?>

                <div class="row">
                    <div class="col-md-12 mb-4">
                        <div class="card card-body p-3">
                            <h3 class="text-lg mb-0 text-capitalize font-weight-bold">Project Name :
                                <?= $projects['data']['projectName']; ?>
                            </h3>
                            <h3 class="text-lg mb-0 text-capitalize font-weight-bold">Contract Value :
                                <?= $projects['data']['contractValue']; ?>
                            </h3>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <?= alertMessage(); ?>
                <?php 
                if (isset($_SESSION['success_message'])) {
                    echo '<h6><div class="alert alert-success">' . $_SESSION['success_message'] . '</h6></div>';
                    // Remove the success message from the session to prevent it from displaying again
                    unset($_SESSION['success_message']);
                }
                ?>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr class="align-middle text-center">
                            <th>S.No.</th>
                            <th>Milestone</th>
                            <th>Milestone Value</th>
                            <th>Date of Completion</th>
                            <th>% of value</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php

                        $projectID = $_GET['projectID'];

                        // Query the milestones for the specified project
                        $query = "SELECT * FROM milestones WHERE projectID = $projectID";
                        $result = mysqli_query($conn, $query);

                        if (!$result) {
                            die("Query failed: " . mysqli_error($conn));
                        }

                        // Display project name
                        $projectQuery = "SELECT projectName FROM projects WHERE projectID = $projectID";
                        $projectResult = mysqli_query($conn, $projectQuery);
                        $projectRow = mysqli_fetch_assoc($projectResult);
                        $projectName = $projectRow['projectName'];

                        // Close the database connection
                        mysqli_close($conn);
                        ?>
                        <?php
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result)) { ?>
                            <tr class="align-middle text-center">
                                <td>
                                    <?php echo $no; ?>
                                </td>
                                <td>
                                    <?php echo $row['milestoneName']; ?>
                                </td>
                                <td>
                                    <?php echo $row['milestoneValue']; ?>
                                </td>
                                <td>
                                    <?php echo $row['completionDate']; ?>
                                </td>
                                <td>
                                    <?php
                                    $milestoneValue = $row['milestoneValue'];
                                    $contractValue = $projects['data']['contractValue'];
                                    // Check if $contractValue is not zero before performing the calculation
                                    if ($contractValue != 0) {
                                        $percentage = ($milestoneValue / $contractValue) * 100;
                                        echo number_format($percentage, 0) . '%';
                                    } else {
                                        echo 'N/A'; // or handle it in another way based on your requirements
                                    }
                                    ?>
                                </td>
                                <td>
                                    <a href="milestones-edit.php?milestoneID=<?php echo $row['milestoneID']; ?>"
                                        class="btn btn-warning btn-sm">Edit</a>
                                    <a href="milestones-delete.php?milestoneID=<?php echo $row['milestoneID']; ?>"
                                        data-confirm="Are you sure you want to delete this milestone?"
                                        class="btn btn-danger btn-sm delete-link">Delete</a>
                                </td>
                            </tr>
                            <?php $no++;
                        } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- JavaScript to handle confirmation dialog -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        // Add a click event listener to all elements with the "delete-link" class
        $('.delete-link').on('click', function (event) {
            // Prevent the default link behavior
            event.preventDefault();

            // Store the link element (the delete button)
            var deleteButton = $(this);

            // Get the confirmation message from the data-confirm attribute
            var confirmMessage = deleteButton.data('confirm');

            // Show a confirmation dialog
            if (confirm(confirmMessage)) {
                // If the user confirms, proceed with the link's href
                window.location.href = deleteButton.attr('href');
            }
        });
    });
</script>

<?php include('includes/footer.php'); ?>