<?php include('includes/header.php'); ?>

<?php
// Check if milestoneID is present in the URL
if (isset($_GET['milestoneID'])) {
    $milestoneID = $_GET['milestoneID'];

    // Retrieve milestone data from the database based on milestoneID
    $query = "SELECT * FROM milestones WHERE milestoneID = $milestoneID";
    $result = mysqli_query($conn, $query);

    if (!$result) {
        die("Query failed: " . mysqli_error($conn));
    }

    if (mysqli_num_rows($result) == 1) {
        $row = mysqli_fetch_assoc($result);
        // Fetch milestone data here and populate the form fields
        $milestoneName = $row['milestoneName'];
        $milestoneValue = $row['milestoneValue'];
        $completionDate = $row['completionDate'];

        // Fetch the projectID associated with this milestone
        $projectID = $row['projectID'];
    } else {
        echo "Milestone not found.";
        // You can handle this case as needed, e.g., display a message or redirect.
    }
} else {
    echo "Milestone ID not provided.";
    // You can handle this case as needed, e.g., display a message or redirect.
}

?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="card-header">
                    <h4>
                        Edit Milestone
                        <a href="milestones-view.php?projectID=<?= $projectID; ?>"
                            class="btn btn-danger float-end">Back</a>

                    </h4>
                </div>
            </div>
            <div class="card-body">
                <?php
                alertMessage();
                // Check if there's an error message in the session
                if (isset($_SESSION['error_message'])) {
                    echo '<div class="alert alert-danger">' . $_SESSION['error_message'] . '</div>';
                    // Clear the error message from the session so it won't display again
                    unset($_SESSION['error_message']);
                }
                ?>

                <form action="code.php" method="POST">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Milestone</label>
                                <input type="text" name="milestoneName" class="form-control"
                                    value="<?= $milestoneName; ?>">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Milestone Value</label>
                                <input type="text" name="milestoneValue" class="form-control"
                                    value="<?= $milestoneValue; ?>">
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Completion Date</label>
                                <input type="date" name="completionDate" class="form-control"
                                    value="<?= $completionDate; ?>">
                            </div>
                        </div>
                        <input type="hidden" name="milestoneID" value="<?= $milestoneID; ?>">
                        <?php
                        // Include the projectID as a hidden input field if it's available
                        if (isset($_GET['projectID'])) {
                            echo "<input type='text' name='projectID' value='{$_GET['projectID']}'>";
                        }
                        ?>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <br>
                                <button type="submit" name="updateMilestone" class="btn btn-primary">Update</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>