<?php include('includes/header.php'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>
                    Add Milestone
                    <?php
                    // Check if projectID is set in the URL, and if so, include it in the "Back" button link.
                    $backLink = isset($_GET['projectID']) ? "milestones-view.php?projectID=" . $_GET['projectID'] : "milestones.php";
                    ?>
                    <a href="<?= $backLink; ?>" class="btn btn-danger float-end">Back</a>
                </h4>
            </div>
            <div class="card-body">
                <?= alertMessage(); ?>
                <form action="code.php" method="POST">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Milestone</label>
                                <input type="text" name="milestoneName" class="form-control">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Milestone Value</label>
                                <input type="text" name="milestoneValue" class="form-control">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <label>Completion Date</label>
                                <input type="date" name="completionDate" class="form-control">
                            </div>
                        </div>
                        <?php
                        // Include the projectID as a hidden input field if it's available in the URL
                        if (isset($_GET['projectID'])) {
                            echo '<input type="hidden" name="projectID" value="' . $_GET['projectID'] . '">';
                        }
                        ?>

                        <div class="col-md-6">
                            <div class="mb-3">
                                <br>
                                <button type="submit" name="saveMilestone" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="card-header">
                <h4>
                    Project Milestones
                </h4>
            </div>
            <div class="project-card">
                <?php
                $paramResult = checkParamId('projectID');
                if (!is_numeric($paramResult)) {
                    echo '<h5>' . $paramResult . '</h5>';
                    return false;
                }

                $projects = getBymId('projects', checkParamId('projectID'));
                ?>
                
                <div class="row">
                    <div class="col-md-12 mb-4">
                        <div class="card card-body p-3">
                            <?php
                            // Check if projectID is set in the URL
                            if (isset($_GET['projectID'])) {
                                echo '<h3 class="text-sm mb-0 text-capitalize font-weight-bold">Project Name : ' . $projects['data']['projectName'] . '</h3>';
                                echo '<h3 class="text-sm mb-0 text-capitalize font-weight-bold">Contract Value : ' . $projects['data']['contractValue'] . '</h3>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <?= alertMessage(); ?>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr class="align-middle text-center">
                            <th>S.No.</th>
                            <th>Milestone</th>
                            <th>Milestone Value</th>
                            <th>Date of Completion</th>
                            <th>% of value</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Check if projectID is set in the URL
                        if (isset($_GET['projectID'])) {
                            $projectID = $_GET['projectID'];

                            // Query the milestones for the specified project
                            $query = "SELECT * FROM milestones WHERE projectID = $projectID";
                            $result = mysqli_query($conn, $query);

                            if (!$result) {
                                die("Query failed: " . mysqli_error($conn));
                            }

                            // Display project name
                            $projectQuery = "SELECT projectName FROM projects WHERE projectID = $projectID";
                            $projectResult = mysqli_query($conn, $projectQuery);
                            $projectRow = mysqli_fetch_assoc($projectResult);
                            $projectName = $projectRow['projectName'];

                            $no = 1;
                            while ($row = mysqli_fetch_assoc($result)) { ?>
                                <tr class="align-middle text-center">
                                    <td>
                                        <?php echo $no; ?>
                                    </td>
                                    <td>
                                        <?php echo $row['milestoneName']; ?>
                                    </td>
                                    <td>
                                        <?php echo $row['milestoneValue']; ?>
                                    </td>
                                    <td>
                                        <?php echo $row['completionDate']; ?>
                                    </td>
                                    <td>
                                        <?php
                                        $milestoneValue = $row['milestoneValue'];
                                        $contractValue = $projects['data']['contractValue'];
                                        $percentage = ($milestoneValue / $contractValue) * 100;
                                        echo number_format($percentage, 0); // Display percentage with 2 decimal places
                                        ?>%
                                    </td>
                                </tr>
                            <?php $no++;
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>