<?php
// Include your database connection code or configuration here
include('../config/dbcon.php');

if (isset($_POST['projectID'])) {
    // Get the projectID from POST
    $projectID = $_POST['projectID'];

    // Prepare and execute the SQL query to fetch milestones for the selected project
    $milestoneQuery = "SELECT * FROM milestones WHERE projectID = ?";
    $stmt = $conn->prepare($milestoneQuery);
    $stmt->bind_param("i", $projectID);
    $stmt->execute();

    $options = "";
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $options .= "<option value='" . $row['milestoneID'] . "'>" . $row['milestoneName'] . "</option>";
    }

    // Close the prepared statement
    $stmt->close();
    
    // Close the database connection
    $conn->close();

    // Return the HTML options
    echo $options;
} else {
    // Handle the case where projectID is not set in POST data
    echo "Invalid request.";
}
?>