<?php
// Include necessary PHP functions and configuration here, such as the database connection and session start.
include('includes/header.php'); // Include the header

// Check if the vendorID and projectID are present in the URL
if (!isset($_GET['vendorID']) || !isset($_GET['projectID'])) {
    echo '<h5>Vendor ID or Project ID not found!</h5>';
    exit(0);
}

// Retrieve the vendorID and projectID from the URL
$vendorID = validate($_GET['vendorID']);
$projectID = validate($_GET['projectID']);

// Fetch vendor details based on vendorID
$vendorQuery = "SELECT * FROM vendor WHERE vendorID = $vendorID";
$vendorResult = mysqli_query($conn, $vendorQuery);

// Check if the vendor details are fetched successfully
if ($vendorResult && mysqli_num_rows($vendorResult) > 0) {
    $vendorData = mysqli_fetch_assoc($vendorResult);
} else {
    echo '<h5>Vendor details not found!</h5>';
    exit(0);
}

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate and sanitize input data
    $vendorName = validate($_POST['vendorName']);
    $budgetAmount = validate($_POST['budgetAmount']);
    $actualAmount = validate($_POST['actualAmount']);

    // Perform any additional validation as needed

    // Update vendor details in the database
    $updateQuery = "UPDATE vendor SET 
                    vendorName = '$vendorName', 
                    budgetAmount = '$budgetAmount',
                    actualAmount = '$actualAmount'
                    WHERE vendorID = $vendorID";

    if (mysqli_query($conn, $updateQuery)) {
        $_SESSION['status'] = "Vendor details updated successfully.";
    } else {
        $_SESSION['status'] = "Error updating vendor details: " . mysqli_error($conn);
    }

    // Redirect back to the resource plan view page
    echo '<script>window.location.href = "resource-plan-view.php?projectID=' . $projectID . '";</script>';
    exit();
}

?>

<div class="row">
    <div class="col-md-8 offset-md-2">
        <div class="card">
            <div class="card-header">
                <h3 class="mb-4">Edit Vendor Details</h3>
                <a href="resource-plan-view.php?projectID=<?php echo $projectID; ?>" class="btn btn-danger float-end">Back</a>
            </div>
            <div class="card-body">
                <form method="post" action="edit-vendor-details.php?vendorID=<?= $vendorID; ?>&projectID=<?= $projectID; ?>">
                    <div class="mb-3">
                        <label for="vendorName" class="form-label">Vendor Name</label>
                        <input type="text" class="form-control" id="vendorName" name="vendorName" value="<?= $vendorData['vendorName']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="budgetAmount" class="form-label">Budget Amount</label>
                        <input type="text" class="form-control" id="budgetAmount" name="budgetAmount" value="<?= $vendorData['budgetAmount']; ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="actualAmount" class="form-label">Actual Amount</label>
                        <input type="text" class="form-control" id="actualAmount" name="actualAmount" value="<?= $vendorData['actualAmount']; ?>" required>
                    </div>
                    <button type="submit" class="btn btn-success">Update</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>