<?php
// Include necessary PHP functions and configuration here, such as the database connection and session start.
include('includes/header.php'); // Include the header

// Check if the resourceID is present in the URL
if (!isset($_GET['resourceID'])) {
    // Handle the case when resourceID is missing in the URL
    echo '<h5>No resource ID found!</h5>';
    exit(0);
}

// Retrieve the resource ID from the URL
$resourceID = validate($_GET['resourceID']);

// Retrieve the projectID from the URL
if (!isset($_GET['projectID'])) {
    // Handle the case when projectID is missing in the URL
    echo '<h5>No project ID found!</h5>';
    exit(0);
}
$projectID = validate($_GET['projectID']);

// Include any necessary validation or data retrieval functions
// For example: include('validation_functions.php');

// Fetch the resource plan data based on resourceID
$resourcePlanQuery = "SELECT * FROM resourcePlan WHERE resourceID = $resourceID";
$resourcePlanResult = mysqli_query($conn, $resourcePlanQuery);

// Check if the resource plan exists
if (!$resourcePlanResult || mysqli_num_rows($resourcePlanResult) == 0) {
    // Handle the case when resource plan does not exist
    echo '<h5>Resource plan not found!</h5>';
    exit(0);
}

// Fetch the resource plan data
$resourcePlanData = mysqli_fetch_assoc($resourcePlanResult);

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate and sanitize input data
    $milestoneID = validate($_POST['milestoneID']);
    $userID = validate($_POST['userID']);
    $daysBudgeted = validate($_POST['daysBudgeted']);

    // Perform any additional validation as needed

    // Update resource plan data in the database
    $updateQuery = "UPDATE resourcePlan 
                    SET milestoneID = '$milestoneID', userID = '$userID', daysBudgeted = '$daysBudgeted'
                    WHERE resourceID = $resourceID";

    if (mysqli_query($conn, $updateQuery)) {
        // Resource plan updated successfully
        $_SESSION['status'] = "Resource plan updated successfully.";
    } else {
        // Error updating resource plan
        $_SESSION['status'] = "Error: " . mysqli_error($conn);
    }

    // Redirect back to the resource plan view page
    echo '<script>window.location.href = "resource-plan-view.php?projectID=' . $projectID . '";</script>';
    exit();
}

// Include any necessary validation or data retrieval functions
// For example: include('validation_functions.php');
?>

<div class="row">
    <div class="col-md-6 offset-md-3">
        <div class="card">
            <div class="card-header">
                <h3>Edit Resource Plan</h3>
            </div>
            <div class="card-body">
                <form method="post" action="edit-resource-plan.php?resourceID=<?= $resourceID; ?>&projectID=<?= $projectID; ?>">
                    <div class="mb-3">
                        <label for="milestoneSelect" class="form-label">Select Milestone</label>
                        <select class="form-select" id="milestoneSelect" name="milestoneID">
                            <option value="" selected disabled>Select Milestone</option>
                            <?php
                            // Fetch milestones associated with the project from the database
                            $milestoneQuery = "SELECT milestoneID, milestoneName FROM milestones WHERE projectID = $projectID";
                            $milestoneResult = mysqli_query($conn, $milestoneQuery);

                            if ($milestoneResult && mysqli_num_rows($milestoneResult) > 0) {
                                while ($row = mysqli_fetch_assoc($milestoneResult)) {
                                    // Check if the milestone is selected
                                    $selected = ($row['milestoneID'] == $resourcePlanData['milestoneID']) ? 'selected' : '';
                                    echo '<option value="' . $row['milestoneID'] . '" ' . $selected . '>' . $row['milestoneName'] . '</option>';
                                }
                            } else {
                                echo '<option value="">No milestones found</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="userSelect" class="form-label">Select User</label>
                        <select class="form-select" id="userSelect" name="userID">
                            <option value="" selected disabled>Select User</option>
                            <?php
                            // Fetch all users from the database
                            $userQuery = "SELECT userID, CONCAT(fname, ' ', lname) AS fullName FROM users";
                            $userResult = mysqli_query($conn, $userQuery);

                            if ($userResult && mysqli_num_rows($userResult) > 0) {
                                while  ($row = mysqli_fetch_assoc($userResult)) {
                                    // Check if the user is selected
                                    $selected = ($row['userID'] == $resourcePlanData['userID']) ? 'selected' : '';
                                    echo '<option value="' . $row['userID'] . '" ' . $selected . '>' . $row['fullName'] . '</option>';
                                }
                            } else {
                                echo '<option value="">No users found</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="daysBudgeted" class="form-label">Budgeted Days</label>
                        <input type="text" class="form-control" id="daysBudgeted" name="daysBudgeted" value="<?= $resourcePlanData['daysBudgeted']; ?>">
                    </div>
                    <button type="submit" class="btn btn-primary">Update</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>
                                
