<?php
// Include necessary PHP functions and configuration here, such as the database connection and session start.
include('includes/header.php'); // Include the header

// Check if the vendorID and projectID are present in the URL
if (!isset($_GET['vendorID']) || !isset($_GET['projectID'])) {
    echo '<h5>Vendor ID or Project ID not found!</h5>';
    exit(0);
}

// Retrieve the vendorID and projectID from the URL
$vendorID = validate($_GET['vendorID']);
$projectID = validate($_GET['projectID']);

// Fetch vendor details based on vendorID
$vendorQuery = "SELECT * FROM vendor WHERE vendorID = $vendorID";
$vendorResult = mysqli_query($conn, $vendorQuery);

// Check if the vendor details are fetched successfully
if ($vendorResult && mysqli_num_rows($vendorResult) > 0) {
    $vendorData = mysqli_fetch_assoc($vendorResult);
} else {
    echo '<h5>Vendor details not found!</h5>';
    exit(0);
}

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Perform delete operation

    // Start a transaction
    mysqli_begin_transaction($conn);

    // Delete vendor from the vendors table
    $deleteVendorQuery = "DELETE FROM vendor WHERE vendorID = $vendorID";

    if (mysqli_query($conn, $deleteVendorQuery)) {
        // Vendor deleted successfully, now delete related entries from resource plan
        $deleteResourcePlanQuery = "DELETE FROM resourcePlan WHERE vendorID = $vendorID";

        if (mysqli_query($conn, $deleteResourcePlanQuery)) {
            // Commit the transaction
            mysqli_commit($conn);
            $_SESSION['status'] = "Vendor details and related resource plans deleted successfully.";
        } else {
            // Rollback the transaction on resource plan delete failure
            mysqli_rollback($conn);
            $_SESSION['status'] = "Error deleting resource plans: " . mysqli_error($conn);
        }
    } else {
        // Error deleting vendor
        $_SESSION['status'] = "Error deleting vendor: " . mysqli_error($conn);
    }

    // Redirect back to the resource plan view page
    echo '<script>window.location.href = "resource-plan-view.php?projectID=' . $projectID . '";</script>';
    exit();
}

?>

<div class="row">
    <div class="col-md-6 offset-md-3">
        <div class="card">
            <div class="card-header">
                <h3>Delete Vendor Details</h3>
            </div>
            <div class="card-body">
                <p>Are you sure you want to delete the following vendor details?</p>
                <p><strong>Vendor Name:</strong> <?= $vendorData['vendorName']; ?></p>
                <p><strong>Budget Amount:</strong> <?= $vendorData['budgetAmount']; ?></p>
                <p><strong>Actual Amount:</strong> <?= $vendorData['actualAmount']; ?></p>

                <form method="post">
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <a href="resource-plan-view.php?projectID=<?= $projectID; ?>" class="btn btn-secondary">Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>