<?php
// Include necessary PHP functions and configuration here, such as the database connection and session start.
include('includes/header.php'); // Include the header

// Check if the resourceID and projectID are present in the URL
if (!isset($_GET['resourceID']) || !isset($_GET['projectID'])) {
    echo '<h5>Resource ID or Project ID not found!</h5>';
    exit(0);
}

// Retrieve the resourceID and projectID from the URL
$resourceID = validate($_GET['resourceID']);
$projectID = validate($_GET['projectID']);

// Fetch resource plan details based on resourceID
$resourcePlanQuery = "SELECT * FROM resourcePlan WHERE resourceID = $resourceID";
$resourcePlanResult = mysqli_query($conn, $resourcePlanQuery);

// Check if the resource plan details are fetched successfully
if ($resourcePlanResult && mysqli_num_rows($resourcePlanResult) > 0) {
    $resourcePlanData = mysqli_fetch_assoc($resourcePlanResult);
} else {
    echo '<h5>Resource plan details not found!</h5>';
    exit(0);
}

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Perform delete operation

    // Delete resource plan from the database
    $deleteQuery = "DELETE FROM resourcePlan WHERE resourceID = $resourceID";

    if (mysqli_query($conn, $deleteQuery)) {
        // Resource plan deleted successfully
        $_SESSION['status'] = "Resource plan deleted successfully.";
    } else {
        // Error deleting resource plan
        $_SESSION['status'] = "Error: " . mysqli_error($conn);
    }

    // Redirect back to the resource plan view page
    echo '<script>window.location.href = "resource-plan-view.php?projectID=' . $projectID . '";</script>';
    exit();
}

?>

<div class="row">
    <div class="col-md-6 offset-md-3">
        <div class="card">
            <div class="card-header">
                <h3>Delete Resource Plan</h3>
            </div>
            <div class="card-body">
                <p>Are you sure you want to delete the following resource plan?</p>
                <p><strong>User:</strong> <?= $resourcePlanData['userID']; ?></p>
                <p><strong>Milestone:</strong> <?= $resourcePlanData['milestoneID']; ?></p>
                <p><strong>Days Budgeted:</strong> <?= $resourcePlanData['daysBudgeted']; ?></p>

                <form method="post">
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <a href="resource-plan-view.php?projectID=<?= $projectID; ?>" class="btn btn-secondary">Cancel</a>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>