<?php include('includes/header.php'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>
                    Contracts List
                    <a href="contracts-create.php" class="btn btn-primary float-end">Add Contract</a>
                </h4>
            </div>
            <div class="card-body">
                <?= alertMessage(); ?>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr class="align-middle text-center">
                            <th>S.No.</th>
                            <th>Client Name</th>
                            <th>Contract Name</th>
                            <th>Contract Number</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        $contracts = linkALL('contracts');
                        if (mysqli_num_rows($contracts) > 0) {
                            foreach ($contracts as $contractItem) {
                                ?>
                                <tr class="align-middle text-center text-xs">
                                    <td><?= $no; ?></td>
                                    <td><?= $contractItem['clientName']; ?></td>
                                    <td><?= $contractItem['contractName']; ?></td>
                                    <td><?= $contractItem['contractNo']; ?></td>
                                    <td>
                                        <a href="contracts-view.php?contractID=<?= $contractItem['contractID']; ?>" class="btn btn-info btn-sm">View</a>
                                        <a href="contracts-edit.php?contractID=<?= $contractItem['contractID']; ?>" class="btn btn-success btn-sm">Edit</a>
                                        <a href="contracts-delete.php?contractID=<?= $contractItem['contractID']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this contract?')">Delete</a>
                                    </td>
                                </tr>
                                <?php
                                $no++;
                            }
                        } else {
                            ?>
                            <tr>
                                <td colspan="5">No record Found</td>
                            </tr>
                            <?php
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>