<?php
include('includes/header.php');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (isset($_GET['contractID'])) {
    $contractID = validate($_GET['contractID']);

    // Query to fetch contract and project details based on contractID
    $query = "SELECT contracts.contractNo, clients.clientName, contracts.contractName, contracts.contractAmt, 
              contracts.ncstartDate, contracts.ncendDate
              FROM contracts
              INNER JOIN projects ON contracts.contractID = projects.contractID
              INNER JOIN clients ON projects.clientID = clients.clientID
              WHERE contracts.contractID = '$contractID'";

    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $contractData = mysqli_fetch_assoc($result);
        ?>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>Contract Details
                        <a href="contracts.php" class="btn btn-danger float-end">Back</a>
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="col-md-12 mb-2">
                            <div class="card card-body p-3">
                                <h3 class="text-lg mb-2 text-capitalize font-weight-bold">Contract No. :
                                    <?= $contractData['contractNo']; ?>
                                </h3>
                                <h3 class="text-lg mb-2 text-capitalize font-weight-bold">Client Name :
                                    <?= $contractData['clientName']; ?>
                                </h3>
                                <h3 class="text-lg mb-2 text-capitalize font-weight-bold">Contract Name :
                                    <?= $contractData['contractName']; ?>
                                </h3>
                                <h3 class="text-lg mb-2 text-capitalize font-weight-bold">Contract Amount :
                                    <?= $contractData['contractAmt']; ?>
                                </h3>
                                <h3 class="text-lg mb-2 text-capitalize font-weight-bold">Start Date :
                                    <?= $contractData['ncstartDate']; ?>
                                </h3>
                                <h3 class="text-lg mb-2 text-capitalize font-weight-bold">End Date :
                                    <?= $contractData['ncendDate']; ?>
                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h3>Contract Milestones
                            <a href="ncmilestones-create.php?contractID=<?= $contractID ?>" class="btn btn-primary float-end">Add Milestone</a>
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="col-md-12 mb-2">
                            <div class="card card-body p-3">
                                <?= alertMessage(); ?>
                                <?php
                                if (isset($_SESSION['success_message'])) {
                                    echo '<h6><div class="alert alert-success">' . $_SESSION['success_message'] . '</h6></div>';
                                    // Remove the success message from the session to prevent it from displaying again
                                    unset($_SESSION['success_message']);
                                }
                                ?>
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr class="align-middle text-center">
                                            <th>S.No.</th>
                                            <th>Milestone</th>
                                            <th>Expected Amount</th>
                                            <th>Date of Completion</th>
                                            <th>% of value</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php

                                        // Query the milestones for the specified contract
                                        $query = "SELECT * FROM ncmilestones WHERE contractID = $contractID";
                                        $result = mysqli_query($conn, $query);

                                        if (!$result) {
                                            die("Query failed: " . mysqli_error($conn));
                                        }

                                        ?>
                                        <?php
                                        $no = 1;
                                        while ($row = mysqli_fetch_assoc($result)) { ?>
                                            <tr class="align-middle text-center">
                                                <td>
                                                    <?php echo $no; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['milestone']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['expectedAmt']; ?>
                                                </td>
                                                <td>
                                                    <?php echo $row['expectedDateBilling']; ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    $expectedAmt = $row['expectedAmt'];
                                                    $contractAmt = $contractData['contractAmt'];
                                                    // Check if $contractValue is not zero before performing the calculation
                                                    if ($contractAmt != 0) {
                                                        $percentage = ($expectedAmt / $contractAmt) * 100;
                                                        echo number_format($percentage, 0) . '%';
                                                    } else {
                                                        echo 'N/A'; // or handle it in another way based on your requirements
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <a href="ncmilestones-edit.php?ncmilestoneID=<?php echo $row['ncmilestoneID']; ?>"
                                                        class="btn btn-warning btn-sm">Edit</a>
                                                    <a href="ncmilestones-delete.php?ncmilestoneID=<?php echo $row['ncmilestoneID']; ?>"
                                                        class="btn btn-danger btn-sm"
                                                        onclick="return confirm('Are you sure you want to delete this milestone?')">Delete</a>
                                                </td>
                                            </tr>
                                            <?php $no++;
                                        } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h3>Billing Details
                            <a href="billing-create.php?contractID=<?= $contractID ?>" class="btn btn-primary float-end">Add Billing Details</a>
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="col-md-12 mb-2">
                            <div class="card card-body p-3">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr class="align-middle text-center">
                                            <th>S. No.</th>
                                            <th>Milestone</th>
                                            <th>Bill Number</th>
                                            <th>Billing Amount</th>
                                            <th>Billing Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        // Query the billing details for the specified contract
                                        $billing_query = "SELECT * FROM ncbilldetails INNER JOIN ncmilestones ON ncbilldetails.ncmilestoneID = ncmilestones.ncmilestoneID WHERE ncmilestones.contractID = $contractID";
                                        $billing_result = mysqli_query($conn, $billing_query);

                                        if (!$billing_result) {
                                            die("Query failed: " . mysqli_error($conn));
                                        }

                                        $no = 1;
                                        while ($billing_row = mysqli_fetch_assoc($billing_result)) { ?>
                                            <tr class="align-middle text-center">
                                                <td><?= $no; ?></td>
                                                <td><?= $billing_row['milestone']; ?></td>
                                                <td><?= $billing_row['billNo']; ?></td>
                                                <td><?= $billing_row['billAmount']; ?></td>
                                                <td><?= $billing_row['billDate']; ?></td>
                                                <td>
                                                    <a href="billing-edit.php?billID=<?= $billing_row['billID']; ?>" class="btn btn-warning btn-sm">Edit</a>
                                                </td>
                                            </tr>
                                            <?php $no++;
                                        } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h3>Receipt Details
                            <a href="receipt-create.php?contractID=<?= $contractID ?>" class="btn btn-primary float-end">Add Receipt Details</a>
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="col-md-12 mb-2">
                            <div class="card card-body p-3">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr class="align-middle text-center">
                                            <th>S. No.</th>
                                            <th>Milestone</th>
                                            <th>Bill Number</th>
                                            <th>Billing Amount</th>
                                            <th>Received Date</th>
                                            <th>Received Amount</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        // Query the billing details for the specified contract
                                        $billing_query = "SELECT * FROM ncbilldetails INNER JOIN ncmilestones ON ncbilldetails.ncmilestoneID = ncmilestones.ncmilestoneID WHERE ncmilestones.contractID = $contractID";
                                        $billing_result = mysqli_query($conn, $billing_query);

                                        if (!$billing_result) {
                                            die("Query failed: " . mysqli_error($conn));
                                        }

                                        $no = 1;
                                        while ($billing_row = mysqli_fetch_assoc($billing_result)) { ?>
                                            <tr class="align-middle text-center">
                                                <td><?= $no; ?></td>
                                                <td><?= $billing_row['milestone']; ?></td>
                                                <td><?= $billing_row['billNo']; ?></td>
                                                <td><?= $billing_row['billAmount']; ?></td>
                                                <td><?= $billing_row['receivedDate']; ?></td>
                                                <td><?= $billing_row['receivedAmt']; ?></td>
                                                <td>
                                                    <a href="receipt-edit.php?billID=<?= $billing_row['billID']; ?>" class="btn btn-warning btn-sm">Edit</a>
                                                </td>
                                            </tr>
                                            <?php $no++;
                                        } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    } else {
        echo '<div class="alert alert-warning">Contract details not found.</div>';
    }
} else {
    // If contractID is not provided, redirect to contracts.php
    header('Location: contracts.php');
    exit();
}
include('includes/footer.php');
?>