<?php
include('includes/header.php');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Assuming you have a function to fetch contract details by contractID
if(isset($_GET['contractID'])) {
    $contractID = validate($_GET['contractID']);
    $contractDetails = getContractDetails($contractID);

    if(!$contractDetails) {
        // Redirect to contracts.php if contract details are not found
        header('Location: contracts.php');
        exit();
    }
} else {
    // Redirect to contracts.php if contractID is not provided
    header('Location: contracts.php');
    exit();
}

// Fetch client names from the clients table
$clientsQuery = mysqli_query($conn, "SELECT * FROM clients ORDER BY clientName ASC");
$clients = mysqli_fetch_all($clientsQuery, MYSQLI_ASSOC);

// Fetch all users from the users table
$usersQuery = mysqli_query($conn, "SELECT * FROM users ORDER BY fname ASC");
$users = mysqli_fetch_all($usersQuery, MYSQLI_ASSOC);

// Fetch project details from the projects table
$projectQuery = mysqli_query($conn, "SELECT clientID, projectCoord, teamLead FROM projects WHERE contractID = '$contractID'");
$projectDetails = mysqli_fetch_assoc($projectQuery);

// Now, use $projectDetails to preselect values in your dropdowns
$clientIDFromProject = isset($projectDetails['clientID']) ? $projectDetails['clientID'] : '';
$projectCoordFromProject = isset($projectDetails['projectCoord']) ? $projectDetails['projectCoord'] : '';
$teamLeadFromProject = isset($projectDetails['teamLead']) ? $projectDetails['teamLead'] : '';
?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>Edit Contract</h4>
            </div>
            <div class="card-body">
                <!-- Your form starts here -->
                <form action="process-contracts-edit.php" method="post">
                    <!-- Hidden field to store contractID for updating -->
                    <input type="hidden" name="contractID" value="<?= $contractID; ?>">

                    <!-- Contract Number -->
                    <div class="mb-3">
                        <label for="contractNo" class="form-label">Contract No.</label>
                        <input type="text" class="form-control" id="contractNo" name="contractNo" value="<?= $contractDetails['contractNo']; ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="clientName" class="form-label">Client Name</label>
                        <select class="form-select" id="clientName" name="clientID" required>
                            <?php
                            foreach ($clients as $client) {
                                $selected = ($client['clientID'] == $clientIDFromProject) ? 'selected' : '';
                                echo "<option value=\"{$client['clientID']}\" {$selected}>{$client['clientName']}</option>";
                            }
                            ?>
                        </select>
                    </div>

                    <!-- Project Coordinator Dropdown -->
                    <div class="mb-3">
                        <label for="projectCoord" class="form-label">Project Coordinator</label>
                        <select class="form-select" id="projectCoord" name="projectCoord" required>
                            <option value="" <?php echo empty($projectCoordFromProject) ? 'selected' : ''; ?>>Select Project Coordinator</option>
                            <?php
                            foreach ($users as $user) {
                                $selected = ($user['userID'] == $projectCoordFromProject) ? 'selected' : '';
                                echo "<option value=\"{$user['userID']}\" {$selected}>{$user['fname']} {$user['lname']}</option>";
                            }
                            ?>
                        </select>
                    </div>

                    <!-- Team Leader Dropdown -->
                    <div class="mb-3">
                        <label for="teamLead" class="form-label">Team Leader</label>
                        <select class="form-select" id="teamLead" name="teamLead" required>
                            <option value="" <?php echo empty($teamLeadFromProject) ? 'selected' : ''; ?>>Select Team Leader</option>
                            <?php
                            foreach ($users as $user) {
                                $selected = ($user['userID'] == $teamLeadFromProject) ? 'selected' : '';
                                echo "<option value=\"{$user['userID']}\" {$selected}>{$user['fname']} {$user['lname']}</option>";
                            }
                            ?>
                        </select>
                    </div>

                    <!-- Contract Name -->
                    <div class="mb-3">
                        <label for="contractName" class="form-label">Contract Name</label>
                        <input type="text" class="form-control" id="contractName" name="contractName" value="<?= $contractDetails['contractName']; ?>" required>
                    </div>
                    
                    <!-- Contract Amount -->
                    <div class="mb-3">
                        <label for="contractAmount" class="form-label">Contract Amount</label>
                        <input type="text" class="form-control" id="contractAmount" name="contractAmount" value="<?= $contractDetails['contractAmt']; ?>" required>
                    </div>
                    
                    <!-- Tax Details -->
                    <div class="mb-3">
                        <label for="taxDetails" class="form-label">Tax Details</label>
                        <input type="text" class="form-control" id="taxDetails" name="taxDetails" value="<?= $contractDetails['taxDetails']; ?>">
                    </div>
                    
                    <!-- Client PO Number -->
                    <div class="mb-3">
                        <label for="clientPONumber" class="form-label">Client PO Number</label>
                        <input type="text" class="form-control" id="clientPONumber" name="clientPONumber" value="<?= $contractDetails['clientPONo']; ?>">
                    </div>
                    
                    <!-- Start Date -->
                    <div class="mb-3">
                        <label for="startDate" class="form-label">Start Date</label>
                        <input type="date" class="form-control" id="startDate" name="startDate" value="<?= $contractDetails['ncstartDate']; ?>" required>
                    </div>
                    
                    <!-- End Date -->
                    <div class="mb-3">
                        <label for="endDate" class="form-label">End Date</label>
                        <input type="date" class="form-control" id="endDate" name="endDate" value="<?= $contractDetails['ncendDate']; ?>" required>
                    </div>

                    <button type="submit" class="btn btn-primary">Update Contract</button>
                </form>
                <!-- Your form ends here -->
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>