<?php
include('includes/header.php');

// Fetch client names from the clients table
$clientsQuery = mysqli_query($conn, "SELECT * FROM clients ORDER BY clientName ASC");
if (!$clientsQuery) {
    die("Database query failed: " . mysqli_error($conn));
}
$clients = mysqli_fetch_all($clientsQuery, MYSQLI_ASSOC);

// Fetch all users from the users table
$usersQuery = mysqli_query($conn, "SELECT * FROM users ORDER BY fname ASC");
if (!$usersQuery) {
    die("Database query failed: " . mysqli_error($conn));
}
$users = mysqli_fetch_all($usersQuery, MYSQLI_ASSOC);
?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>Create Contract</h4>
            </div>
            <div class="card-body">
                <!-- Your form starts here -->
                <form action="process-contracts-create.php" method="post">
                    <!-- Contract Number -->
                    <div class="mb-3">
                        <label for="contractNo" class="form-label">Contract No.</label>
                        <input type="text" class="form-control" id="contractNo" name="contractNo" required>
                    </div>

                    <!-- Client Name Dropdown -->
                    <div class="mb-3">
                        <label for="clientName" class="form-label">Client Name</label>
                        <select class="form-select" id="clientName" name="clientID" required>
                            <option value="">Select Client</option>
                            <?php foreach ($clients as $client): ?>
                                <option value="<?php echo htmlspecialchars($client['clientID']); ?>">
                                    <?php echo htmlspecialchars($client['clientName']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Project Coordinator Dropdown -->
                    <div class="mb-3">
                        <label for="projectCoord" class="form-label">Project Coordinator</label>
                        <select class="form-select" id="projectCoord" name="projectCoord" required>
                            <option value="">Select Project Coordinator</option>
                            <?php foreach ($users as $user): ?>
                                <option value="<?php echo htmlspecialchars($user['userID']); ?>">
                                    <?php echo htmlspecialchars($user['fname'] . ' ' . $user['lname']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Team Leader Dropdown -->
                    <div class="mb-3">
                        <label for="teamLead" class="form-label">Team Leader</label>
                        <select class="form-select" id="teamLead" name="teamLead" required>
                            <option value="">Select Team Leader</option>
                            <?php foreach ($users as $user): ?>
                                <option value="<?php echo htmlspecialchars($user['userID']); ?>">
                                    <?php echo htmlspecialchars($user['fname'] . ' ' . $user['lname']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Contract Name -->
                    <div class="mb-3">
                        <label for="contractName" class="form-label">Contract Name</label>
                        <input type="text" class="form-control" id="contractName" name="contractName" required>
                    </div>
                    
                    <!-- Contract Amount -->
                    <div class="mb-3">
                        <label for="contractAmount" class="form-label">Contract Amount</label>
                        <input type="text" class="form-control" id="contractAmount" name="contractAmount" required>
                    </div>
                    
                    <!-- Tax Details -->
                    <div class="mb-3">
                        <label for="taxDetails" class="form-label">Tax Details</label>
                        <input type="text" class="form-control" id="taxDetails" name="taxDetails">
                    </div>
                    
                    <!-- Client PO Number -->
                    <div class="mb-3">
                        <label for="clientPONumber" class="form-label">Client PO Number</label>
                        <input type="text" class="form-control" id="clientPONumber" name="clientPONumber">
                    </div>
                    
                    <!-- Start Date -->
                    <div class="mb-3">
                        <label for="startDate" class="form-label">Start Date</label>
                        <input type="date" class="form-control" id="startDate" name="startDate" required>
                    </div>
                    
                    <!-- End Date -->
                    <div class="mb-3">
                        <label for="endDate" class="form-label">End Date</label>
                        <input type="date" class="form-control" id="endDate" name="endDate" required>
                    </div>

                    <button type="submit" class="btn btn-primary">Create Contract</button>
                </form>
                <!-- Your form ends here -->
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>