<?php include('includes/header.php'); ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h4>
                    Clients Lists
                    <a href="clients-create.php" class="btn btn-primary float-end">Add Client</a>
                </h4>
            </div>
            <div class="card-body">
                <?= alertMessage(); ?>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th class="align-middle text-center">S.No.</th>
                            <th class="align-middle text-center">Client Name</th>
                            <th class="align-middle text-center">Client Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $no = 1;
                        $clients = getALL('clients');
                        
                        if (mysqli_num_rows($clients) > 0) {
                            // Create an empty array to store client data for sorting
                            $clientArray = array();
                        
                            while ($clientItem = mysqli_fetch_assoc($clients)) {
                                $clientArray[] = $clientItem;
                            }
                        
                            // Sort the client data by "clientName" in ascending order
                            usort($clientArray, function ($a, $b) {
                                return strcmp($a['clientName'], $b['clientName']);
                            });
                        
                            foreach ($clientArray as $clientItem) {
                                ?>
                                <tr>
                                    <td class="align-middle text-center"><?= $no; ?></td>
                                    <td class="align-middle text-center"><?= $clientItem['clientName']; ?></td>
                                    <td class="align-middle text-center">
                                        <a href="clients-edit.php?clientID=<?= $clientItem['clientID']; ?>" class="btn btn-success btn-sm">Edit</a>
                                        <a href="clients-delete.php?clientID=<?= $clientItem['clientID']; ?>"
                                             class="btn btn-danger btn-sm mx-2"
                                             onclick="return confirm('Are you sure yo want to delete this data?')">
                                             Delete
                                            </a>
                                    </td>
                                </tr>
                                <?php
                                $no++;
                            }
                        } else {
                            ?>
                            <tr>
                                <td colspan="2">No record Found</td>
                            </tr>
                            <?php
                        }
                        ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>