<?php
include('includes/header.php');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check if contractID is provided in the URL
if (isset($_GET['contractID'])) {
    $contractID = validate($_GET['contractID']);

    // Handle form submission
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Retrieve billing details from the form
        $milestoneID = validate($_POST['milestoneID']);
        $billNo = validate($_POST['billNo']);
        $billAmount = validate($_POST['billAmount']);
        $billDate = validate($_POST['billDate']);
        $expRecDate = validate($_POST['expRecDate']);

        // Insert billing details into the database
        $insert_query = "INSERT INTO ncbilldetails (ncmilestoneID, billNo, billAmount, billDate, expRecDate) VALUES ('$milestoneID', '$billNo', '$billAmount', '$billDate', '$expRecDate')";
        $insert_result = mysqli_query($conn, $insert_query);

        if ($insert_result) {
            // Redirect to the contracts view page with success message
            $_SESSION['success_message'] = "Billing details added successfully.";
            // JavaScript redirection
            echo '<script>window.location.href = "contracts-view.php?contractID=' . $contractID . '";</script>';
            exit();
        } else {
            echo '<div class="alert alert-danger">Failed to add billing details.</div>';
        }
    }
} else {
    // If contractID is not provided in the URL, redirect to contracts.php
    header('Location: contracts.php');
    exit();
}
?>

<!-- HTML Form for adding billing details -->
<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3>Add Billing Details</h3>
                </div>
                <div class="card-body">
                    <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]) . '?contractID=' . $contractID; ?>">
                        <!-- Here, you can include a dropdown/select option to choose the milestone -->
                        <div class="mb-3">
                            <label for="milestoneID" class="form-label">Milestone</label>
                            <select class="form-select" id="milestoneID" name="milestoneID" required>
                                <option value="">Select a milestone</option>
                                <!-- Populate milestone options dynamically -->
                                <?php
                                $milestone_query = "SELECT ncmilestoneID, milestone FROM ncmilestones WHERE contractID = $contractID";
                                $milestone_result = mysqli_query($conn, $milestone_query);
                            
                                if ($milestone_result && mysqli_num_rows($milestone_result) > 0) {
                                    while ($milestone_row = mysqli_fetch_assoc($milestone_result)) {
                                        echo '<option value="' . $milestone_row['ncmilestoneID'] . '">' . $milestone_row['milestone'] . '</option>';
                                    }
                                } else {
                                    echo '<option value="">No milestones found</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="billNo" class="form-label">Bill Number</label>
                            <input type="text" class="form-control" id="billNo" name="billNo" required>
                        </div>
                        <div class="mb-3">
                            <label for="billAmount" class="form-label">Billing Amount</label>
                            <input type="text" class="form-control" id="billAmount" name="billAmount" required>
                        </div>
                        <div class="mb-3">
                            <label for="billDate" class="form-label">Billing Date</label>
                            <input type="date" class="form-control" id="billDate" name="billDate" required>
                        </div>
                        <div class="mb-3">
                            <label for="expRecDate" class="form-label">Expected Receive Date</label>
                            <input type="date" class="form-control" id="expRecDate" name="expRecDate" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Add Billing Details</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>