<?php
include('includes/header.php');

if (!isset($_GET['projectID'])) {
    echo '<h5>No project ID found!</h5>';
    exit(0);
}

$projectID = validate($_GET['projectID']);

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate and sanitize input data
    $milestoneID = validate($_POST['milestoneID']);
    $vendorName = validate($_POST['vendorName']);
    $budgetAmount = validate($_POST['budgetAmount']);
    $actualAmount = validate($_POST['actualAmount']);

    // Insert vendor data into the vendor table
    $insertVendorQuery = "INSERT INTO vendor (vendorName, budgetAmount, actualAmount) VALUES ('$vendorName', '$budgetAmount', '$actualAmount')";

    if (mysqli_query($conn, $insertVendorQuery)) {
        $vendorID = mysqli_insert_id($conn); // Get the inserted vendor ID

        // Insert resource plan data with userID 1001 for the vendor
        $insertResourcePlanQuery = "INSERT INTO resourcePlan (projectID, milestoneID, userID, vendorID, daysBudgeted)
                                    VALUES ('$projectID', '$milestoneID', 1001, '$vendorID', 0)";

        if (mysqli_query($conn, $insertResourcePlanQuery)) {
            $_SESSION['status'] = "Vendor details added successfully.";
        } else {
            $_SESSION['status'] = "Error: " . mysqli_error($conn);
        }
    } else {
        $_SESSION['status'] = "Error: " . mysqli_error($conn);
    }

    echo '<script>window.location.href = "resource-plan-view.php?projectID=' . $projectID . '";</script>';
    exit();
}
?>

<div class="row">
    <div class="col-md-8 offset-md-2">
        <div class="card">
            <div class="card-header">
                <h3 class="mb-4">Add Vendor Details</h3>
                <a href="resource-plan-view.php?projectID=<?php echo $projectID; ?>" class="btn btn-danger float-end">Back</a>
                <?php
                $projectQuery = "SELECT projectName FROM projects WHERE projectID = $projectID";
                $projectResult = mysqli_query($conn, $projectQuery);

                if ($projectResult && mysqli_num_rows($projectResult) > 0) {
                    $projectData = mysqli_fetch_assoc($projectResult);
                    echo '<h6>Project Name: ' . $projectData['projectName'] . '</h6>';
                } else {
                    echo '<span class="text-danger">Project details not found</span>';
                }
                ?>
            </div>
            <div class="card-body">
                <form action="" method="POST">
                    <div class="mb-3">
                        <label for="milestoneSelect" class="form-label">Select Milestone</label>
                        <select class="form-select" id="milestoneSelect" name="milestoneID">
                            <option value="" selected disabled>Select Milestone</option>
                            <?php
                            // Fetch milestones associated with the project from the database
                            $milestoneQuery = "SELECT milestoneID, milestoneName FROM milestones WHERE projectID = $projectID";
                            $milestoneResult = mysqli_query($conn, $milestoneQuery);

                            if ($milestoneResult && mysqli_num_rows($milestoneResult) > 0) {
                                while ($row = mysqli_fetch_assoc($milestoneResult)) {
                                    echo '<option value="' . $row['milestoneID'] . '">' . $row['milestoneName'] . '</option>';
                                }
                            } else {
                                echo '<option value="">No milestones found</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="vendorName" class="form-label">Vendor Name</label>
                        <input type="text" id="vendorName" name="vendorName" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="budgetAmount" class="form-label">Budget Amount</label>
                        <input type="number" id="budgetAmount" name="budgetAmount" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="actualAmount" class="form-label">Actual Amount</label>
                        <input type="number" id="actualAmount" name="actualAmount" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Add Vendor</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>