<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'te', version '4.3'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'ఈ <a href=":url" target="_blank">ఉపయోగ నిబంధనలు  అంగీకరిస్తాను</a>';
$string['accountdetailslinktext'] = 'ఇక్కడ';
$string['action'] = 'యాక్షన్';
$string['add'] = 'చేర్చు';
$string['addedandupdatedpp'] = '{$a->%new} కొత్త H5P లైబ్రరీలను జోడించి, {$a->%old} పాతవి నవీకరించబడింది.';
$string['addedandupdatedps'] = '{$a->%new} కొత్త H5P లైబ్రరీలను జోడించి, {$a->%old} పాతది నవీకరించబడింది.';
$string['addedandupdatedsp'] = '{$a->%new} కొత్త H5P లైబ్రరీ జోడించబడింది మరియు {$a ->%old} పాతవి నవీకరించబడింది.';
$string['addedandupdatedss'] = '{$a->%new} కొత్త H5P లైబ్రరీ జోడించబడింది మరియు {$a ->%old} పాతది నవీకరించబడింది.';
$string['addednewlibraries'] = '{$a->%new} కొత్త H5P లైబ్రరీలు జోడించబడ్డాయి.';
$string['addednewlibrary'] = '{$a->%new} కొత్త H5P లైబ్రరీ జోడించబడింది.';
$string['additionalinfo'] = 'అదనపు సమాచారం';
$string['additionallicenseinfo'] = 'లైసెన్స్ విషయమై ఏదైనా అదనపు సమాచారం';
$string['addlibraries'] = 'లైబ్రరీలను జోడించండి';
$string['address'] = 'చిరునామా';
$string['age'] = 'వయసు';
$string['agedescription'] = 'ఈ కంటెంట్ యొక్క లక్ష్య ప్రేక్షకులు. కామాలతో వేరు చేయబడిన ఇన్‌పుట్ ఫార్మాట్‌లు:  "1,34-45,-50,59-".';
$string['ajaxfailed'] = 'డేటాను లోడ్ చేయడంలో విఫలమైంది.';
$string['alttext'] = 'ఆల్ట్ టెక్స్ట్  / ప్రత్యామ్నాయ టెక్స్ట్';
$string['anunexpectedsave'] = 'అనుకోనిది జరిగింది. మేము ఈ కంటెంట్‌ని సేవ్ చేయలేకపోయాము.';
$string['assistivetechnologieslabel'] = 'అసివ్ టెక్నాలజీస్ లేబుల్';
$string['attribution'] = 'అట్రిబ్యూషన్ 4.0';
$string['attributionnc'] = 'అట్రిబ్యూషన్-నాన్ కమర్షియల్  4.0';
$string['attributionncnd'] = 'అట్రిబ్యూషన్- నాన్ కమర్షియల్-నోడెర్విస్ 4.0';
$string['attributionncsa'] = 'అట్రిబ్యూషన్-వ్యాపారేతర- షేర్ అలైక్  4.0';
$string['attributionnd'] = 'అట్రిబ్యూషన్ - నో డిరైవ్ స్  4.0';
$string['attributionsa'] = 'అట్రిబ్యూషన్ - షేర్ అలైక్  4.0';
$string['author'] = 'రచయిత';
$string['authorcomments'] = 'రచయిత కామెంట్లు';
$string['authorcommentsdescription'] = 'కంటెంట్ ఎడిటర్ కోసం వ్యాఖ్యలు (కాపీరైట్ సమాచారంలో భాగంగా ఈ టెక్స్ట్ ప్రచురించబడదు)';
$string['authorname'] = 'రచయిత  పేరు';
$string['authorrole'] = 'రచయిత';
$string['back'] = 'వెనుకకు';
$string['by'] = 'ద్వారా';
$string['cancel'] = 'కేన్సిల్';
$string['cancellabel'] = 'రద్దు';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'వద్దు';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'అవును';
$string['cancelpublishconfirmationdialogdescription'] = 'నిజంగా మీరు షేరింగ్ ప్రోసెస్ ను రద్దు చేయాలనుకుంటున్నారా?';
$string['cancelpublishconfirmationdialogtitle'] = 'షేరింగ్ కెన్సిల్ చెయ్యి';
$string['ccattribution'] = 'అట్రిబ్యూషన్ (CC BY)';
$string['ccattributionnc'] = 'అట్రిబ్యూషన్- నాన్ కమర్షియల్ (CC BY-NC)';
$string['ccattributionncnd'] = 'అట్రిబ్యూషన్-నాన్ కమర్షియల్-నో డిరైవ్ స్  (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'అట్రిబ్యూషన్-నాన్ కమర్షియల్-షేర్ అలైక్   (CC BY-NC-SA)';
$string['ccattributionnd'] = 'అట్రిబ్యూషన్ - నో డిరైవ్ స్  (CC BY-ND)';
$string['ccattributionsa'] = 'అట్రిబ్యూషన్-షేర్ అలైక్(CC BY-SA)';
$string['ccpdd'] = 'పబ్లిక్ డొమైన్ (CC0)';
$string['ccpdm'] = 'పబ్లిక్ డొమైన్ మార్క్(PDM)';
$string['changedby'] = 'వీరిచే మార్చబడింది';
$string['changedescription'] = 'మార్పు యొక్క వివరాలు';
$string['changehasbeensubmitted'] = 'కై మార్పు సబ్ మిట్ చేయబడింది';
$string['changelog'] = 'మార్పుల లాగ్';
$string['changeplaceholder'] = 'ఫొటో క్రాప్ చేయబడింది, టెక్స్ట్ మార్చబడింది, మొదలైనవి';
$string['city'] = 'నగరం';
$string['close'] = 'మూసివేయు';
$string['completionpass'] = 'పాసింగ్ గ్రేడ్ కావాలి';
$string['completionpass_help'] = 'ఇది ఎనేబుల్ చేయబడితే, విద్యార్థి ఉత్తీర్ణత గ్రేడ్ (H5P యాక్టివిటీ సెట్టింగ్‌లలోని గ్రేడ్ విభాగంలో పేర్కొన్న విధంగా) లేదా అంతకంటే ఎక్కువ పొందినప్పుడు ఈ యాక్టివిటీ పూర్తయినట్లు పరిగణించబడుతుంది.';
$string['completionpassdesc'] = 'విద్యార్థి ఈ యాక్టివిటీ పూర్తిచేయాలంటే తప్పనిసరిగా ఉత్తీర్ణత గ్రేడ్ సాధించాలి';
$string['confirmdialogbody'] = 'దయచేసి మీరు కొనసాగాలనుకుంటున్నారని నిర్ధారించండి. ఈ చర్య తారుమారు కాదు.';
$string['confirmdialogheader'] = 'చర్యను నిర్థారించండి';
$string['confirmlabel'] = 'నిర్ధారించండి';
$string['connectionlost'] = 'కనెక్షన్ పోయింది. మీరు కనెక్షన్‌ని తిరిగి పొందినప్పుడు ఫలితాలు నిల్వ చేయబడతాయి మరియు పంపబడతాయి.';
$string['connectionreestablished'] = 'కనక్షన్ రి ఎస్టాబ్లిష్ అయ్యింది';
$string['contactperson'] = 'సంప్రదించవలసిన వ్యక్తి';
$string['contactpersondescription'] = 'పబ్లిషర్ షేర్ చేసిన కంటెంట్‌తో ఏవైనా సమస్యలు ఉంటే H5P ఆయా  సంప్రదించాల్సిన వ్యక్తిని సంప్రదిస్తుంది. సంప్రదింపు వ్యక్తి పేరు లేదా ఇతర సమాచారం మూడవ పక్షాలతో లేదా భాగస్వామ్యలతో ప్రచురించబడదు లేదా షేర్ చేయబడదు';
$string['contentavailable'] = 'మీ కంటెంట్ సాధారణంగా ఒక పని రోజులో హబ్‌లో అందుబాటులో ఉంటుంది.';
$string['contentchanged'] = 'మీరు చివరిగా ఉపయోగించినప్పటి నుండి ఈ కంటెంట్ మార్చబడింది.';
$string['contentcopied'] = 'కంటెంట్ క్లిప్ బోర్డ్ పై కాపీ చేయబడింది';
$string['contenthub:changesettings'] = 'ఖాతా సెట్టింగ్‌లను మార్చండి<a href="{$a}">here</a>';
$string['contenthub:licenseagreementdescription'] = 'ముందుకు కొనసాగించే ముందు దయచేసి కింది ఒప్పందాన్ని చదవండి';
$string['contenthub:licenseagreementmaintext'] = 'చెయ్యవలసిన';
$string['contenthub:licenseagreementtitle'] = 'తుది యూజరు లైసెన్స్ ఒప్పందం(EULA)';
$string['contenthub:nopermissions'] = 'కంటెంట్ హబ్‌తో సైట్‌ను నమోదు చేయడానికి మీకు అనుమతి లేదు.';
$string['contenthub:register'] = 'H5P హబ్‌లో ఖాతాను నమోదు చేయండి';
$string['contenthub:settings:box'] = 'కంటెంట్ హబ్‌ ఖాతా';
$string['contenthub:settings:heading'] = 'H5P హబ్ ఖాతా సెట్టింగ్‌లు';
$string['contentstatefrequency'] = 'కంటెంట్ స్టేట్ ఫ్రీక్వెన్సీను సేవ్ చేయండి';
$string['contentstatefrequency_help'] = 'సెకనులలో, వినియోగదారు ఎంత తరచుగా వారి పురోగతిని సేవ్ చేయాలని మీరు కోరుకుంటున్నారా? మీరు అనేక అజాక్స్ అభ్యర్ధనలతో సమస్యలను కలిగి ఉంటే ఈ సంఖ్యను పెంచండి';
$string['contenttype'] = 'కంటెంట్ రకం';
$string['contenttypecacheheader'] = 'కంటెంట్ రకం కాష్';
$string['copyright'] = 'ఉపయోగ హక్కులు';
$string['copyrightinfo'] = 'కాపీరైట్ సమాచారం';
$string['copyrightstring'] = 'కాపీరైట్';
$string['copyrighttitle'] = 'ఈ కంటెంట్ కోసం కాపీరైట్ సమాచారాన్ని వీక్షించండి.';
$string['couldnotcopy'] = 'ఫైల్ను కాపీ చేయడం సాధ్యపడలేదు.';
$string['couldnotreadfilefromzip'] = 'ప్యాకేజీ నుండి ఫైల్‌ని చదవడం సాధ్యం కాలేదు: %fileName';
$string['couldnotsave'] = 'ఫైల్ను సేవ్ చేయడం సాధ్యపడలేదు.';
$string['country'] = 'దేశం';
$string['create'] = 'సృష్టించు';
$string['ctcachebuttonlabel'] = 'కంటెంట్ రకం కాష్ని నవీకరించండి';
$string['ctcacheconnectionfailed'] = 'H5P హబ్తో కమ్యూనికేట్ చేయలేకపోయింది. దయచేసి తర్వాత మళ్లీ ప్రయత్నించండి.';
$string['ctcachedescription'] = 'కంటెంట్ రకం కాష్ తాజాగా ఉందని నిర్ధారించుకోవడం ద్వారా మీరు తాజా లైబ్రరీలను చూడవచ్చు, డౌన్లోడ్ చేసుకోవచ్చు మరియు ఉపయోగించగలరని నిర్ధారిస్తుంది. ఇది లైబ్రరీలను నవీకరించడానికి భిన్నంగా ఉంటుంది.';
$string['ctcachelastupdatelabel'] = 'చివరి నవీకరణ';
$string['ctcacheneverupdated'] = 'నెవర్';
$string['ctcachenolibraries'] = 'H5P హబ్ నుండి కంటెంట్ రకాలు ఏవీ పొందలేదు. దయచేసి తర్వాత మళ్లీ ప్రయత్నించండి.';
$string['ctcachesuccess'] = 'లైబ్రరీ క్యాష్ విజయవంతంగా నవీకరించబడింది!';
$string['ctcachetaskname'] = 'కంటెంట్ రకం కాష్ని నవీకరించండి';
$string['currentpage'] = '$ $ ప్రస్తుత $ పేజీ ప్రస్తుత';
$string['dataviewreportlabel'] = 'సమాధానాలు చూడండి';
$string['disablefileextensioncheck'] = 'ఫైల్ పొడిగింపు తనిఖీని నిలిపివేయి';
$string['disablefileextensioncheckwarning'] = 'హెచ్చరిక! ఫైల్ పొడిగింపు చెక్ను డిసేబుల్ చెయ్యడం వలన భద్రతా పరిణామాలు ఉండవచ్చు, ఎందుకంటే ఇది php ఫైళ్ళను అప్లోడ్ చేయడానికి అనుమతిస్తుంది. దాడులకు మీ సైట్లో హానికరమైన కోడ్ను అమలు చేయడానికి దాడి చేసే అవకాశం ఉంది. దయచేసి మీరు అప్లోడ్ చేస్తున్నవాటిని మీరు ఖచ్చితంగా తెలుసుకోండి.';
$string['disablefullscreen'] = 'పూర్తి స్క్రీన్ని ఆపివేయి';
$string['disablehubconfirmationmsg'] = 'మీరు ఇప్పటికీ హబ్ను ప్రారంభించాలనుకుంటున్నారా?';
$string['disablehubdescription'] = 'ఈ ఐచ్చికాన్ని ఎనేబుల్ చెయ్యటానికి ఇది చాలా ప్రోత్సహించబడింది. H5P హబ్ కొత్త కంటెంట్ రకాలను పొందడానికి మరియు ఇప్పటికే ఉన్న కంటెంట్ రకాలను తాజాగా ఉంచడానికి సులభమైన ఇంటర్ఫేస్ను అందిస్తుంది. భవిష్యత్తులో, ఇది కంటెంట్ను భాగస్వామ్యం చేయడానికి మరియు మళ్లీ ఉపయోగించడం సులభం చేస్తుంది. ఈ ఐచ్చికాన్ని డిసేబుల్ చేసి ఉంటే, మీరు ఫైల్ రకాన్ని రూపాలు ద్వారా కంటెంట్ రకాలను ఇన్స్టాల్ చేసి అప్డేట్ చేయాలి.';
$string['displayoptionalwaysshow'] = 'ఎల్లప్పుడూ చూపించు';
$string['displayoptionauthoroff'] = 'రచయితచే నియంత్రించబడుతుంది, డిఫాల్ట్ ఆఫ్ చేయబడింది';
$string['displayoptionauthoron'] = 'రచయిత నియంత్రణలో ఉంది, డిఫాల్ట్ ఆన్లో ఉంది';
$string['displayoptionnevershow'] = 'ఎప్పుడూ చూపవద్దు';
$string['displayoptionpermissions'] = 'వినియోగదారు H5P ను ఎగుమతి చెయ్యడానికి అనుమతులు ఉంటే మాత్రమే చూపించు';
$string['displayoptionpermissionsembed'] = 'వినియోగదారు H5P ను పొందుపరచడానికి అనుమతులు ఉంటే మాత్రమే చూపించు';
$string['displayoptions'] = 'ఐచ్ఛికాలు ప్రదర్శించు';
$string['download'] = 'డౌన్లోడ్';
$string['downloadfailed'] = 'అభ్యర్థించిన లైబ్రరీని డౌన్లోడ్ చేయడం విఫలమైంది.';
$string['downloadtitle'] = 'ఈ కంటెంట్ని H5P ఫైలుగా డౌన్లోడ్ చేసుకోండి.';
$string['editor'] = 'ఎడిటర్';
$string['embed'] = 'పొందుపరిచిన';
$string['embedloginfailed'] = 'మీకు ఈ కంటెంట్కు ప్రాప్యత లేదు. లాగిన్ అవ్వండి.';
$string['embedtitle'] = 'ఈ కంటెంట్ కోసం పొందుపరిచిన కోడ్ను వీక్షించండి.';
$string['empty'] = 'ఫలితాలు అందుబాటులో లేవు';
$string['enableabout'] = 'H5P బటన్ గురించి';
$string['enablecopyright'] = 'కాపీరైట్ బటన్';
$string['enabledlrscontenttypes'] = 'LRS ఆధారిత కంటెంట్ రకాలను ప్రారంభించండి';
$string['enabledlrscontenttypes_help'] = 'ప్రశ్నావళి కంటెంట్ రకాన్ని సరిగా పనిచేయడానికి ఒక శిక్షణ రికార్డు స్టోర్పై ఆధారపడే కంటెంట్ రకాలను ఉపయోగించడం సాధ్యమవుతుంది.';
$string['enabledownload'] = 'డౌన్లోడ్ బటన్';
$string['enableembed'] = 'పొందుపరచు బటన్';
$string['enableframe'] = 'చర్య బార్ మరియు ఫ్రేమ్ని ప్రదర్శించండి';
$string['enablehublabel'] = 'H5P హబ్ ఉపయోగించండి';
$string['enablejavascript'] = 'దయచేసి జావాస్క్రిప్ట్ ప్రారంభించండి.';
$string['enablesavecontentstate'] = 'కంటెంట్ స్థితిని సేవ్ చేయండి';
$string['enablesavecontentstate_help'] = 'ప్రతి యూజర్ కోసం ఇంటరాక్టివ్ కంటెంట్ యొక్క ప్రస్తుత స్థితిని స్వయంచాలకంగా సేవ్ చేయండి. దీని అర్థం అతను వదిలివేసిన వినియోగదారుని ఎంచుకొని ఉండవచ్చు.';
$string['failedtodownloadh5p'] = 'అభ్యర్థించిన H5P డౌన్లోడ్ చేయడంలో విఫలమైంది.';
$string['filenotfoundonserver'] = 'సర్వర్లో సర్వర్ కనుగొనబడలేదు. ఫైల్ అప్లోడ్ సెట్టింగ్లను తనిఖీ చేయండి.';
$string['filenotimage'] = 'ఫైల్ చిత్రం కాదు.';
$string['filetypenotallowed'] = 'ఫైల్ రకం అనుమతించబడదు.';
$string['finished'] = 'పూర్తయ్యింది';
$string['fullscreen'] = 'పూర్తి స్క్రీన్';
$string['gpl'] = 'జనరల్ పబ్లిక్ లైసెన్స్ v3';
$string['h5pfile'] = 'H5P ఫైలు';
$string['h5ptitle'] = 'మరింత చల్లని కంటెంట్ను తనిఖీ చేయడానికి H5P.org ను సందర్శించండి.';
$string['hide'] = 'దాచు';
$string['hideadvanced'] = 'అధునాతన దాచు';
$string['hubcommunicationdisabled'] = 'ఒకటి లేదా అంతకంటే ఎక్కువ H5P అవసరాలు విఫలమైనందున H5P హబ్ కమ్యూనికేషన్ నిలిపివేయబడింది.';
$string['hubisdisabled'] = 'కేంద్రం నిలిపివేయబడింది. మీరు దీన్ని H5P సెట్టింగ్ల్లో మళ్లీ ప్రారంభించవచ్చు.';
$string['hubisdisableduploadlibraries'] = 'ఈ సమస్య పరిష్కారం అయ్యే వరకు H5P హబ్ నిలిపివేయబడింది. మీరు ఇప్పటికీ "H5P లైబ్రరీస్" పేజీ ద్వారా లైబ్రరీలను అప్లోడ్ చేయవచ్చు.';
$string['hubsettingsheader'] = 'కంటెంట్ రకాలు';
$string['hvp:addinstance'] = 'కొత్త H5P యాక్టివిటీస్ సృష్టించండి';
$string['hvp:getcachedassets'] = 'H5P కార్యాచరణలను వీక్షించడానికి అవసరం';
$string['hvp:getembedcode'] = '\'అనుమతి నియంత్రణలో\' ఎంపికను సెట్ చేసినప్పుడు H5P పొందుపరిచిన కోడ్ను వీక్షించండి';
$string['hvp:getexport'] = '\'అనుమతితో నియంత్రించబడినప్పుడు\' ఎంపిక .h5p ఫైల్ను సెట్ చేయండి';
$string['hvp:installrecommendedh5plibraries'] = 'H5P.org ద్వారా సిఫార్సు చేయబడిన కొత్త సురక్షిత H5P కంటెంట్ రకాలను ఇన్స్టాల్ చేయండి';
$string['hvp:manage'] = 'ఇప్పటికే ఉన్న H5P యాక్టివిటీలను సవరించండి';
$string['hvp:restrictlibraries'] = 'కొన్ని H5P కంటెంట్ రకాలకు ప్రాప్యతను పరిమితం చేయండి';
$string['hvp:savecontentuserdata'] = 'H5P కార్యకలాపాల కోసం వినియోగదారుల పురోగతిని సేవ్ చేయండి';
$string['hvp:saveresults'] = 'పూర్తి H5P చర్యల నుండి ఫలితాలను సేవ్ చేయండి';
$string['hvp:updatelibraries'] = 'క్రొత్త H5P కంటెంట్ రకాలను ఇన్స్టాల్ చేయండి లేదా ఇప్పటికే ఉన్న వాటిని నవీకరించండి';
$string['hvp:userestrictedlibraries'] = 'నియంత్రిత H5P కంటెంట్ రకాలను ఉపయోగించండి';
$string['hvp:view'] = 'H5P కార్యకలాపాలను చూడండి మరియు పరస్పర చర్య చేయండి';
$string['hvp:viewallresults'] = 'పూర్తి  అయిన H5P యాక్టివేట్లను వీక్షించండి';
$string['hvp:viewresults'] = 'పూర్తి అయిన H5P యాక్టివేట్ల సొంత ఫలితాలను వీక్షించండి';
$string['installdenied'] = 'మీకు కంటెంట్ రకాలను ఇన్స్టాల్ చేయడానికి అనుమతి లేదు. మీ సైట్ యొక్క నిర్వాహకుడిని సంప్రదించండి.';
$string['installedlibraries'] = 'ఇన్స్టాల్ చేయబడిన గ్రంథాలయాలు';
$string['intro'] = 'పరిచయం';
$string['invalidaudioformat'] = 'చెల్లని ఆడియో ఫైల్ ఆకృతి. Mp3 లేదా wav ఉపయోగించండి.';
$string['invalidcontentfolder'] = 'చెల్లని కంటెంట్ ఫోల్డర్';
$string['invalidcontenttype'] = 'ఎంచుకున్న కంటెంట్ రకం చెల్లనిది.';
$string['invalidfieldtype'] = 'చెల్లని ఫీల్డ్ రకం';
$string['invalidfile'] = 'ఫైల్ "{$a->%filename}" అనుమతించబడదు. క్రింది పొడిగింపులతో ఫైల్లు మాత్రమే అనుమతించబడతాయి: {$a ->%files-allowed}.';
$string['invalidh5ppost'] = 'H5P పోస్ట్ చేయలేము.';
$string['invalidimageformat'] = 'చెల్లని చిత్రం ఫైల్ ఆకృతి. Jpg, png లేదా gif ఉపయోగించండి.';
$string['invalidlanguagefile'] = 'లైబ్రరీ {$a ->%library} చెల్లని భాష ఫైల్ {$a ->%file}';
$string['invalidlanguagefile2'] = '{$a->%languageFile} లైబ్రరీలో {$a->%name} లో చెల్లని భాష ఫైల్ చేర్చబడింది.';
$string['invalidlibrary'] = 'చెల్లని లైబ్రరీ';
$string['invalidlibrarydata'] = '{$a->%library} లో {$a ->%property}';
$string['invalidlibrarydataboolean'] = '{$a ->%library} లో {$a ->%property} కోసం చెల్లని డేటా అందించబడింది. బూలియన్ అంచనా.';
$string['invalidlibraryname'] = 'చెల్లని లైబ్రరీ పేరు: {$a ->%name}';
$string['invalidlibrarynamed'] = 'కంటెంట్లో ఉపయోగించిన H5P లైబ్రరీ {$a ->%library} చెల్లదు';
$string['invalidlibraryoption'] = '{$a->%library} లో అక్రమ ఎంపిక {$a ->%option}';
$string['invalidlibraryproperty'] = '{$a->%library} లో ఆస్తి {$a ->%property}';
$string['invalidmainjson'] = 'చెల్లుబాటు అయ్యే ప్రధాన h5p.json ఫైల్ లేదు';
$string['invalidmultiselectoption'] = 'బహుళ-ఎంపికలో ఎంపికైన ఎంపిక చెల్లదు.';
$string['invalidparameters'] = 'చెల్లని పారామితులు';
$string['invalidselectoption'] = 'ఎంపికలో ఎంపికైన ఎంపిక చెల్లదు.';
$string['invalidsemanticsjson'] = 'చెల్లని సెమాంటిక్స్.json ఫైల్ లైబ్రరీలో {$a ->%name}';
$string['invalidsemanticstype'] = 'H5P అంతర్గత లోపం: సెమాంటిక్స్లో తెలియని కంటెంట్ రకం "{$a ->@type}". కంటెంట్ను తీసివేయడం!';
$string['invalidstring'] = 'అందించిన స్ట్రింగ్ సెమాంటిక్స్లో regexp ప్రకారం చెల్లుబాటు కాదు. (విలువ: \\ "{$a ->%value} \\", regexp: \\ "{$a ->%regexp} \\")';
$string['invalidtoken'] = 'చెల్లని భద్రతా టోకెన్.';
$string['invalidvideoformat'] = 'చెల్లని వీడియో ఫైల్ ఆకృతి. Mp4 లేదా webm ని ఉపయోగించండి.';
$string['invalidxapiresult'] = 'ఇచ్చిన కంటెంట్ మరియు యూజర్ ఐడి కలయిక కోసం xAPI ఫలితాలు కనుగొనబడలేదు';
$string['javascriptloading'] = 'జావాస్క్రిప్ట్ కోసం వేచి ఉంది ...';
$string['libraries'] = 'H5P లైబ్రరీస్';
$string['librarydirectoryerror'] = 'లైబ్రరీ డైరెక్టరీ పేరు machineName లేదా machineName-majorVersion.minorVersion (library.json నుండి) తో సరిపోలాలి. ({$ A ->% directoryName}, యంత్రం పేరు: {$a ->%machineName}, ప్రధాన సంస్కరణ: {$a ->%majorVersion}, చిన్న సంస్కరణ: {$a ->%minorVersion})';
$string['librarylistactions'] = 'చర్యలు';
$string['librarylistinstancedependencies'] = 'ఇన్స్టాన్స్ డిపెండెన్సీలు';
$string['librarylistinstances'] = 'ఉదాహరణలు';
$string['librarylistlibrarydependencies'] = 'లైబ్రరీ డిపెండెన్సీలు';
$string['librarylistrestricted'] = 'నిరోధిత';
$string['librarylisttitle'] = 'శీర్షిక';
$string['librarynotselected'] = 'మీరు తప్పనిసరిగా కంటెంట్ రకాన్ని ఎంచుకోవాలి.';
$string['license'] = 'లైసెన్సు';
$string['licenseCC010'] = 'CC0 1.0 యూనివర్సల్ (CC0 1.0) పబ్లిక్ డొమైన్ డెడికేషన్';
$string['licenseCC010U'] = 'CC0 1.0 యూనివర్సల్';
$string['licenseCC10'] = '1.0 సాధారణం';
$string['licenseCC20'] = '2.0 సాధారణం';
$string['licenseCC25'] = '2.5 సాధారణం';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 ఇంటర్నేషనల్';
$string['licenseGPL'] = 'జనరల్ పబ్లిక్ లైసెన్స్';
$string['licenseV1'] = 'వెర్షన్ 1';
$string['licenseV2'] = 'సంస్కరణ 2';
$string['licenseV3'] = 'సంస్కరణ 3';
$string['licenseversion'] = 'లైసెన్సు సంస్కరణ';
$string['loadingdata'] = 'డేటాను లోడ్ చేస్తోంది';
$string['lookforupdates'] = 'H5P నవీకరణల కోసం చూడండి';
$string['maximumgrade'] = 'గరిష్ట గ్రేడ్';
$string['maximumgradeerror'] = 'దయచేసి ఈ కార్యాచరణ కోసం అందుబాటులో ఉన్న గరిష్ట పాయింట్లుగా చెల్లుబాటు అయ్యే సానుకూల పూర్ణాంకాన్ని నమోదు చేయండి';
$string['maxpostsizetoosmall'] = 'మీ PHP గరిష్ట పోస్ట్ పరిమాణం చాలా చిన్నది. మీ ప్రస్తుత సెటప్తో, మీరు {$a->%number} MB కంటే పెద్ద ఫైళ్ళను అప్లోడ్ చేయలేరు. ఇది H5P లు, చిత్రాలు మరియు వీడియోలను అప్లోడ్ చేయడానికి ప్రయత్నిస్తున్నప్పుడు సమస్య కావచ్చు. 5MB కన్నా ఎక్కువకు పెంచడానికి దయచేసి గమనించండి';
$string['maxscore'] = 'గరిష్ఠ స్కోరు';
$string['maxuploadsizetoosmall'] = 'మీ PHP గరిష్ట అప్లోడ్ పరిమాణం చాలా చిన్నది. మీ ప్రస్తుత సెటప్తో, మీరు {$a ->%number} MB కంటే పెద్ద ఫైళ్ళను అప్లోడ్ చేయలేరు. ఇది H5P లు, చిత్రాలు మరియు వీడియోలను అప్లోడ్ చేయడానికి ప్రయత్నిస్తున్నప్పుడు సమస్య కావచ్చు. 5MB కన్నా ఎక్కువకు పెంచడానికి దయచేసి గమనించండి.';
$string['missingcontentfolder'] = 'చెల్లుబాటు అయ్యే కంటెంట్ ఫోల్డర్ లేదు';
$string['missingcontentuserdata'] = 'లోపం: కంటెంట్ వినియోగదారు డేటాను కనుగొనడం సాధ్యపడలేదు';
$string['missingcoreversion'] = 'ప్యాకేజీ నుండి సిస్టమ్ <em> {$a ->%component} = </ em> కాంపోనెంట్ను ఇన్స్టాల్ చేయలేకపోయింది, దీనికి H5P ప్లగ్ఇన్ యొక్క కొత్త వెర్షన్ అవసరం. ఈ సైట్ ప్రస్తుతం {$a ->%current} సంస్కరణను నడుపుతోంది, అవసరమైన సంస్కరణ {$a->%required} లేదా అంతకంటే ఎక్కువ. మీరు అప్గ్రేడ్ చేసి, మళ్లీ ప్రయత్నించండి.';
$string['missingdependency'] = '{$a ->@lib} ద్వారా అవసరం లేని {$a ->@dep}';
$string['missinglibrary'] = 'అవసరమైన గ్రంథాలయం లేదు {$a ->@library}';
$string['missinglibraryfile'] = 'లైబ్రరీ నుండి "{$a ->%file}" ఫైల్ లేదు: "{$a ->%name}"';
$string['missinglibraryjson'] = 'లైబ్రరీ {$a ->%name} కోసం చెల్లుబాటు అయ్యే json ఆకృతితో library.json ఫైల్ను కనుగొనలేకపోయాము';
$string['missinglibraryproperty'] = '{$a ->%library} నుండి అవసరమైన ఆస్తి {$a ->%property} లేదు.';
$string['missingmbstring'] = 'Mbstring PHP ఎక్స్టెన్షన్ లోడ్ చేయబడలేదు. సరిగా పనిచేయడానికి H5P అవసరం';
$string['missingparameters'] = 'పారామితులు కనిపించలేదు';
$string['missinguploadpermissions'] = 'గ్రంథాలయాలు మీరు అప్లోడ్ చేసిన ఫైల్లో ఉండవచ్చు, కానీ కొత్త లైబ్రరీలను అప్ లోడ్ చెయ్యడానికి మీకు అనుమతి లేదు. దీని గురించి సైట్ నిర్వాహకుడిని సంప్రదించండి.';
$string['modulename'] = 'ఇంటరాక్టివ్ కంటెంట్';
$string['modulename_help'] = 'H5P కార్యాచరణ మాడ్యూల్ ఇంటరాక్టివ్ వీడియోలు, ప్రశ్న సెట్లు, డ్రాగ్ మరియు డ్రాప్ ప్రశ్నలు, మల్టీ-ఛాయస్ ప్రశ్నలు, ప్రెజెంటేషన్లు మరియు మరింత వంటి ఇంటరాక్టివ్ కంటెంట్ను సృష్టించడానికి మిమ్మల్ని అనుమతిస్తుంది.

గొప్ప కంటెంట్ కోసం ఒక రచయిత సాధనం కాకుండా, H5P సమర్థవంతమైన పునర్వినియోగం మరియు కంటెంట్ను భాగస్వామ్యం చేయడానికి H5P ఫైళ్లను దిగుమతి మరియు ఎగుమతి చేయడానికి మిమ్మల్ని అనుమతిస్తుంది.

వినియోగదారు పరస్పర చర్యలు మరియు స్కోర్లు xAPI ఉపయోగించి ట్రాక్ చేయబడతాయి మరియు Moodle Gradebook ద్వారా అందుబాటులో ఉంటాయి.

అంతర్నిర్మిత రచన సాధనం ఉపయోగించి కంటెంట్ను సృష్టించడం ద్వారా లేదా ఇతర H5P ప్రారంభించబడిన సైట్లలో ఉన్న H5P ఫైళ్ళను అప్లోడ్ చేయడం ద్వారా మీరు ఇంటరాక్టివ్ H5P కంటెంట్ను జోడించుకుంటారు.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'ఇంటరాక్టివ్ కంటెంట్';
$string['nextpage'] = 'తరువాతి పేజీ';
$string['noanswersubmitted'] = 'ఈ వినియోగదారు ఇంకా H5P కి సమాధానాన్ని సమర్పించలేదు';
$string['nocontent'] = 'Content.json ఫైల్ను కనుగొనలేరు లేదా అన్వయించలేకపోయాము';
$string['nocontenttype'] = 'కంటెంట్ రకం పేర్కొనబడలేదు.';
$string['nocopyright'] = 'ఈ కంటెంట్కు కాపీరైట్ సమాచారం అందుబాటులో లేదు.';
$string['nodata'] = 'మీ ప్రమాణాలకు సరిపోయే డేటా అందుబాటులో లేదు.';
$string['noextension'] = 'మీరు అప్లోడ్ చేసిన ఫైల్ చెల్లని HTML5 ప్యాకేజీ కాదు (ఇది .h5p ఫైల్ పొడిగింపు లేదు)';
$string['noh5ps'] = 'ఈ కోర్సు కోసం ఇంటరాక్టివ్ కంటెంట్ అందుబాటులో లేదు.';
$string['nojson'] = 'ప్రధాన h5p.json ఫైల్ చెల్లుబాటు కాదు';
$string['noparameters'] = 'పారామితులు లేవు';
$string['noparse'] = 'ప్రధాన h5p.json ఫైల్ను అన్వయించడం సాధ్యం కాలేదు';
$string['nopermissiontorestrict'] = 'లైబ్రరీలను పరిమితం చేయడానికి మీకు అనుమతి లేదు.';
$string['nopermissiontosavecontentuserdata'] = 'కంటెంట్ వినియోగదారు డేటాను సేవ్ చేయడానికి మీకు అనుమతి లేదు.';
$string['nopermissiontosaveresult'] = 'ఈ కంటెంట్ కోసం ఫలితాన్ని సేవ్ చేయడానికి మీకు అనుమతి లేదు.';
$string['nopermissiontoupgrade'] = 'లైబ్రరీలను అప్గ్రేడ్ చేయడానికి మీకు అనుమతి లేదు.';
$string['nopermissiontouploadcontent'] = 'ఇక్కడ కంటెంట్ను అప్లోడ్ చేయడానికి మీకు అనుమతి లేదు.';
$string['nopermissiontouploadfiles'] = 'ఇక్కడ ఫైళ్ళను అప్లోడ్ చెయ్యడానికి మీకు అనుమతి లేదు.';
$string['nopermissiontoviewcontenttypes'] = 'మీకు కంటెంట్ రకాలను వీక్షించడానికి అనుమతి లేదు.';
$string['nopermissiontoviewresult'] = 'ఈ కంటెంట్ కోసం ఫలితాలను వీక్షించడానికి మీకు అనుమతి లేదు.';
$string['nosuchlibrary'] = 'ఇటువంటి లైబ్రరీ లేదు';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'మీరు అప్లోడ్ చేసిన ఫైల్ చెల్లుబాటు అయ్యే HTML5 ప్యాకేజీ కాదు (దీన్ని అన్జిప్ చేయలేకపోయాము)';
$string['noversionattribution'] = 'అట్రిబ్యూషన్';
$string['noversionattributionnc'] = 'అట్రిబ్యూషన్ వ్యాపారేతర-';
$string['noversionattributionncnd'] = 'అట్రిబ్యూషన్ వ్యాపారేతర- NoDerivs';
$string['noversionattributionncsa'] = 'అట్రిబ్యూషన్ వ్యాపారేతర- ShareAlike';
$string['noversionattributionnd'] = 'ఆపాదింపు-NoDerivs';
$string['noversionattributionsa'] = 'ఆపాదింపు-యథాతథ పంచుకోలు';
$string['nowriteaccess'] = 'సర్వర్ వ్రాసే ప్రాప్యతతో సమస్య కనుగొనబడింది. దయచేసి మీ సర్వర్ మీ డేటా ఫోల్డర్కు వ్రాయగలదని నిర్ధారించుకోండి.';
$string['noziparchive'] = 'మీ PHP సంస్కరణ ZipArchive కు మద్దతు ఇవ్వదు.';
$string['oldphpversion'] = 'మీ PHP వెర్షన్ గడువు ముగిసింది. H5P సరిగా పనిచేయడానికి సంస్కరణ 5.2 అవసరం. సంస్కరణ 5.6 లేదా తరువాత సిఫార్సు చేయబడింది.';
$string['onlyupdate'] = 'ఇప్పటికే లైబ్రరీలను నవీకరించండి';
$string['options'] = 'ఎంపికలు';
$string['pd'] = 'పబ్లిక్ డొమైన్';
$string['pddl'] = 'పబ్లిక్ డొమైన్ డెడికేషన్ మరియు లైసెన్స్';
$string['pdm'] = 'పబ్లిక్ డొమైన్ మార్క్';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'ఇచ్చిన తుది స్థానానికి యాక్సెస్ చేయడానికి H5PA పోస్ట్ సందేశం అవసరం';
$string['previouspage'] = 'ముందు పేజి';
$string['privacy:metadata:core_files'] = 'H5P కంటెంట్ యొక్క భాగంలో అప్లోడ్ చేయబడిన H5P కార్యకలాపాలను నిల్వ చేస్తుంది.';
$string['privacy:metadata:core_grades'] = 'H5P కంటెంట్కు సమాధానం ఇచ్చిన వినియోగదారుల యొక్క H5P కార్యకలాపాలు.';
$string['privacy:metadata:hvp_content_user_data'] = 'కంటెంట్ వినియోగదారు కోసం ఉందని ప్రస్తుత స్థితి వివరిస్తుంది. మునుపటి స్థితికి కంటెంట్ను పునరుద్ధరించడానికి ఉపయోగించబడుతుంది.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'నిల్వ చేసిన వినియోగదారు డేటా.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'డేటా రకం ఐడెంటిఫైయర్.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'కంటెంట్ మారినప్పుడు డేటా తొలగించబడాలా అని నిర్ణయిస్తుంది.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'డేటా చెందిన H5P కంటెంట్ ID.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'కంటెంట్ వినియోగదారు డేటా సంబంధం యొక్క ID';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'డేటా కంటెంట్లో ముందే లోడ్ చేయబడిందా అని నిర్ణయిస్తుంది.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'ఇది ఉప-కంటెంట్ కాకపోతే H5P యొక్క సబ్-కంటెంట్.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'డేటా చెందిన యూజర్ యొక్క ID.';
$string['privacy:metadata:hvp_events'] = 'లాగిన్ చేసిన H5P ఈవెంట్లను ట్రాక్ చేస్తుంది.';
$string['privacy:metadata:hvp_events:content_id'] = 'క్రొత్త లేదా కంటెంట్ లేకపోతే, చర్య చేసిన కంటెంట్ ఐడి.';
$string['privacy:metadata:hvp_events:content_title'] = 'కంటెంట్ యొక్క శీర్షిక.';
$string['privacy:metadata:hvp_events:created_at'] = 'ఈవెంట్ సృష్టించబడిన సమయం.';
$string['privacy:metadata:hvp_events:id'] = 'ఈవెంట్ యొక్క ప్రత్యేక ID.';
$string['privacy:metadata:hvp_events:library_name'] = 'ఈవెంట్ లైబ్రరీ ప్రభావితం.';
$string['privacy:metadata:hvp_events:library_version'] = 'ఈవెంట్ను ప్రభావితం చేసిన లైబ్రరీ సంస్కరణ.';
$string['privacy:metadata:hvp_events:sub_type'] = 'ఈవెంట్ యొక్క ఉప-రకం, లేదా ఈవెంట్ యొక్క చర్య.';
$string['privacy:metadata:hvp_events:type'] = 'ఈవెంట్ రకం.';
$string['privacy:metadata:hvp_events:user_id'] = 'చర్యను ప్రదర్శించిన యూజర్ యొక్క ID.';
$string['privacy:metadata:hvp_xapi_results'] = 'H5P కంటెంట్లో xAPI ఈవెంట్లను నిల్వ చేస్తుంది.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'H5P పంపగల అదనపు సమాచారం.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'ఈవెంట్ యొక్క కార్యక్రమంలో ID నిర్వహించబడింది.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'సరైన సమాధానం నమూనా.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'చర్య జరిపిన విషయం యొక్క వివరణ, పని లేదా ప్రశ్న.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'XAPI ఈవెంట్ యొక్క ఏకైక ID.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'పరస్పర రకం.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'ఈవెంట్ కోసం మాక్స్ సాధించగలిగే స్కోరు.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'ఈ ఈవెంట్ అమలు చేయబడిన కంటెంట్ యొక్క తల్లి యొక్క ID. అది పేరెంట్ లేకుంటే శూన్యమైనది.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'ఈవెంట్ కోసం సాధించిన స్కోరు.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'యూజర్ పంపిన ప్రతిస్పందన.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'చర్యను ప్రదర్శించిన యూజర్ యొక్క ID.';
$string['removeoldlogentries'] = 'పాత H5P లాగ్ ఎంట్రీలను తొలగించండి';
$string['removetmpfiles'] = 'పాత H5P తాత్కాలిక ఫైళ్లను తొలగించండి';
$string['reportingquestionsremaininglabel'] = 'ప్రశ్నలకు గ్రేడ్ మిగిలి ఉంది';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'గ్రేడ్బుక్ స్కోర్:';
$string['reportingscoredelimiter'] = 'బయటకు';
$string['reportingscorelabel'] = 'స్కోరు:';
$string['reportnotsupported'] = 'మద్దతు ఇవ్వ లేదు';
$string['reportsubmitgradelabel'] = 'గ్రేడ్ సమర్పించండి';
$string['resizescript'] = 'మీరు ఎంబెడెడ్ కంటెంట్ యొక్క డైనమిక్ పరిమాణాన్ని కావాలనుకుంటే మీ వెబ్సైట్లో ఈ లిపిని చేర్చండి:';
$string['reveal'] = 'రివీల్';
$string['reviseserversetupandretry'] = 'మీరు మీ సర్వర్ సెటప్ను సవరించినప్పుడు, H5P సెట్టింగ్లలో H5P కేంద్ర కమ్యూనికేషన్ను పునఃప్రారంభించవచ్చు.';
$string['score'] = 'స్కోరు';
$string['search'] = 'శోధన';
$string['sendusagestatistics'] = 'వినియోగ గణాంకాలను అందించండి';
$string['sendusagestatistics_help'] = 'వాడకం గణాంకాల సంఖ్యలు స్వయంచాలకంగా డెవలపర్లు H5P ఎలా ఉపయోగించాలో అర్థం చేసుకోవడానికి మరియు అభివృద్ధి యొక్క సంభావ్య ప్రదేశాలు నిర్ణయించడానికి స్వయంచాలకంగా నివేదించబడతాయి. <a href="http://translate.htm"> <a href="http://translate.htm"> <a href =';
$string['settings'] = 'H5P సెట్టింగ్లు';
$string['showadvanced'] = 'అధునాతన చూపించు';
$string['showless'] = 'తక్కువ చూపించు';
$string['showmore'] = 'ఇంకా చూపించు';
$string['sitecouldnotberegistered'] = 'సైట్ హబ్ తో నమోదు కాలేదు. దయచేసి మీ సైట్ నిర్వాహకుడిని సంప్రదించండి.';
$string['sitekey'] = 'సైట్ కీ';
$string['sitekeydescription'] = 'సైట్ కీ హబ్ తో ఈ సైట్ను ప్రత్యేకంగా గుర్తిస్తుంది.';
$string['sitekeyregistered'] = 'క్రొత్త నవీకరణలను స్వీకరించినప్పుడు మీరు హబ్తో గుర్తించే ప్రత్యేక కీని మీకు అందించారు. కీ "H5P సెట్టింగులు" పేజీలో వీక్షించడానికి అందుబాటులో ఉంది.';
$string['size'] = 'పరిమాణం';
$string['source'] = 'మూల';
$string['sslnotenabled'] = 'మీ సర్వర్ SSL ప్రారంభించబడలేదు. H5P హబ్తో సురక్షిత కనెక్షన్ను నిర్ధారించడానికి SSL ప్రారంభించబడాలి.';
$string['startingover'] = 'మీరు ప్రారంభించబడతారు.';
$string['sublevel'] = 'ఉపస్థాయి';
$string['successfullyregisteredwithhub'] = 'మీ సైట్ విజయవంతంగా H5P హబ్లో నమోదు చేయబడింది.';
$string['thumbnail'] = 'సూక్ష్మచిత్రం';
$string['title'] = 'శీర్షిక';
$string['unabletocreatedir'] = 'డైరెక్టరీని సృష్టించడం సాధ్యం కాలేదు.';
$string['unabletogetfieldtype'] = 'ఫీల్డ్ రకం పొందడం సాధ్యం కాలేదు.';
$string['undisclosed'] = 'గుర్తుతెలియని';
$string['updatedlibraries'] = '{$a ->%old} H5P గ్రంథాలయాలు నవీకరించబడ్డాయి.';
$string['updatedlibrary'] = '{$a->%old} H5P లైబ్రరీ నవీకరించబడింది.';
$string['updatelibraries'] = 'అన్ని లైబ్రరీలను నవీకరించండి';
$string['upgrade'] = 'అప్గ్రేడ్ H5P';
$string['upgradebuttonlabel'] = 'అప్గ్రేడ్';
$string['upgradedone'] = 'మీరు {$a} కంటెంట్ ఉదాహరణకు (లు) ను విజయవంతంగా అప్గ్రేడ్ చేసారు.';
$string['upgradeerror'] = 'పారామితులను ప్రాసెస్ చేసేటప్పుడు లోపం సంభవించింది:';
$string['upgradeerrorcontent'] = 'కంటెంట్% id అప్గ్రేడ్ చేయలేక పోయాను:';
$string['upgradeerrordata'] = 'లైబ్రరీ% lib కోసం డేటాను లోడ్ చేయలేకపోయింది.';
$string['upgradeerrorparamsbroken'] = 'పారామితులు విభజించబడ్డాయి.';
$string['upgradeerrorscript'] = '% Lib కొరకు స్క్రిప్ట్ నవీకరణలను లోడ్ చేయలేకపోయింది.';
$string['upgradeheading'] = '{$A} కంటెంట్ను అప్గ్రేడ్ చేయండి';
$string['upgradeinprogress'] = '% Ver కు అప్గ్రేడ్ చేస్తోంది';
$string['upgradeinvalidtoken'] = 'లోపం: చెల్లని భద్రతా టోకెన్!';
$string['upgradelibrarycontent'] = 'లైబ్రరీ కంటెంట్ను అప్గ్రేడ్ చేయండి';
$string['upgradelibrarymissing'] = 'లోపం: మీ లైబ్రరీ లేదు!';
$string['upgrademessage'] = 'మీరు {$a} కంటెంట్ ఉదాహరణకు (లు) ను అప్గ్రేడ్ చేయబోతున్నారు. దయచేసి అప్గ్రేడ్ సంస్కరణను ఎంచుకోండి.';
$string['upgradenoavailableupgrades'] = 'ఈ లైబ్రరీ కోసం అందుబాటులో ఉన్న నవీకరణలు లేవు.';
$string['upgradenothingtodo'] = 'అప్గ్రేడ్ చేయడానికి కంటెంట్ సందర్భాల్లో ఏదీ లేదు.';
$string['upgradereturn'] = 'రిటర్న్';
$string['upload'] = 'అప్లోడ్';
$string['uploadlibraries'] = 'లైబ్రరీలను అప్లోడ్ చేయండి';
$string['uploadsizelargerthanpostsize'] = 'మీ PHP గరిష్ట అప్లోడ్ పరిమాణం మీ గరిష్ట పోస్ట్ పరిమాణం కంటే పెద్దదిగా ఉంది. ఇది కొన్ని సంస్థాపనలలో సమస్యలకు కారణమవుతుంది.';
$string['user'] = 'వాడుకరి';
$string['validatingh5pfailed'] = 'ధృవీకరణ h5p ప్యాకేజీ విఫలమైంది.';
$string['validationfailed'] = 'అభ్యర్థించిన H5P చెల్లదు';
$string['viewreportlabel'] = 'నివేదిక';
$string['welcomecommunity'] = 'మీరు H5P ను ఆనందిస్తారని మరియు మా పెరుగుతున్న సంఘంలో మా <a {$a->forums}> ఫోరమ్స్ ద్వారా </a> నిమగ్నమవ్వాలని ఆశిస్తున్నాము.';
$string['welcomecontactus'] = 'మీకు ఏ ఫీడ్బ్యాక్ ఉంటే, <a {$a}> మమ్మల్ని సంప్రదించండి </a> కు వెనుకాడరు. మేము ప్రతిరోజూ చాలా తీవ్రంగా అభిప్రాయాన్ని తీసుకుంటాము మరియు ప్రతిరోజూ H5P ను మెరుగుపరచడానికి అంకితమయ్యాయి!';
$string['welcomegettingstarted'] = 'H5P మరియు Moodle తో ప్రారంభించడానికి, మా <a {$a-> moodle_tutorial}> ట్యుటోరియల్ను చూడండి మరియు ప్రేరణ కోసం H5P.org వద్ద <a {$a-> example_content}> ఉదాహరణ కంటెంట్ని చూడండి.';
$string['welcomeheader'] = 'H5P యొక్క ప్రపంచానికి స్వాగతం!';
$string['wrongversion'] = 'ఈ కంటెంట్లో ఉపయోగించిన H5P లైబ్రరీ {$ a ->% machineName} యొక్క విలువ చెల్లదు. కంటెంట్లో {$ a ->% contentLibrary} ఉంది, కానీ ఇది {$ a ->% సెమాంటిక్స్లైబ్రియర్} ఉండాలి.';
$string['year'] = 'సంవత్సరం';
$string['years'] = 'సంవత్సరం(లు)';
