<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hotpot', language 'te', version '4.3'.
 *
 * @package     hotpot
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abandoned'] = 'వదిలివేసిన.';
$string['abandonhotpot'] = 'ఇప్పటి వరకు మీ ఫలితాలు సేవ్ చేయబడతాయి కానీ మీరు తర్వాత ఈ చర్యను పునఃప్రారంభించలేరు.';
$string['activitycloses'] = 'కార్యాచరణ ముగుస్తుంది';
$string['activitygrade'] = 'కార్యాచరణ స్థాయి.';
$string['activityopens'] = 'కార్యాచరణ తెరుచుకుంటుంది.';
$string['added'] = 'జోడించబడింది.';
$string['addquizchain'] = 'క్విజ్ గొలుసును జోడించండి';
$string['addquizchain_help'] = 'ఒక క్విజ్ గొలుసులో అన్ని క్విజ్లను చేర్చాలా?

** లేవు **
: ఒక క్విజ్ కోర్సులో చేర్చబడుతుంది

** అవును **
: సోర్స్ ఫైల్ ఒక ** క్విజ్ ఫైల్ ** అయితే, ఇది క్విజ్ల గొలుసు యొక్క ప్రారంభంగా పరిగణించబడుతుంది మరియు గొలుసులోని అన్ని క్విజాలను ఒకేలా అమర్పులతో కోర్సుకు జోడించబడతాయి. గొలుసులోని ప్రతి క్విజ్ గొలుసులోని తదుపరి ఫైల్కి లింక్ను కలిగి ఉండాలి.

సోర్స్ ఫైల్ ఒక ** ఫోల్డర్ ** అయితే, ఫోల్డర్లోని అన్ని గుర్తించదగిన క్విజ్లు ఒకే రకమైన సెట్టింగులతో క్విజ్ల గొలుసును రూపొందించడానికి కోర్సులో చేర్చబడతాయి.

సోర్స్ ఫైల్ ఒక ** యూనిట్ ఫైల్ అయితే, ఒక హాట్ బంగాళాదుంపలు masher file లేదా index.html వంటివి, యూనిట్ ఫైల్లో జాబితా చేయబడిన క్విజ్లు కోర్సులో జోడించబడతాయి.';
$string['allowpaste'] = 'పేస్ట్ అనుమతించు';
$string['allowpaste_help'] = 'ఈ సెట్టింగ్ ప్రారంభించబడితే, వచన ఇన్పుట్ పెట్టెల్లో టెక్స్ట్ కాపీ చేసి, పేస్ట్ చేసి, టెక్స్ట్ను లాగండి.';
$string['allowreview'] = 'సమీక్షను అనుమతించండి.';
$string['allowreview_help'] = 'ప్రారంభించబడితే, క్విజ్ మూసివేయబడిన తర్వాత విద్యార్థులు వారి క్విజ్ ప్రయత్నాలను సమీక్షించవచ్చు.';
$string['analysisreport'] = 'అంశం విశ్లేషణ';
$string['attempted'] = 'ప్రయత్నించినది';
$string['attemptlimit'] = 'పరిమితి ప్రయత్నం';
$string['attemptlimit_help'] = 'ఈ HotPot కార్యక్రమంలో విద్యార్ధి యొక్క ప్రయత్నాలు గరిష్ట సంఖ్యలో ఉండవచ్చు';
$string['attemptnumber'] = 'ప్రయత్నించినా నెంబర్';
$string['attempts'] = 'ప్రయత్నాలు';
$string['attemptscore'] = 'ప్రయత్నం స్కోర్';
$string['attemptsunlimited'] = 'అపరిమితమైన ప్రయత్నాలు.';
$string['average'] = 'సరాసరి.';
$string['averagescore'] = 'సగటు స్కోరు.';
$string['bodystyles'] = 'శరీర శైలులు';
$string['bodystylesbackground'] = 'నేపథ్యం రంగు మరియు చిత్రంము.';
$string['bodystylescolor'] = 'టెక్స్ట్ రంగు';
$string['bodystylesfont'] = 'ఫాంట్ పరిమాణం మరియు కుటుంబం';
$string['bodystylesmargin'] = 'ఎడమ మరియు కుడి సరిహద్దు.';
$string['cacherecords'] = 'హాట్పాట్ కాష్ రికార్డులు';
$string['canrestarthotpot'] = 'ఇప్పటి వరకు మీ ఫలితాలు సేవ్ చేయబడతాయి మరియు తర్వాత మీరు "{$a}" ని పునరావృతం చేయగలరు';
$string['canresumehotpot'] = 'ఇప్పటివరకు మీ ఫలితాలు సేవ్ చేయబడతాయి మరియు మీరు తర్వాత "{$a}" ను మళ్ళీ ప్రారంభించవచ్చు.';
$string['checks'] = 'తనిఖీలను';
$string['checksomeboxes'] = 'దయచేసి కొన్ని పెట్టెలను తనిఖీ చేయండి';
$string['clearcache'] = 'హాట్పాట్ కాష్ను క్లియర్ చేయండి';
$string['cleardetails'] = 'హాట్పాట్ వివరాలను క్లియర్ చేయండి';
$string['clearedcache'] = 'HotPot కాష్ క్లియర్ చేయబడింది';
$string['cleareddetails'] = 'హాట్పాట్ వివరాలు క్లియర్ చేయబడ్డాయి';
$string['clickreporting'] = 'రిపోర్టింగ్ క్లిక్ చేయండి';
$string['clickreporting_help'] = 'ప్రారంభించబడితే, ప్రతిసారీ "సూచన", "క్లూ" లేదా "చెక్" బటన్ క్లిక్ చేయబడుతుంది. ఇది ప్రతి క్లిక్కు క్విజ్ యొక్క స్థితిని చూపించే వివరణాత్మక నివేదికను గురువుకు అనుమతిస్తుంది. లేకపోతే, ఒక క్విజ్ వద్ద ఒక్క ప్రయత్నం మాత్రమే ఉంచబడుతుంది.';
$string['clicktrailreport'] = 'ట్రయల్స్ క్లిక్ చేయండి';
$string['closed'] = 'ఈ ఆక్టివిటీ మూసివేయబడింది';
$string['clues'] = 'క్లూస్';
$string['completed'] = 'పూర్తయింది';
$string['completioncompleted'] = 'పూర్తి స్థితి అవసరం';
$string['completionmingrade'] = 'కనీస గ్రేడ్ అవసరం';
$string['completionpass'] = 'గ్రేడ్ పాస్ అవసరం';
$string['completionwarning'] = 'ఈ కార్యాచరణకు గ్రేడ్ పరిమితి "గ్రేడ్ కాదు" లేదా గ్రేడ్ వెయిటింగ్ "నో వైటింగ్"';
$string['configbodystyles'] = 'డిఫాల్ట్గా, మూడ్ల థీమ్ శైలులు హాట్పోట్ కార్యాచరణ శైలులను అధిగమించాయి. అయినప్పటికీ, ఇక్కడ ఎన్నుకున్న శైలుల కోసం, హాట్పోట్ కార్యాచరణ శైలులు మూడ్ల థీమ్ శైలులపై ప్రాధాన్యత ఇవ్వబడతాయి.';
$string['configenablecache'] = 'HotPot క్విజ్ల యొక్క కాష్ని నిర్వహించడం విద్యార్థులకు క్విజ్లను డెలివరీ చేయడానికి నాటకీయంగా వేగవంతం చేస్తుంది.';
$string['configenablecron'] = 'HotPot క్రాన్ స్క్రిప్ట్ అమలు చేయగల మీ టైమ్ జోన్లో గంటలను పేర్కొనండి';
$string['configenablemymoodle'] = 'ఈ సెట్టింగ్లు MyMoodle పేజీలో HotPots జాబితా చేయబడాలో లేదో నియంత్రిస్తుంది';
$string['configenableobfuscate'] = 'జావాస్క్రిప్ట్ కోడ్లో టెక్స్ట్ తీగలను మరియు URL లను అస్పష్టం చేయడం బ్రౌజర్లో HTML పేజీ యొక్క మూలాన్ని వీక్షించడం ద్వారా సమాధానాలను అంచనా వేయడం కష్టతరం చేస్తుంది.';
$string['configenableswf'] = 'HotPot కార్యకలాపాల్లో SWF ఫైల్లను పొందుపర్చడానికి అనుమతించండి. ప్రారంభించబడితే, ఈ సెట్టింగ్ filter_mediaplugin_enable_swf ను భర్తీ చేస్తుంది.';
$string['configfile'] = 'ఆకృతీకరణ ఫైలు';
$string['configframeheight'] = 'ఫ్రేమ్లో ఒక క్విజ్ ప్రదర్శించబడినప్పుడు, ఈ విలువ Moodle నావిగేషన్ బార్ను కలిగి ఉన్న అగ్ర ఫ్రేమ్ యొక్క ఎత్తు (పిక్సెల్స్లో)';
$string['configlocation'] = 'ఆకృతీకరణ ఫైలు స్థానం';
$string['configlockframe'] = 'ఈ సెట్టింగ్ ప్రారంభించబడితే, ఉపయోగించినప్పుడు నావిగేషన్ ఫ్రేమ్ లాక్ చేయబడుతుంది, కనుక ఇది స్క్రోల్ చెయ్యదగినది కాదు, పునఃపరిమాణం చేయబడదు మరియు సరిహద్దు లేదు';
$string['configmaxeventlength'] = 'ఒక HotPot రెండింటికి తెరిచిన మరియు సన్నిహిత సమయాన్ని పేర్కొన్నట్లయితే మరియు రెండు సార్లు మధ్య తేడా ఇక్కడ పేర్కొన్న రోజులు కంటే ఎక్కువగా ఉంటుంది, అప్పుడు రెండు వేర్వేరు క్యాలెండర్ సంఘటనలు కోర్సు క్యాలెండర్కు చేర్చబడతాయి. తక్కువ వ్యవధిలో, లేదా కేవలం ఒక సమయం పేర్కొన్నప్పుడు, ఒక క్యాలెండర్ ఈవెంట్ మాత్రమే జోడించబడుతుంది. సమయం పేర్కొనబడకపోతే, క్యాలెండర్ ఈవెంట్ జోడించబడదు.';
$string['configstoredetails'] = 'ఈ సెట్టింగ్ ప్రారంభించబడితే, HotPot క్విజ్ల యొక్క ప్రయత్నాల యొక్క ముడి XML వివరాలు హాట్పాట్_వివరాల పట్టికలో నిల్వ చేయబడతాయి. ఇది HotPot క్విజ్ స్కోరింగ్ సిస్టమ్లో మార్పులను ప్రతిబింబించేలా క్విజ్ ప్రయత్నాలను భవిష్యత్తులో రిజిడెడ్ చేయడానికి అనుమతిస్తుంది. అయితే, ఈ ఎంపికను బిజీ సైట్లో ఎనేబుల్ చేస్తుంది, ఇది హాట్పాట్_డెవిల్స్ పట్టిక చాలా త్వరగా పెరగడానికి కారణమవుతుంది.';
$string['confirmdeleteattempts'] = 'మీరు నిజంగా ఈ ప్రయత్నాలను తొలగించాలని అనుకుంటున్నారా?';
$string['confirmstop'] = 'మీరు ఖచ్చితంగా ఈ పేజీ నుండి నావిగేట్ చేయాలనుకుంటున్నారా?';
$string['correct'] = 'కచ్చితమైనవి.';
$string['couldnotinsertsubmissionform'] = 'సమర్పణ ఫారమ్ను చొప్పించడం సాధ్యపడలేదు';
$string['d_index'] = 'వివక్ష ఇండెక్స్';
$string['delay1'] = 'ఆలస్యం 1';
$string['delay1_help'] = 'మొదటి మరియు రెండవ ప్రయత్నాల మధ్య కనిష్ట ఆలస్యం.';
$string['delay1summary'] = 'మొదటి మరియు రెండవ ప్రయత్నం మధ్య సమయం ఆలస్యం';
$string['delay2'] = 'ఆలస్యం 2';
$string['delay2_help'] = 'రెండవ ప్రయత్నం తర్వాత ప్రయత్నాల మధ్య కనిష్ట ఆలస్యం.';
$string['delay2summary'] = 'తదుపరి ప్రయత్నాల మధ్య సమయం ఆలస్యం';
$string['delay3'] = 'ఆలస్యం 3';
$string['delay3_help'] = 'సెట్టింగు క్విజ్ ను పూర్తి చేసి, డిస్ప్లే నియంత్రణ మూడ్లెకు మధ్య ఆలస్యం నిర్దేశిస్తుంది.

** నిర్దిష్ట ఆలస్యం ఉపయోగించండి **
: నిర్దిష్ట ఆలస్యం తర్వాత నియంత్రణ Moodle కు తిరిగి వస్తుంది.

** మూలం / టెంప్లేట్ ఫైల్ లో సెట్టింగ్లను ఉపయోగించండి **
: మూలం ఫైల్ లేదా ఈ అవుట్పుట్ ఫార్మాట్ కోసం టెంప్లేట్ ఫైళ్లలో పేర్కొన్న సెకన్లు సంఖ్య తర్వాత Moodle కు తిరిగి ఇవ్వబడుతుంది.

** విద్యార్థి క్లిక్ OK వరకు వేచి ఉండండి **
: క్విజ్లో పూర్తి సందేశానికి విద్యార్థి OK బటన్ను క్లిక్ చేసిన తర్వాత Moodle కు నియంత్రణ తిరిగి ఉంటుంది.

** స్వయంచాలకంగా కొనసాగించవద్దు **
: క్విజ్ పూర్తయిన తర్వాత నియంత్రణ మూడ్లకి తిరిగి పంపబడదు. విద్యార్థి క్విజ్ పేజీ నుండి దూరంగా నావిగేట్ చెయ్యడానికి ఉచితం.

గమనిక, క్విజ్ ఫలితాలు ఎల్లప్పుడూ ఈ సెట్టింగుతో సంబంధం లేకుండా క్విజ్ పూర్తయ్యింది లేదా రద్దు చేయబడిన వెంటనే మూడ్లకి తిరిగి వీస్తాయి.';
$string['delay3afterok'] = 'విద్యార్థి  OK  నొక్కె వరకు వేచి ఉండండి.';
$string['delay3disable'] = 'కొనసాగించు';
$string['delay3specific'] = 'నిర్దిష్ట సమయం ఉపయోగించండి (సెకన్లలో).';
$string['delay3summary'] = 'క్విజ్ చివరిలో సమయం ఆలస్యం.';
$string['delay3template'] = 'సోర్స్ / టెంప్లేట్ ఫైల్ లో సెట్టింగ్లను ఉపయోగించండి';
$string['deleteallattempts'] = 'అన్ని ప్రయత్నాలను తొలగించండి.';
$string['deleteattempts'] = 'ప్రయత్నాలను తొలగించండి.';
$string['detailsrecords'] = 'హాట్పాట్ వివరాలు రికార్డులు';
$string['duration'] = 'కాలపరిమానం.';
$string['enablecache'] = 'HotPot కాష్ను ప్రారంభించండి';
$string['enablecron'] = 'హాట్పాట్ క్రాన్ను ప్రారంభించండి';
$string['enablemymoodle'] = 'MyMoodle లో HotPots ను చూపించు';
$string['enableobfuscate'] = 'టెక్స్ట్ మరియు మీడియా ప్లేయర్ల అస్పష్టతను ప్రారంభించండి';
$string['enableswf'] = 'HotPot కార్యకలాపాల్లో SWF ఫైల్లను పొందుపర్చడానికి అనుమతించండి';
$string['entry_attempts'] = 'ప్రయత్నాలు.';
$string['entry_dates'] = 'తేదీలు';
$string['entry_grading'] = 'గ్రేడింగ్';
$string['entry_title'] = 'టైటిల్ గా యూనిట్ పేరు';
$string['entrycm'] = 'మునుపటి కార్యాచరణ.';
$string['entrycm_help'] = 'ఈ సెట్టింగ్ ఒక మూడ్ల కార్యాచరణను మరియు ఈ హాట్పాట్ కార్యాచరణను ప్రయత్నించడానికి ముందు తప్పనిసరిగా సాధించే కార్యాచరణకు కనీస గ్రేడ్ను పేర్కొంటుంది.

గురువు ఒక ప్రత్యేక కార్యాచరణను ఎంచుకోవచ్చు,
లేదా క్రింది సాధారణ ప్రయోజన అమర్పులలో ఒకటి:

* ఈ కోర్సులో మునుపటి కార్యాచరణ
* ఈ విభాగంలో మునుపటి కార్యాచరణ
* ఈ కోర్సులో మునుపటి హాట్పోట్
* ఈ విభాగంలో మునుపటి హాట్పోట్';
$string['entrycmcourse'] = 'ఈ కోర్సు లో మునుపటి కార్యాచరణ.';
$string['entrycmsection'] = 'ఈ కోర్సు విభాగంలో మునుపటి కార్యాచరణ';
$string['entrycompletionwarning'] = 'మీరు ఈ చర్యను ప్రారంభించడానికి ముందు, మీరు తప్పనిసరిగా {$a} లో చూడాలి.';
$string['entrygrade'] = 'మునుపటి కార్యాచరణ గ్రేడ్';
$string['entrygradewarning'] = '{$a->entrygrade}% {$a->entryactivity} పై స్కోరు చేసేవరకు మీరు ఈ చర్యను ప్రారంభించలేరు. ప్రస్తుతం, ఆ కార్యాచరణకు మీ గ్రేడ్ {$a->usergrade}%';
$string['entryhotpotcourse'] = 'ఈ కోర్సులో హాట్పాట్';
$string['entryhotpotsection'] = 'ఈ కోర్సు విభాగంలో హాట్పాట్';
$string['entryoptions'] = 'ఎంట్రీ పేజీ ఎంపికలు';
$string['entryoptions_help'] = 'ఈ తనిఖీ పెట్టెలు HotPot ప్రవేశం పేజీలోని అంశాల ప్రదర్శనను ఎనేబుల్ చేసి, ఆపివేస్తాయి.

** టైటిల్ గా యూనిట్ పేరు **
: తనిఖీ చేస్తే, ప్రవేశం పేజీ యొక్క శీర్షికగా యూనిట్ పేరు ప్రదర్శించబడుతుంది.

** గ్రేడింగ్ **
: తనిఖీ చేస్తే, హాట్పోట్ యొక్క గ్రేడింగ్ సమాచారం ఎంట్రీ పేజీలో ప్రదర్శించబడుతుంది.

** తేదీలు **
: తనిఖీ చేస్తే, హాట్పోట్ యొక్క ఓపెన్ మరియు దగ్గరి తేదీలు ఎంట్రీ పేజీలో ప్రదర్శించబడతాయి.

** ప్రయత్నాలు **
: తనిఖీ చేస్తే, ఈ HotPot లో యూజర్ యొక్క మునుపటి ప్రయత్నాల వివరాలు చూపించే టేబుల్ ఎంట్రీ పేజీలో ప్రదర్శించబడుతుంది. పునఃప్రారంభమయ్యే ప్రయత్నాలు కుడివైపు నిలువు వరుసలో ప్రదర్శించబడే పునఃప్రారంభం బటన్ను కలిగి ఉంటాయి.';
$string['entrypage'] = 'ఎంట్రీ పేజీని చూపించు';
$string['entrypage_help'] = 'HotPot కార్యాచరణను ప్రారంభించడానికి ముందు విద్యార్థులు ప్రారంభ పేజీని చూపించాలా?

** అవును **
: HotPot ప్రారంభించటానికి ముందు విద్యార్ధులు ఎంట్రీ పేజీని చూపించబడతారు. ఎంట్రీ పేజీ యొక్క కంటెంట్ HotPot యొక్క ఎంట్రీ పేజీ ఎంపికల ద్వారా నిర్ణయించబడుతుంది.

** లేవు **
: విద్యార్థులు ఎంట్రీ పేజీ చూపబడదు, మరియు వెంటనే HotPot ప్రారంభమౌతుంది.

ఎంట్రీ పేజీ ఎల్లప్పుడూ ఉపాధ్యాయుడికి చూపబడుతుంది, నివేదికలు యాక్సెస్ మరియు క్విజ్ పేజీని సవరించడానికి';
$string['entrypagehdr'] = 'ఎంట్రీ పేజ్';
$string['entrytext'] = 'పేజీలో వచనం ఎంట్రీ చెయ్యటం.';
$string['event_attempt_reviewed'] = 'HotPot ప్రయత్నం సమీక్షించబడింది';
$string['event_attempt_reviewed_description'] = 'Id "{$a->userid}" వినియోగదారు "హాట్ స్పాట్" కార్యక్రమంలో కోర్సు మాడ్యూల్ ఐడి "{$a->cmid}" తో ఒక ప్రయత్నాన్ని సమీక్షించారు.';
$string['event_attempt_reviewed_explanation'] = 'హాట్పోట్ కార్యాచరణలో ఒక వినియోగదారు కేవలం ఒక ప్రయత్నాన్ని సమీక్షించారు';
$string['event_attempt_started'] = 'హాట్పాట్ ప్రయత్నం ప్రారంభమైంది';
$string['event_attempt_started_description'] = 'Id "{$a->userid}" వినియోగదారు "హాట్ స్పాట్" కార్యక్రమంలో కోర్సు మాడ్యూల్ id "{$a->cmid}"';
$string['event_attempt_started_explanation'] = 'హాట్పోట్ కార్యాచరణలో ఒక వినియోగదారు ఇప్పుడే ఒక ప్రయత్నాన్ని ప్రారంభించారు';
$string['event_attempt_submitted'] = 'HotPot ప్రయత్నం సమర్పించబడింది';
$string['event_attempt_submitted_description'] = 'Id "{$a->userid}" వినియోగదారు "హాట్ స్పాట్" కార్యక్రమంలో కోర్సు మాడ్యూల్ id "{$a->cmid}"';
$string['event_attempt_submitted_explanation'] = 'హాట్పోట్ కార్యాచరణలో ఒక వినియోగదారు కేవలం ఒక ప్రయత్నాన్ని సమర్పించారు';
$string['event_base'] = 'హాట్పాట్ ఈవెంట్ కనుగొనబడింది';
$string['event_base_description'] = 'Id "{$a->userid}" వినియోగదారు "హాట్ స్పాట్" కార్యక్రమంలో కోర్సు మాడ్యూల్ id "{$a->cmid}';
$string['event_base_explanation'] = 'హాట్పోట్ మాడ్యూల్ ద్వారా ఒక ఈవెంట్ కనుగొనబడింది';
$string['event_report_viewed'] = 'హాట్పాట్ నివేదిక వీక్షించబడింది';
$string['event_report_viewed_description'] = 'ID "{$a->userid}" వినియోగదారు "హాట్ స్పాట్" కార్యక్రమంలో కోర్సు మాడ్యూల్ ఐడి "{$a->cmid}"';
$string['event_report_viewed_explanation'] = 'HotPot కార్యాచరణలో ప్రయత్నాల గురించి ఒక వినియోగదారు కేవలం ఒక నివేదికను చూసారు';
$string['exit_areyouok'] = 'హలో, మీరు ఇప్పటికీ ఉన్నారా?';
$string['exit_attemptscore'] = 'ఆ ప్రయత్నం కోసం మీ స్కోర్ {$a}';
$string['exit_course'] = 'కోర్సు';
$string['exit_course_text'] = 'ప్రధాన కోర్సు పేజీకి తిరిగి వెళ్ళండి.';
$string['exit_encouragement'] = 'ప్రోత్సాహం.';
$string['exit_excellent'] = 'అధ్బుతం.';
$string['exit_feedback'] = 'పేజీ అభిప్రాయాన్ని నిష్క్రమించండి';
$string['exit_feedback_help'] = 'ఈ ఎంపికలు HotPot నిష్క్రమణ పేజీలో ఫీడ్బ్యాక్ అంశాల ప్రదర్శనను నిలిపివేయడం మరియు నిలిపివేయడం.

** టైటిల్ గా యూనిట్ పేరు **
: తనిఖీ చేస్తే, నిష్క్రమణ పేజీ యొక్క శీర్షికగా యూనిట్ పేరు ప్రదర్శించబడుతుంది.

** ప్రోత్సాహం **
: తనిఖీ చేస్తే, నిష్క్రమణ పేజీలో కొన్ని ప్రోత్సాహం ప్రదర్శించబడుతుంది. ప్రోత్సాహం HotPot గ్రేడ్ మీద ఆధారపడి ఉంటుంది:
: ** & gt; 90% **: అద్భుతమైనది!
: ** & gt; 60% **: బాగా చేసాను
: ** & gt; 0% **: మంచి ప్రయత్నం
: ** = 0% **: మీరు సరేనా?

** యూనిట్ ప్రయత్నం గ్రేడ్ **
: తనిఖీ చేస్తే, కేవలం పూర్తయిన యూనిట్ ప్రయత్నం కోసం గ్రేడ్ నిష్క్రమణ పేజీలో ప్రదర్శించబడుతుంది.

** యూనిట్ గ్రేడ్ **
: తనిఖీ ఉంటే HotPot గ్రేడ్ నిష్క్రమణ పేజీలో ప్రదర్శించబడుతుంది.

అంతేకాక, యూనిట్ గ్రేడింగ్ మెథడ్ అత్యధికంగా ఒక సందేశాన్ని వినియోగదారుకు చెప్పడానికి ఒకవేళ అత్యంత ఇటీవలి ప్రయత్నం సమానంగా ఉన్నట్లయితే లేదా వారి మునుపటి కంటే ప్రదర్శించబడుతుంది.';
$string['exit_goodtry'] = 'మంచి ప్రయత్నము.';
$string['exit_grades'] = 'తరగతులు.';
$string['exit_grades_text'] = 'ఈ కోర్సు కోసం మీ తరగతులు ఇప్పటివరకు చూడండి';
$string['exit_hotpotgrade'] = 'ఈ కార్యాచరణకు మీ గ్రేడ్ {$a}';
$string['exit_hotpotgrade_average'] = 'ఈ సూచించే ఇప్పటివరకు మీ సగటు గ్రేడ్ {$a}';
$string['exit_hotpotgrade_highest'] = 'ఇప్పటి వరకు మీ అత్యుత్తమ స్థాయి ఈ చర్యకు {$a}';
$string['exit_hotpotgrade_highest_equal'] = 'మీరు ఈ కార్యాచరణ కోసం మీ మునుపటి ఉత్తమ సమం చేసారు!';
$string['exit_hotpotgrade_highest_previous'] = 'ఈ కార్యాచరణకు మీ మునుపటి అత్యధిక గ్రేడ్ {$a}';
$string['exit_hotpotgrade_highest_zero'] = 'మీరు ఇంకా ఈ కార్యాచరణ కోసం {$a} కంటే ఎక్కువగా స్కోర్ చేయలేదు';
$string['exit_index'] = 'సూచిక.';
$string['exit_index_text'] = 'కార్యకలాపాల సూచికకు వెళ్ళండి';
$string['exit_links'] = 'పేజీ లింకులు నిష్క్రమించండి';
$string['exit_links_help'] = 'ఈ ఎంపికలు HotPot నిష్క్రమణ పేజీలో కొన్ని నావిగేషన్ లింక్ల ప్రదర్శనను ఎనేబుల్ చేసి, ఆపివేస్తాయి.

** మళ్ళీ ప్రయత్నించు **
: ఈ HotPot వద్ద బహుళ ప్రయత్నాలు అనుమతించబడినా మరియు విద్యార్థి ఇప్పటికీ కొన్ని ప్రయత్నాలు మిగిలి ఉంటే, HotPot ను మళ్ళీ ప్రయత్నించడానికి విద్యార్థి అనుమతించే లింక్ ప్రదర్శించబడుతుంది

** ఇండెక్స్ **
: తనిఖీ చేస్తే, HotPot ఇండెక్స్ పేజీకి లింక్ ప్రదర్శించబడుతుంది.

** కోర్సు **
: తనిఖీ చేస్తే, Moodle కోర్సు పేజీకి లింక్ ప్రదర్శించబడుతుంది.

** తరగతులు **
: తనిఖీ చేస్తే, Moodle గ్రేడ్బుకు లింక్ ప్రదర్శించబడుతుంది.';
$string['exit_next'] = 'తర్వాత.';
$string['exit_next_text'] = 'తదుపరి కార్యాచరణను ప్రయత్నించండి.';
$string['exit_noscore'] = 'మీరు విజయవంతంగా ఈ కార్యాచరణను పూర్తి చేశారు!.';
$string['exit_retry'] = 'మళ్లీ ప్రయత్నించు.';
$string['exit_retry_text'] = 'ఈ కార్యాచరణను మళ్లీ ప్రయత్నించు.';
$string['exit_welldone'] = 'అభినందనలు!.';
$string['exit_whatnext_0'] = 'మీరు తర్వాత ఏమి చేయాలనుకుంటున్నారు?';
$string['exit_whatnext_1'] = 'మీ గమ్యం ఎంచుకోండి ...';
$string['exit_whatnext_default'] = 'దయచేసి క్రింది వాటిలో ఒకదాన్ని ఎంచుకోండి:';
$string['exitcm'] = 'తదుపరి చర్య';
$string['exitcm_help'] = 'ఈ సెట్టింగ్, ఈ HotPot కార్యాచరణ పూర్తయిన తర్వాత చేయడానికి ఒక Moodle కార్యాచరణను పేర్కొంటుంది. తదుపరి సూచించే చూపడానికి ముందు అవసరమైన ఈ హాట్పాట్ సూచించే ఐచ్ఛిక గ్రేడ్ కనీస గ్రేడ్.

ఉపాధ్యాయుడు నిర్దిష్ట కార్యాచరణను లేదా క్రింది సాధారణ ప్రయోజన అమర్పుల్లో ఒకదానిని ఎంచుకోవచ్చు:

ఈ కోర్సులో తదుపరి చర్య
ఈ విభాగంలో తదుపరి చర్య
ఈ కోర్సులో తదుపరి హాట్పాట్ చర్య
ఈ విభాగంలో తదుపరి హాట్పాట్ చర్య

ఇతర నిష్క్రమణ పేజీ ఎంపికలు నిలిపివేయబడితే మరియు విద్యార్థి ఈ హాట్పాట్ కార్యకలాపంలో అవసరమైన గ్రేడ్ను సాధించినట్లయితే, తదుపరి కార్యాచరణ వెంటనే చూపబడుతుంది. లేకపోతే, విద్యార్థి తదుపరి చర్యకు లింక్ను చూపించబడతారు, వారు సిద్ధంగా ఉన్నప్పుడు వారు క్లిక్ చేయవచ్చు.';
$string['exitcmcourse'] = 'ఈ కోర్సు తదుపరి కార్యాచరణ.';
$string['exitcmsection'] = 'ఈ కోర్సు విభాగంలో తదుపరి కార్యాచరణ';
$string['exitgrade'] = 'తదుపరి కార్యాచరణ స్థాయి.';
$string['exithotpotcourse'] = 'ఈ కోర్సులో తదుపరి హాట్పోట్';
$string['exithotpotsection'] = 'ఈ కోర్సు విభాగంలో తదుపరి హాట్పాట్';
$string['exitoptions'] = 'పేజీ ఎంపికలను నిష్క్రమించండి';
$string['exitpage'] = 'నిష్క్రమణ పేజీ చూపించండి.';
$string['exitpage_help'] = 'HotPot క్విజ్ పూర్తయిన తర్వాత నిష్క్రమణ పేజీ ప్రదర్శించబడాలా?

** అవును **
: HotPot పూర్తయినప్పుడు విద్యార్థులు నిష్క్రమించే పేజీని చూపించబడతారు. నిష్క్రమణ పేజీ యొక్క కంటెంట్లను హాట్పాట్ యొక్క నిష్క్రమణ పేజీ చూడు మరియు లింక్ల కోసం సెట్టింగులు నిర్ణయించబడతాయి.

** లేవు **
: విద్యార్థులు ఒక నిష్క్రమణ పేజీ చూపించబడదు. బదులుగా, వారు తదుపరి చర్యకు వెంటనే వెళ్తారు లేదా Moodle కోర్సు పేజీకి తిరిగి వెళతారు.';
$string['exitpagehdr'] = 'పేజీ నిష్క్రమించండి';
$string['exittext'] = 'పేజీ టెక్స్ట్ నుండి నిష్క్రమించు';
$string['feedbackdiscuss'] = 'ఫోరమ్లో ఈ క్విజ్ గురించి చర్చించండి';
$string['feedbackformmail'] = 'అభిప్రాయమును తెలియ చేయు ఫారము';
$string['feedbackmoodleforum'] = 'Moodle ఫోరమ్';
$string['feedbackmoodlemessaging'] = 'ముడిల్ సందేశం';
$string['feedbacknone'] = 'గమనిక';
$string['feedbacksendmessage'] = 'మీ బోధకుడికి ఒక సందేశాన్ని పంపండి';
$string['feedbackwebpage'] = 'వెబ్ పేజీ';
$string['firstattempt'] = 'మొదటి ప్రయత్నం';
$string['forceplugins'] = 'మీడియా ప్లగిన్లను బలవంతం చేయండి';
$string['forceplugins_help'] = 'ప్రారంభించబడితే, Moodle-compatible media players avi, mpeg, mpg, mp3, mov మరియు wmv వంటి ఫైళ్ళను ప్లే చేస్తాయి. లేకపోతే, క్విజ్లో ఏదైనా మీడియా ప్లేయర్ల సెట్టింగులను Moodle మార్చదు.';
$string['frameheight'] = 'ఫ్రేమ్ ఎత్తు';
$string['giveup'] = 'పనిని నిలిపివేయుట';
$string['grademethod'] = 'గ్రేడింగ్ పద్ధతి';
$string['grademethod_help'] = 'ప్రయత్నం స్కోర్ల నుండి HotPot గ్రేడ్ ఎలా లెక్కించబడుతుందో ఈ సెట్టింగ్ వివరిస్తుంది.

** అత్యధిక స్కోరు **
: ఈ HotPot కార్యకలాపానికి ప్రయత్నం కోసం గ్రేడ్ అత్యధిక స్కోర్కు సెట్ చేయబడుతుంది.

** సగటు scsore **
: ఈ HotPot కార్యకలాపాల్లో ప్రయత్నాల కోసం సగటు స్కోరును గ్రేడ్ సెట్ చేస్తుంది.

**మొదటి ప్రయత్నం**
: ఈ HotPot కార్యాచరణలో మొదటి ప్రయత్నం యొక్క స్కోరుకు గ్రేడ్ సెట్ చేయబడుతుంది.

** చివరి ప్రయత్నం **
: ఈ HotPot కార్యాచరణలో ఇటీవల ప్రయత్నం యొక్క స్కోరుకు గ్రేడ్ సెట్ చేయబడుతుంది.';
$string['gradeweighting'] = 'గ్రేడ్ వెయిటింగ్';
$string['gradeweighting_help'] = 'ఈ HotPot కార్యాచరణ కోసం ప్రమాణాలు Moodle గ్రేడ్బుక్లో ఈ సంఖ్యకు స్కేల్ చేయబడతాయి.';
$string['highestscore'] = 'అత్యధిక స్కోరు';
$string['hints'] = 'సూచనలు';
$string['hotpot:addinstance'] = 'క్రొత్త హాట్పాట్ కార్యాచరణను జోడించండి';
$string['hotpot:attempt'] = 'హాట్పోట్ కార్యాచరణను ప్రయత్నించి ఫలితాలు సమర్పించండి';
$string['hotpot:deleteallattempts'] = 'HotPot కార్యాచరణలో ఏదైనా వినియోగదారు యొక్క ప్రయత్నాలను తొలగించండి';
$string['hotpot:deletemyattempts'] = 'HotPot కార్యాచరణలో మీ స్వంత ప్రయత్నాలను తొలగించండి';
$string['hotpot:ignoretimelimits'] = 'హాట్పోట్ కార్యాచరణలో సమయ పరిమితులను విస్మరిస్తుంది';
$string['hotpot:manage'] = 'హాట్పోట్ కార్యాచరణ యొక్క సెట్టింగ్లను మార్చండి';
$string['hotpot:preview'] = 'హాట్పోట్ కార్యాచరణను పరిదృశ్యం చేయండి';
$string['hotpot:reviewallattempts'] = 'HotPot కార్యాచరణలో ఏదైనా వినియోగదారు యొక్క ప్రయత్నాలను వీక్షించండి';
$string['hotpot:reviewmyattempts'] = 'HotPot కార్యాచరణలో మీ స్వంత ప్రయత్నాలను వీక్షించండి';
$string['hotpot:view'] = 'హాట్పోట్ కార్యాచరణ యొక్క ప్రవేశం పేజీని వీక్షించండి';
$string['hotpotname'] = 'హాట్పాట్ కార్యాచరణ పేరు';
$string['ignored'] = 'విస్మరించబడిన';
$string['inprogress'] = 'పురోగతిలో ఉంది';
$string['isgreaterthan'] = 'కన్నా ఎక్కువ';
$string['islessthan'] = 'తక్కువ';
$string['lastaccess'] = 'చివరి ప్రాప్యత';
$string['lastattempt'] = 'చివరి ప్రయత్నం';
$string['lockframe'] = 'ఫ్రేమ్ లాక్';
$string['maxeventlength'] = 'ఒకే క్యాలెండర్ ఈవెంట్ కోసం గరిష్ట రోజుల సంఖ్య';
$string['mediafilter_hotpot'] = 'హాట్పోట్ మీడియా ఫిల్టర్';
$string['mediafilter_moodle'] = 'మూడ్ల యొక్క ప్రామాణిక మీడియా ఫిల్టర్లు';
$string['migratingfiles'] = 'హాట్ బంగాళాదుంపల క్విజ్ ఫైళ్ళను మారుస్తుంది';
$string['migratinglogs'] = 'హాట్ బంగాళాదుంపలు లాగ్లను తరలించడం';
$string['missingsourcetype'] = 'హాట్పాట్ రికార్డు sourcetype లేదు';
$string['modulename'] = 'వేడి కుండ';
$string['modulename_help'] = 'హాట్పాట్ మాడ్యూల్ ఉపాధ్యాయులు వారి విద్యార్థులకు ఇంటరాక్టివ్ అభ్యాసా పదార్థాలను Moodle ద్వారా పంపిణీ చేయడానికి మరియు విద్యార్థుల స్పందనలు మరియు ఫలితాలపై నివేదికలను వీక్షించడానికి అనుమతిస్తుంది. .

ఒక సింగిల్ హాట్పాట్ కార్యకలాపం ఒక ఐచ్ఛిక ఎంట్రీ పేజీ, ఒక ఏన్లీనింగ్ వ్యాయామం మరియు ఒక ఐచ్ఛిక నిష్క్రమణ పేజీ కలిగి ఉంటుంది. పదకొండు వ్యాయామం అనేది స్టాటిక్ వెబ్ పేజ్ లేదా ఇంటరాక్టివ్ వెబ్ పేజ్ కావచ్చు, ఇది విద్యార్థులు టెక్స్ట్, ఆడియో మరియు దృశ్యమాన ప్రాంప్ట్లను అందిస్తుంది మరియు వారి ప్రతిస్పందనలను నమోదు చేస్తుంది. ఉపాధ్యాయుల సాఫ్ట్వేర్ను ఉపయోగించి ఉపాధ్యాయుని కంప్యూటర్లో ఏలీన్రింగ్ వ్యాయామం సృష్టించబడుతుంది, తరువాత మూడ్లెకు అప్లోడ్ చేయబడుతుంది.

ఒక HotPot చర్య క్రింది రచనా సాఫ్ట్వేర్తో సృష్టించిన వ్యాయామాలను నిర్వహించగలదు:

* హాట్ బంగాళదుంపలు (సంస్కరణ 6)
Qedoc
* జెర్టే
* ippring
ఏ HTML ఎడిటర్';
$string['modulename_link'] = 'mod/hotpot/view';
$string['modulenameplural'] = 'వేడి కుండ';
$string['nameadd'] = 'పేరు';
$string['nameadd_help'] = 'ఈ పేరు ఉపాధ్యాయునిచే ఇవ్వబడిన ప్రత్యేకమైన టెక్స్ట్ కావచ్చు లేదా ఇది స్వయంచాలకంగా సృష్టించబడుతుంది.

** మూలం ఫైల్ నుండి పొందండి **
: పేరు మూలం ఫైల్ నుండి సంగ్రహించబడుతుంది.

** సోర్స్ ఫైల్ పేరును ఉపయోగించండి **
: మూలం ఫైల్ పేరు పేరుగా ఉపయోగించబడుతుంది.

** సోర్స్ ఫైల్ పాత్ ఉపయోగించండి **
: మూల ఫైల్ మార్గం పేరుగా ఉపయోగించబడుతుంది. ఫైల్ మార్గంలో ఏదైనా శ్లాష్లు ఖాళీలు ద్వారా భర్తీ చేయబడతాయి.

** నిర్దిష్ట టెక్స్ట్ **
: ఉపాధ్యాయుని ద్వారా నమోదు చేయబడిన నిర్దిష్ట టెక్స్ట్ పేరుగా ఉపయోగించబడుతుంది.';
$string['nameedit'] = 'పేరు';
$string['nameedit_help'] = 'విద్యార్థులకు ప్రదర్శించబడే నిర్దిష్ట టెక్స్ట్';
$string['navigation'] = 'నావిగేషన్';
$string['navigation_embed'] = 'పొందుపరిచిన వెబ్ పేజీ';
$string['navigation_frame'] = 'Moodle నావిగేషన్ ఫ్రేం';
$string['navigation_give_up'] = 'ఒక సింగిల్ & quot; గివ్ అప్ & quot; బటన్';
$string['navigation_help'] = 'ఈ అమరిక క్విజ్లో ఉపయోగించిన నావిగేషన్ను నిర్దేశిస్తుంది:

** Moodle నావిగేషన్ బార్ **
: Moodle నావిగేషన్ బార్ పేజీ ఎగువ క్విజ్లో అదే విండోలో ప్రదర్శించబడుతుంది

** మూడ్ల నావిగేషన్ ఫ్రేం **
: క్విజ్ ఎగువన ప్రత్యేక ఫ్రేమ్లో Moodle నావిగేషన్ బార్ ప్రదర్శించబడుతుంది

** పొందుపరిచిన వెబ్ పేజీ **
: విండోస్ లోపల పొందుపర్చిన హాట్ బంగాళాదుంపల క్విజ్తో Moodle నావిగేషన్ బార్ ప్రదర్శించబడుతుంది

** ఒరిజినల్ నావిగేషన్ ఎయిడ్స్ **
: క్విజ్లో నావిగేషన్ బటన్లతో, ఏదైనా ఉంటే, క్విజ్లో నిర్వచిస్తారు

** సింగిల్ "గివ్ అప్" బటన్ **
: క్విజ్ పేజీ ఎగువన ఒక సింగిల్ "గివ్ అప్" బటన్తో ప్రదర్శించబడుతుంది

** గమనిక **
: క్విజ్ ఏ నావిగేషన్ ఎయిడ్స్ లేకుండా ప్రదర్శించబడుతుంది, కాబట్టి అన్ని ప్రశ్నలకు సరిగ్గా సమాధానాలు ఇవ్వబడినప్పుడు, "తదుపరి క్విజ్ను చూపించునా?" అమర్పు, Moodle కోర్సు పేజీకి తిరిగి రావడం లేదా తదుపరి క్విజ్ ప్రదర్శిస్తుంది';
$string['navigation_moodle'] = 'ప్రామాణిక Moodle నావిగేషన్ బార్లు (ఎగువ మరియు ప్రక్క)';
$string['navigation_none'] = 'ఏమీలేదు.';
$string['navigation_original'] = 'అసలు పేజీకి సంబంధించిన లింకులు AIDS';
$string['navigation_topbar'] = 'టాప్ Moodle నావిగేషన్ బార్ మాత్రమే (ఏ వైపు బార్లు)';
$string['noactivity'] = 'ఎటువంటి కార్యాచరణలేదు.';
$string['nohotpots'] = 'Hotpots దొరకలేదు';
$string['nomoreattempts'] = 'క్షమించండి, ఈ కార్యాచరణలో మీకు మరిన్ని ప్రయత్నాలు లేవు';
$string['noresponses'] = 'వ్యక్తిగత ప్రశ్నలు మరియు ప్రతిస్పందనల గురించి ఏ సమాచారం కనుగొనబడలేదు.';
$string['noreview'] = 'క్షమించండి, ఈ క్విజ్ ప్రయత్నం యొక్క వివరాలను చూడడానికి మీకు అనుమతి లేదు.';
$string['noreviewafterclose'] = 'క్షమించండి, ఈ క్విజ్ మూసివేయబడింది. ఈ క్విజ్ ప్రయత్నం యొక్క వివరాలను చూడడానికి మీకు ఇకపై అనుమతి లేదు.';
$string['noreviewbeforeclose'] = 'క్షమించండి, వివరాలు ఈ క్విజ్ ప్రయత్నాన్ని {$a} వరకు చూడడానికి మీకు అనుమతి లేదు.';
$string['nosourcefilesettings'] = 'HotPot నివేదికలో మూల ఫైల్ సమాచారం లేదు';
$string['notattemptedyet'] = 'ఇంకా ప్రయత్నించలేదు';
$string['notavailable'] = 'క్షమించండి, ఈ కార్యాచరణ ప్రస్తుతం మీకు అందుబాటులో లేదు.';
$string['outputformat'] = 'అవుట్ పుట్ ఆకృతి.';
$string['outputformat_best'] = 'ఉత్తమ';
$string['outputformat_help'] = 'అవుట్పుట్ ఫార్మాట్ కంటెంట్ను విద్యార్థులకు ఎలా సమర్పించాలో పేర్కొంటుంది.

అందుబాటులో ఉన్న అవుట్పుట్ ఫార్మాట్లు మూలం ఫైల్ యొక్క రకాన్ని బట్టి ఉంటాయి. కొన్ని రకాలైన మూలం ఫైల్ కేవలం ఒక అవుట్పుట్ ఫార్మాట్ కలిగివుండగా, ఇతర రకాల మూలం ఫైల్లో అనేక అవుట్పుట్ ఫార్మాట్లు ఉన్నాయి.

"ఉత్తమ" సెట్టింగ్ విద్యార్థుల బ్రౌజర్ కోసం సరైన ఉత్పత్తి ఆకృతిని ఉపయోగించి కంటెంట్ను ప్రదర్శిస్తుంది.';
$string['outputformat_hp_6_jcloze_html'] = 'Html నుండి JCloze (v6)';
$string['outputformat_hp_6_jcloze_html_dropdown'] = 'Html నుండి డౌన్డౌన్';
$string['outputformat_hp_6_jcloze_html_findit_a'] = 'FindIt (a) html నుండి';
$string['outputformat_hp_6_jcloze_html_findit_b'] = 'FindIt (b) html నుండి';
$string['outputformat_hp_6_jcloze_html_jgloss'] = 'Html నుండి JGloss';
$string['outputformat_hp_6_jcloze_xml_anctscan'] = 'HP6 JCloze xml నుండి ANCT- స్కాన్';
$string['outputformat_hp_6_jcloze_xml_dropdown'] = 'HP6 JCloze xml నుండి డౌన్డౌన్';
$string['outputformat_hp_6_jcloze_xml_findit_a'] = 'FindIt (a) HP6 JCloze xml నుండి';
$string['outputformat_hp_6_jcloze_xml_findit_b'] = 'FindIt (బి) HP6 JCloze xml నుండి';
$string['outputformat_hp_6_jcloze_xml_jgloss'] = 'HP6 JCloze xml నుండి JGloss';
$string['outputformat_hp_6_jcloze_xml_v6'] = 'HP6 xml నుండి JCloze (v6)';
$string['outputformat_hp_6_jcloze_xml_v6_autoadvance'] = 'HP6 xml (ఆటో-అడ్వాన్స్) నుండి JCloze (v6)';
$string['outputformat_hp_6_jcross_html'] = 'Html నుండి JCross (v6)';
$string['outputformat_hp_6_jcross_xml_v6'] = 'Xml నుండి JCross (v6)';
$string['outputformat_hp_6_jmatch_html'] = 'Html నుండి JMatch (v6)';
$string['outputformat_hp_6_jmatch_html_sort'] = 'JMatch htm నుండి క్రమీకరించు';
$string['outputformat_hp_6_jmatch_xml_flashcard'] = 'Xml నుండి JMatch (ఫ్లాష్కార్డ్)';
$string['outputformat_hp_6_jmatch_xml_jmemori'] = 'Xml నుండి JMemori';
$string['outputformat_hp_6_jmatch_xml_sort'] = 'Xml నుండి JMatch క్రమీకరించు';
$string['outputformat_hp_6_jmatch_xml_v6'] = 'Xml నుండి JMatch (v6)';
$string['outputformat_hp_6_jmatch_xml_v6_plus'] = 'Xml నుండి JMatch (v6 +)';
$string['outputformat_hp_6_jmix_html'] = 'Html నుండి JMix (v6)';
$string['outputformat_hp_6_jmix_xml_v6'] = 'Xml నుండి JMix (v6)';
$string['outputformat_hp_6_jmix_xml_v6_plus'] = 'Xml నుండి JMix (v6 +)';
$string['outputformat_hp_6_jmix_xml_v6_plus_deluxe'] = 'Xml నుండి JMix (ఉపసర్గతో ఉపసర్గ, ప్రత్యయంతో V6 +)';
$string['outputformat_hp_6_jmix_xml_v6_plus_keypress'] = 'Xml నుండి JMix (కీ ప్రెస్ తో v6 +)';
$string['outputformat_hp_6_jquiz_html'] = 'Html నుండి JQuiz (v6)';
$string['outputformat_hp_6_jquiz_xml_v6'] = 'Xml నుండి JQuiz (v6)';
$string['outputformat_hp_6_jquiz_xml_v6_autoadvance'] = 'Xml (ఆటో-అడ్వాన్స్) నుండి JQuiz (v6)';
$string['outputformat_hp_6_jquiz_xml_v6_exam'] = 'Xml (పరీక్షా) నుండి JQuiz (v6)';
$string['outputformat_hp_6_rhubarb_html'] = 'Html నుండి రబర్బ్ (v6)';
$string['outputformat_hp_6_rhubarb_xml'] = 'Xml నుండి రబర్బ్ (v6)';
$string['outputformat_hp_6_sequitur_html'] = 'Html నుండి సీక్విటర్ (v6)';
$string['outputformat_hp_6_sequitur_html_incremental'] = 'Html, పెరుగుతున్న స్కోరింగ్ నుండి సీక్విటూర్ (v6)';
$string['outputformat_hp_6_sequitur_xml'] = 'Xml నుండి సీక్విటర్ (v6)';
$string['outputformat_hp_6_sequitur_xml_incremental'] = 'Xml నుండి పెరుగుదల స్కోర్ (v6)';
$string['outputformat_html_ispring'] = 'HTML ఫైల్ iSpring';
$string['outputformat_html_xerte'] = 'Xerte HTML ఫైల్';
$string['outputformat_html_xhtml'] = 'ప్రామాణిక HTML ఫైల్.';
$string['outputformat_qedoc'] = 'Qedoc ఫైలు';
$string['overviewreport'] = 'ఓవర్వ్యూ.';
$string['penalties'] = 'జరిమానాలు.';
$string['percent'] = 'శాతం';
$string['pluginadministration'] = 'హాట్పోట్ పరిపాలన';
$string['pluginname'] = 'హాట్పోట్ మాడ్యూల్';
$string['pressoktocontinue'] = 'కొనసాగించడానికి సరే నొక్కండి లేదా ప్రస్తుత పేజీలో ఉండడానికి రద్దు చేయండి.';
$string['questionshort'] = 'Q - {$a}';
$string['quizname_help'] = 'క్విజ్ పేరు కోసం టెక్స్ట్ సహాయం';
$string['quizzes'] = 'క్విజెస్';
$string['responses'] = 'స్పందనలు';
$string['responsesreport'] = 'స్పందనలు.';
$string['reviewafterattempt'] = 'ప్రయత్నం తర్వాత సమీక్షను అనుమతించండి';
$string['reviewafterclose'] = 'HotPot మూసివేసిన తర్వాత సమీక్షను అనుమతించండి';
$string['reviewduringattempt'] = 'ప్రయత్నంలో సమీక్షను అనుమతించండి';
$string['reviewoptions'] = 'సమీక్ష ఎంపికలు';
$string['score'] = 'స్కోరు.';
$string['scoresreport'] = 'స్కోర్స్';
$string['selectattempts'] = 'ప్రయత్నాలను ఎంచుకోండి.';
$string['showerrormessage'] = 'హాట్పాట్ లోపం: {$a}';
$string['sourcefile'] = 'మూల ఫైల్';
$string['sourcefile_help'] = 'ఈ సెట్టింగ్ విద్యార్థులకు చూపించే కంటెంట్ను కలిగి ఉన్న ఫైల్ను నిర్దేశిస్తుంది.

సాధారణంగా మూలం ఫైల్ Moodle కు వెలుపల సృష్టించబడుతుంది మరియు తర్వాత ఒక Moodle కోర్సు యొక్క ఫైల్స్ ఏరియాకి అప్లోడ్ చేయబడుతుంది.
ఇది ఒక html ఫైల్ కావచ్చు, లేదా ఇది మరొక రకమైన ఫైల్ కావచ్చు, ఇది హాట్ బంగాళాదుంపలు లేదా Qedoc వంటి రచన సాఫ్ట్వేర్తో సృష్టించబడింది.

మూల ఫైల్ను Moodle కోర్స్ ఫైల్స్ ఏరియాలో ఫోల్డర్ మరియు ఫైల్ పాడ్ గా పేర్కొనవచ్చు లేదా ఇది http: // లేదా https: // తో ప్రారంభమయ్యే url కావచ్చు.

Qedoc పదార్థాలకు, Qedoc సర్వర్కు అప్లోడ్ చేయబడిన Qedoc మాడ్యూల్ యొక్క మూలం ఫైల్ తప్పనిసరిగా ఉండాలి.

* ఉదా. http://www.qedoc.net/library/ABCDE_123.zip
* Qedoc మాడ్యూళ్ళను అప్లోడ్ చేయడంపై సమాచారం కొరకు: [Qedoc డాక్యుమెంటేషన్: Uploading_modules] (http://www.qedoc.org/en/index.php?title=Uploading_modules)';
$string['sourcefilenotfound'] = 'మూల ఫైల్ కనుగొనబడలేదు (లేదా ఖాళీగా ఉంది): {$a}';
$string['status'] = 'హోదాను.';
$string['stopbutton'] = 'నిలిపివేసే బటన్ను చూపించండి.';
$string['stopbutton_help'] = 'ఈ సెట్టింగ్ ప్రారంభించబడితే, క్విజ్లో స్టాప్ బటన్ చొప్పించబడుతుంది.

ఒక విద్యార్థి స్టాప్ బటన్ను క్లిక్ చేస్తే, ఫలితాలు ఇప్పటివరకు మూడ్లెకు తిరిగి ఇవ్వబడతాయి మరియు క్విజ్ ప్రయత్నం యొక్క స్థితి రద్దు చేయబడుతుంది.

స్టాప్ బటలో ప్రదర్శించబడే టెక్స్ట్ మూడ్లె భాషల సమూహాల నుండి ముందుగానే ఉన్న పదబంధాల్లో ఒకటి కావచ్చు లేదా గురువు బటన్ కోసం వారి స్వంత వచనాన్ని పేర్కొనవచ్చు.';
$string['stopbutton_langpack'] = 'భాష ప్యాక్ నుండి.';
$string['stopbutton_specific'] = 'ప్రత్యేకమైన వచనం ఉపయోగించండి.';
$string['stoptext'] = 'బటన్ టెక్స్ట్ ను ఆపివేయి.';
$string['storedetails'] = 'HotPot క్విజ్ ప్రయత్నాల యొక్క ముడి XML వివరాలను నిల్వ చేయండి';
$string['studentfeedback'] = 'స్టూడెంట్ ఫీడ్ బ్యాక్';
$string['studentfeedback_help'] = 'ప్రారంభించినట్లయితే, "చెక్" బటన్పై విద్యార్థి క్లిక్ చేసినప్పుడు పాప్-అప్ ఫీడ్బ్యాక్ విండోకి లింక్ ప్రదర్శించబడుతుంది. ఫీడ్బ్యాక్ విండో విద్యార్థులను ఈ క్విజ్ను వారి ఉపాధ్యాయునితో మరియు సహవిద్యార్థులతో క్రింది మార్గాలలో ఒకటిగా చర్చించడానికి అనుమతిస్తుంది:

** వెబ్ పేజి **
: వెబ్ పేజీ యొక్క URL అవసరం, ఉదాహరణకు http://myserver.com/feedbackform.html

**అభిప్రాయమును తెలియ చేయు ఫారము**
: రూపం స్క్రిప్ట్ యొక్క URL అవసరం, ఉదాహరణకు http://myserver.com/cgi-bin/formmail.pl

** మూడ్లె ఫోరమ్ **
: కోర్సు కోసం ఫోరమ్ ఇండెక్స్ ప్రదర్శించబడుతుంది

** మూడ్లె మెసేజింగ్ **
: Moodle తక్షణ సందేశ విండో ప్రదర్శించబడుతుంది. కోర్సు అనేక ఉపాధ్యాయులను కలిగి ఉంటే, సందేశ విండో కనిపించే ముందు విద్యార్ధిని ఎంచుకోమని ప్రాంప్ట్ చేయబడతారు';
$string['submits'] = 'సమర్పణలను';
$string['subplugintype_hotpotattempt'] = 'ఉత్పత్తి ఆకృతి.';
$string['subplugintype_hotpotattempt_plural'] = 'అవుట్పుట్ ఫార్మాట్లు';
$string['subplugintype_hotpotreport'] = 'నివేదించండి.';
$string['subplugintype_hotpotreport_plural'] = 'నివేదికలు.';
$string['subplugintype_hotpotsource'] = 'మూలం ఫైల్.';
$string['subplugintype_hotpotsource_plural'] = 'మూలం ఫైళ్లు';
$string['textsourcefile'] = 'మూలం ఫైల్ నుండి పొందండి';
$string['textsourcefilename'] = 'మూలం ఫైల్ పేరును ఉపయోగించండి';
$string['textsourcefilepath'] = 'మూలం ఫైల్ మార్గాన్ని ఉపయోగించండి';
$string['textsourcequiz'] = 'క్విజ్ నుండి పొందండి';
$string['textsourcespecific'] = 'ప్రత్యేకమైన వచనం.';
$string['timeclose'] = 'వరకు అందుబాటులో ఉంది';
$string['timedout'] = 'సమయం ముగిసింది.';
$string['timelimit'] = 'సమయం పరిమితి.';
$string['timelimit_help'] = 'ఈ సెట్టింగ్ ఒక్క ప్రయత్నం యొక్క గరిష్ట వ్యవధిని నిర్దేశిస్తుంది.

** మూలం / టెంప్లేట్ ఫైల్ లో సెట్టింగ్లను ఉపయోగించండి **
: ఈ అవుట్పుట్ ఫార్మాట్ కోసం మూలం ఫైల్ లేదా టెంప్లేట్ ఫైళ్ళ నుండి సమయ పరిమితి తీసుకోబడుతుంది

** నిర్దిష్ట సమయం ఉపయోగించండి **
: HotPot క్విజ్ సెట్టింగ్ల పేజీలో పేర్కొన్న సమయ పరిమితి ఈ క్విజ్లో ప్రయత్నానికి సమయ పరిమితిగా ఉపయోగించబడుతుంది. మూలం ఫైల్, ఆకృతీకరణ ఫైలు లేదా ఈ అవుట్పుట్ ఫార్మాట్ కొరకు టెంప్లేట్ ఫైళ్ళలో ఈ పరిమితిని భర్తీ చేస్తుంది.

**డిసేబుల్**
: ఈ క్విజ్ వద్ద ప్రయత్నాలకు ఎటువంటి సమయ పరిమితి సెట్ చేయబడదు.

ఒక ప్రయత్నం పునఃప్రారంభమైతే, గతంలో తాళం వేసిన ప్రయత్నం నుండి టైమర్ కొనసాగుతుంది.';
$string['timelimitexpired'] = 'ఈ ప్రయత్నం గడువు ముగిసింది';
$string['timelimitspecific'] = 'ప్రత్యేకమైన సమయాన్ని ఉపయోగించండి.';
$string['timelimitsummary'] = 'ఒక ప్రయత్నం కొరకు సమయం పరిమితి.';
$string['timelimittemplate'] = 'సోర్స్ / టెంప్లేట్ ఫైల్ లో సెట్టింగ్లను ఉపయోగించండి';
$string['timeopen'] = 'అందుబాటులో నుండి.';
$string['timeopenclose'] = 'ఓపెన్ మరియు దగ్గరగా సార్లు';
$string['timeopenclose_help'] = 'ప్రజలు ప్రయత్నించడానికి క్విజ్ అందుబాటులో ఉన్నప్పుడు మీరు సార్లు పేర్కొనవచ్చు. ప్రారంభ సమయం ముందు, మరియు ముగింపు సమయం తర్వాత, క్విజ్ అందుబాటులో ఉండదు.';
$string['title'] = 'శీర్షిక.';
$string['title_help'] = 'ఈ అమరిక వెబ్ పుటలో ప్రదర్శించవలసిన శీర్షికను నిర్దేశిస్తుంది.

** హాట్పోట్ కార్యాచరణ పేరు **
: ఈ HotPot కార్యాచరణ పేరు వెబ్ పుట శీర్షికగా ప్రదర్శించబడుతుంది.

** మూలం ఫైల్ నుండి పొందండి **
: మూలం ఫైల్ లో పేర్కొనబడిన శీర్షిక ఏదైనా, వెబ్ పేజీ శీర్షికగా ఉపయోగించబడుతుంది.

** సోర్స్ ఫైల్ పేరును ఉపయోగించండి **
: ఫోల్డర్ పేర్లను మినహాయించి మూలం ఫైల్ పేరు వెబ్పేజీ శీర్షికగా ఉపయోగించబడుతుంది.

** సోర్స్ ఫైల్ పాత్ ఉపయోగించండి **
: ఫోల్డర్ పేర్లతో సహా మూలం ఫైల్ మార్గం వెబ్పేజీ శీర్షికగా ఉపయోగించబడుతుంది.';
$string['toolsindex'] = 'హాట్పాట్ టూల్స్ ఇండెక్స్';
$string['unitname_help'] = 'యూనిట్ పేరు కొరకు వచనం సహాయం';
$string['unrecognizedsourcefile'] = 'క్షమించండి, HotPot మాడ్యూల్ మూలం ఫైల్ యొక్క రకాన్ని గుర్తించలేకపోయింది: {$a}';
$string['updated'] = 'నవీకరించబడింది.';
$string['updatinggrades'] = 'హాట్పాట్ తరగతులు నవీకరిస్తోంది';
$string['usefilters'] = 'వడపోతలు ఉపయోగించండి.';
$string['usefilters_help'] = 'ఈ సెట్టింగ్ ప్రారంభించబడితే, బ్రౌజర్కు పంపబడే ముందు కంటెంట్ Moodle ఫిల్టర్ల ద్వారా పంపబడుతుంది.';
$string['useglossary'] = 'పదపట్టీని ఉపయోగించండి';
$string['useglossary_help'] = 'ఈ సెట్టింగ్ ప్రారంభించబడితే, బ్రౌజర్కు పంపబడేముందు కంటెంట్ మూడ్లె గ్లోసరీ ఆటో-లింక్ ఫిల్టర్ ద్వారా పంపబడుతుంది.

ఈ సెట్టింగ్ గ్లోసరీ ఆటో-లింక్ ఫిల్టర్ను ఎనేబుల్ చెయ్యడానికి లేదా నిలిపివేయడానికి సైట్ పరిపాలన సెట్టింగును భర్తీ చేస్తుందని గమనించండి.';
$string['usemediafilter'] = 'మీడియా ఫిల్టర్ ఉపయోగించండి';
$string['usemediafilter_help'] = 'ఈ అమరిక ఉపయోగించుటకు మీడియా ఫిల్టర్ నిర్దేశిస్తుంది.

** గమనిక **
: కంటెంట్ ఏ మీడియా ఫిల్టర్ ద్వారా పంపబడదు.

** మూడ్ల యొక్క ప్రామాణిక మీడియా ఫిల్టర్లు **
: కంటెంట్ మూడ్లె ప్రామాణిక మీడియా ఫిల్టర్ల ద్వారా పంపబడుతుంది. ఈ ఫిల్టర్లు సాధారణ రకాల ధ్వని మరియు మూవీ ఫైల్లకు లింక్ల కోసం శోధిస్తాయి మరియు తగిన మీడియా ప్లేయర్లకు ఆ లింక్లను మార్చండి.

** హాట్పోట్ మీడియా ఫిల్టర్ **
: కంటెంట్ చదరపు బ్రాకెట్ నోటిఫికేషన్ను ఉపయోగించి నిర్దేశించబడే లింక్లు, చిత్రాలు, శబ్దాలు మరియు సినిమాలను గుర్తించే ఫిల్టర్ల ద్వారా పంపబడుతుంది.

చదరపు-బ్రాకెట్ సంజ్ఞామానం క్రింది వాక్యనిర్మాణం కలిగి ఉంది:
<code> [url ప్లేయర్ వెడల్పు ఎత్తు ఎంపికలు] </ code>

** url **
: మీడియా ఫైల్ యొక్క సంబంధిత లేదా సంపూర్ణ url

** క్రీడాకారుడు ** (ఐచ్ఛిక)
: చొప్పించవలసిన ఆటగాడు పేరు. ఈ సెట్టింగు యొక్క అప్రమేయ విలువ "moodle". HotPot మాడ్యూల్ యొక్క ప్రామాణిక వెర్షన్ కూడా క్రింది ఆటగాళ్లను అందిస్తుంది:
: ** డ్యూ **: ఒక mp3 ప్లేయర్
: ** డైర్ **: బెర్నార్డ్ డయ్యర్ ద్వారా mp3 ప్లేయర్
: ** hbs **: హాఫ్-కాల్చిన సాఫ్ట్వేర్ నుండి mp3 ప్లేయర్
: ** బొమ్మ **: వెబ్ పుటలో చిత్రాన్ని చొప్పించండి
: ** లింక్ **: మరొక వెబ్ పేజీకి లింక్ని చొప్పించండి

** వెడల్పు ** (ఐచ్ఛికం)
: ఆటగాడు అవసరమైన వెడల్పు

** ఎత్తు ** (ఐచ్ఛికం)
: ఆటగాడు అవసరమైన ఎత్తు. విస్మరించినట్లయితే ఈ విలువ వెడల్పు అమరికకు సమానంగా అమర్చబడుతుంది.

** ఎంపికలు ** (ఐచ్ఛిక)
: ఆటగాడికి కామాతో వేరు చేయబడిన కామాతో వేరు చేయబడిన జాబితా ఎంపికలు. ప్రతి ఐచ్చికము సాధారణ స్విచ్ ఆన్ / ఆఫ్, లేదా ఒక పేరు విలువ జత కావచ్చు.
: ** పేరు = విలువ
: ** పేరు = "ఖాళీలతో కొన్ని విలువ"';
$string['viewreports'] = '{$a} వినియోగదారు (లు) కోసం నివేదికలను వీక్షించండి';
$string['views'] = 'అభిప్రాయాలను.';
$string['weighting'] = 'వైటింగ్';
$string['wrong'] = 'తప్పు';
$string['zeroduration'] = 'కాలపరిమితి లేదు.';
$string['zeroscore'] = 'జీరో స్కోరు.';
