<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'filter_poodll', language 'te', version '4.3'.
 *
 * @package     filter_poodll
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['REGION_APN1'] = 'ఆసియా పసిఫిక్ (టోక్యో)';
$string['REGION_APN2'] = 'ఆసియా పసిఫిక్ (సియోల్)';
$string['REGION_APS1'] = 'ఆసియా పసిఫిక్ (ముంబై)';
$string['REGION_APSE1'] = 'ఆసియా పసిఫిక్ (సింగపూర్)';
$string['REGION_APSE2'] = 'ఆసియా పసిఫిక్ (సిడ్నీ)';
$string['REGION_CAC1'] = 'కెనడా (సెంట్రల్)';
$string['REGION_EUC1'] = 'EU (ఫ్రాంక్ఫర్ట్)';
$string['REGION_EUW1'] = 'EU (ఐర్లాండ్)';
$string['REGION_EUW2'] = 'EU (లండన్)';
$string['REGION_SAE1'] = 'దక్షిణ అమెరికా (సావో పాలో)';
$string['REGION_USE1'] = 'US ఈస్ట్ (N. వర్జీనియా';
$string['REGION_USE2'] = 'యుఎస్ ఈస్ట్ (ఓహియో)';
$string['REGION_USW1'] = 'US వెస్ట్ (N. కాలిఫోర్నియా)';
$string['REGION_USW2'] = 'US వెస్ట్ (ఒరెగాన్)';
$string['activate'] = 'PoodLL సక్రియం చేయాలా?';
$string['alwayshtml5'] = 'ఎల్లప్పుడూ HTML5 ను ఉపయోగించండి';
$string['audiotranscode'] = 'ఆటో కన్వ. MP3 కు';
$string['audiotranscodedetails'] = 'మూడ్లెలో భద్రపరచడానికి ముందే రికార్డ్ చేయబడిన / అప్లోడ్ చేయబడిన ఆడియో ఫైల్ను MP3 ఫార్మాట్కు మార్చండి. ఇది టోకియో.poodll.com లో చేసిన రికార్డింగ్ల కోసం పనిచేస్తుంది లేదా FFMPEG ను ఉపయోగిస్తున్నట్లయితే రికార్డింగ్లను అప్లోడ్ చేస్తుంది';
$string['autotryports'] = 'తేడాను ప్రయత్నించండి. పోర్ట్సు కనెక్ట్ చేయలేకపోతే';
$string['awsregion'] = 'క్లౌడ్ ప్రాంతం (AWS)';
$string['awsregion_desc'] = 'ఉత్తమ పనితీరు కోసం మీ మూడ్ల సర్వర్కి సమీపంలోని ప్రాంతాన్ని ఎంచుకోండి మరియు మీకు వర్తించే ఏదైనా డేటా రక్షణ విధానాలు లేదా నిబంధనలను సంతృప్తిపరిచేందుకు.';
$string['bandwidth'] = 'విద్యార్థి కనెక్షన్. బైట్లు / రెండవ. వెబ్క్యామ్ నాణ్యతను ప్రభావితం చేస్తుంది.';
$string['bgtranscode_audio'] = 'MP3 నేపధ్యం సంభాషణలను జరుపుము';
$string['bgtranscode_video'] = 'MP4 నేపథ్యానికి సంభాషణలను నిర్వహించండి';
$string['bgtranscodedetails_audio'] = 'వినియోగదారుడు వేచి ఉన్నప్పుడు వాటిని ప్రదర్శిస్తూ కంటే ఎక్కువ నమ్మదగినది. కానీ క్రాన్ సేవ్ చేసిన తర్వాత వినియోగదారుడు వారి ఆడియోని పొందలేరు. మీరు FFMPEG మరియు Moodle ను 2.7 లేదా అంతకంటే ఎక్కువ ఉన్నట్లయితే మాత్రమే పనిచేస్తుంది. MP3 రికార్డర్తో MP3 లో రికార్డింగ్ కోసం, మార్పిడి సర్వర్లో కాదు, బ్రౌజర్లో జరుగుతుంది. సో సర్వర్ వైపు మార్పిడి (FFMPEG) ఉపయోగించబడదు.';
$string['bgtranscodedetails_video'] = 'వినియోగదారుడు వేచి ఉన్నప్పుడు వాటిని ప్రదర్శిస్తూ కంటే ఎక్కువ నమ్మదగినది. కానీ క్రాన్ సేవ్ చేసిన తర్వాత వినియోగదారుడు వారి వీడియోను పొందలేరు. మీరు FFMPEG మరియు Moodle ను 2.7 లేదా అంతకంటే ఎక్కువ ఉన్నట్లయితే మాత్రమే పనిచేస్తుంది.';
$string['bmr_recorder'] = 'బర్న్ట్ రోజ్';
$string['bundle'] = 'కట్ట';
$string['burntrose_recorder'] = 'బర్ంట్ రోజ్ (పాత)';
$string['cameraback'] = 'తిరిగి';
$string['camerafront'] = 'ముందు';
$string['cancel'] = 'రద్దు';
$string['capturefps'] = 'వీడియో రికార్డర్ క్యాప్చర్ FPS';
$string['captureheight'] = 'వీడియో రికార్డర్ క్యాప్చర్ ఎత్తు';
$string['capturewidth'] = 'వీడియో రికార్డర్ క్యాప్చర్ సైజు';
$string['cleartemplate'] = 'టెంప్లేట్ను క్లియర్ చేయండి';
$string['dataset'] = 'డేటాసెట్';
$string['dataset_desc'] = 'మీ టెంప్లేట్ లో ఉపయోగం కోసం డేటాబేస్ నుండి డేటాసెట్ను తీసివేయడానికి Poodll మిమ్మల్ని అనుమతిస్తుంది. ఇది అధునాతన లక్షణం. ఇక్కడ ఒక $ DB-> get_records_sql కాల్ యొక్క sql భాగాన్ని నమోదు చేయండి.';
$string['datasetvars'] = 'డేటాసెట్ వేరియబుల్స్';
$string['datasetvars_desc'] = 'SQL కోసం వర్ణాలు తయారు చేసే వేరియబుల్స్ యొక్క కామాతో వేరుచేయబడిన జాబితాను ఉంచండి. మీరు మరియు బహుశా ఇక్కడ వేరియబుల్స్ ఉపయోగించాలనుకుంటున్నాను.';
$string['debug_enable'] = 'డీబగ్గింగ్ను ప్రారంభించండి';
$string['debug_enable_details'] = 'ప్రారంభించబడితే, రికార్డింగ్ల గురించి సమాచారం Moodle లాగ్లలో నిల్వ చేయబడుతుంది. ఇవి Poodll helpdesk నుండి సమస్యా పరిష్కారం మరియు సహకారంలో సహాయం చేయడానికి ఉద్దేశించబడ్డాయి. అవసరం లేనప్పుడు ఆపివేయండి లేదా మీ Moodle లాగ్లో మీరు పనికిరాని వ్యర్థాన్ని కలిగి ఉంటారు.';
$string['debug_heading'] = 'Poodll డీబగ్గింగ్';
$string['default_camera'] = 'డిఫాల్ట్ కెమెరా';
$string['defaultwhiteboard'] = 'డిఫాల్ట్ వైట్బోర్డ్';
$string['event_adhoc_completed'] = 'పడెల్ అడ్హోక్ పని పూర్తి అయ్యింది';
$string['event_adhoc_convert_completed'] = 'Poodll Adhoc పనిని మార్చడానికి పూర్తయింది';
$string['event_adhoc_convert_registered'] = 'Poodll Adhoc పనిని మార్చడానికి మార్చండి';
$string['event_adhoc_move_completed'] = 'పడెల్ అడ్హోక్ కదలిక పూర్తయింది';
$string['event_adhoc_move_registered'] = 'Poodll Adhoc తరలింపు పని నమోదు';
$string['event_adhoc_registered'] = 'Poodll Adhoc పని నమోదు చేయబడింది';
$string['event_debug_log'] = 'పడెల్ డీబగ్ నోట్';
$string['expired'] = 'రిజిస్ట్రేషన్ గడువు ముగిసినందున PoodLL ప్రదర్శించబడలేదు. PoodLL.com వద్ద నమోదును పునరుద్ధరించడానికి మీ గురువు / నిర్వాహకుడిని అడగండి.';
$string['exportdiagnostics'] = 'ఎగుమతి';
$string['extensions'] = 'ఫైల్ పొడిగింపులు';
$string['extensions_desc'] = 'ఈ ఫిల్టర్ అన్వయించగల ఫైల్ పొడిగింపుల యొక్క CSV (కామాతో వేరు చేయబడిన విలువ) జాబితా.';
$string['extensionsettings'] = 'ఫైల్ పొడిగింపు సెట్టింగ్లు';
$string['ffmpeg'] = 'అప్లోడ్ చేసిన మీడియాను FFMPEG తో మార్చండి';
$string['ffmpeg_details'] = 'FFMPEG మీ Moodle సర్వర్లో మరియు సిస్టమ్ మార్గంలో ఇన్స్టాల్ చేయాలి. ఇది mp3 కు మార్చడానికి మద్దతు ఇవ్వాలి, కాబట్టి కమాండ్ లైన్లో మొదటిదాన్ని ప్రయత్నించండి, ఉదా. Ffmpeg -i somefile.flv somefile.mp3';
$string['filter_poodll_audioplayer_heading'] = 'ఆడియో ప్లేయర్ సెట్టింగులు';
$string['filter_poodll_camera_heading'] = 'వెబ్ కెమెరా సెట్టింగులు';
$string['filter_poodll_flashcards_heading'] = 'Flashcards సెట్టింగులు';
$string['filter_poodll_html5recorder_heading'] = 'HTML5 రికార్డర్ సెట్టింగులు';
$string['filter_poodll_mic_heading'] = 'మైక్రోఫోన్ సెట్టింగులు';
$string['filter_poodll_mp3recorder_heading'] = 'MP3 రికార్డర్ సెట్టింగులు';
$string['filter_poodll_network_heading'] = 'PoodLL నెట్వర్క్ సెట్టింగ్లు';
$string['filter_poodll_registration_explanation'] = 'PoodLL 3 కి రిజిస్ట్రేషన్ కీ అవసరం. ఒకదాన్ని పొందడానికి మీకు Poodll.com ను సందర్శించనట్లయితే.';
$string['filter_poodll_registration_heading'] = 'మీ PoodLL ను నమోదు చేయండి';
$string['filter_poodll_videogallery_heading'] = 'వీడియో గ్యాలరీ సెట్టింగులు';
$string['filter_poodll_videoplayer_heading'] = 'వీడియో ప్లేయర్ సెట్టింగులు';
$string['filter_poodll_whiteboard_heading'] = 'వైట్బోర్డ్ సెట్టింగులు';
$string['filtername'] = 'PoodLL ఫిల్టర్';
$string['flashcardstype'] = 'Flashcards రకం';
$string['flashonandroid'] = 'Android లో ఫ్లాష్ ఉపయోగించండి';
$string['flashonandroid_desc'] = 'Android లో Flash ను ఉపయోగించడం సాధ్యమవుతుంది, అయినప్పటికీ అనేక సందర్భాల్లో, విద్యార్థులకు ఏమి చేయాలనేది కచ్చితంగా అందుబాటులో ఉండదు. కాబట్టి అప్రమేయంగా ఇది ఆఫ్ అవుతుంది.';
$string['fluencybuilder_recorder'] = 'స్వచ్చత బిల్డర్';
$string['generalsettings'] = 'సాధారణ సెట్టింగులు';
$string['gold_recorder'] = 'సింగిల్ బటన్ (బీటా)';
$string['handle'] = '{$a} నిర్వహించు';
$string['have_recent_event'] = 'ఇటీవల తొలగించిన తరలింపు పూర్తి చేసిన సంఘటనను కనుగొన్నారు: {$a}';
$string['have_task'] = 'ఒక వేచి తరలింపు / కోసం పని మార్చేందుకు: {$a}';
$string['highquality'] = 'అధిక';
$string['html5ondsafari'] = 'డెస్క్టాప్ Safari లో ఉపయోగించండి';
$string['html5ondsafaridetails'] = 'డెస్క్టాప్ సఫారి సరైన ఆడియో పరికరాన్ని ఎంచుకోకపోవచ్చు మరియు వేరొకదాన్ని ఎంచుకోవడానికి ఎంపిక లేదు. చాలా సందర్భాలలో దాని సరే, కానీ Mac మినీలో ఇది ఒక పని ఆడియో పరికరాన్ని గుర్తించలేదు.';
$string['html5recorder_skin_audio'] = 'HTML5 రికార్డర్ స్కిన్ (ఆడియో)';
$string['html5recorder_skin_video'] = 'HTML5 రికార్డర్ స్కిన్ (వీడియో)';
$string['insert'] = 'చొప్పించు';
$string['jumpcat_explanation'] = 'పూర్తి సెట్ Poodll ఫిల్టర్ సెట్టింగులను <a href="{$a}"> ఇక్కడ </a> చూడవచ్చు.';
$string['jumpcat_heading'] = 'Poodll ఫిల్టర్ సెట్టింగ్లు';
$string['license_details'] = '<br> -------------- <br> లైసెన్స్ రకం: {$ a-> license_type} <br> గడువు (JST): {$ a-> expire_date} <br> నమోదైన URL : {$ a-> registered_url}';
$string['lowquality'] = 'తక్కువ';
$string['mediumquality'] = 'మీడియం';
$string['miccanpause'] = 'విరామం అనుమతించు (MP3 రికార్డర్ మాత్రమే)';
$string['micecho'] = 'సమయపు. ఎకో';
$string['micgain'] = 'సమయపు. పెరుగుట';
$string['micloopback'] = 'సమయపు. లూప్ బాక్';
$string['micrate'] = 'సమయపు. రేటు';
$string['micsilencelevel'] = 'సమయపు. సైలెన్స్ స్థాయి';
$string['mobile_audio_quality'] = 'ఆడియో నాణ్యత';
$string['mobile_os_version_warning'] = '<p> మీ OS సంస్కరణ చాలా తక్కువగా ఉంది </ p>
<p> Android కు వెర్షన్ 4 లేదా అంతకంటే ఎక్కువ అవసరం. </ p>
<p> iOS సంస్కరణ 6 లేదా అంతకంటే ఎక్కువ అవసరం. </ p>';
$string['mobile_show'] = 'మొబైల్ చూపించు';
$string['mobile_show_desc'] = 'యూజర్ ఒక iOS పరికరంలో ఉన్నప్పుడు, రికార్డర్కు బదులుగా వారు "అప్లోడ్ / రికార్డ్" బటన్ మరియు "ఉపయోగం PoodLL అనువర్తనం" బటన్ను చూపుతారు. PoodLL అనువర్తన బటన్ను దాచడానికి దీన్ని అన్చెక్ చేయండి.';
$string['mobile_video_quality'] = 'వీడియో నాణ్యత';
$string['mobileandwebkit'] = 'మొబైల్ + వెబ్కిట్ బ్రౌజర్లు (సఫారి, క్రోమ్ మొదలైనవి)';
$string['mobileonly'] = 'మొబైల్ పరికరాలు మాత్రమే';
$string['mobilesettings'] = 'iOS అనువర్తనం సెట్టింగ్లు';
$string['mp3_nocloud'] = 'మేఘం లేదు';
$string['mp3_nocloud_details'] = 'ట్రాన్స్కోడ్ మరియు కాపీబ్యాక్ కోసం ఫ్లాష్ mp3 రికార్డింగ్లు క్లౌడ్కు సమర్పించవద్దు.';
$string['mp3opts'] = 'ఫ్లాష్ MP3 రికార్డింగ్లను ట్రాన్స్కోడ్ కోసం ఒక క్లౌడ్కు పంపకండి.';
$string['mp3opts_details'] = 'FFMPEG నిర్ణయాలు తీసుకునేలా మీరు ఈ ఖాళీని వదిలేయండి. మీరు ఇక్కడ ఉంచిన ఏదైనా [ffmpeg -i myfile.xx] మరియు [myfile.mp3]';
$string['mp3skin'] = 'MP3 స్కిన్';
$string['mp3skin_details'] = 'మీరు రికార్డర్ చర్మాన్ని ఉపయోగించాలనుకుంటే, అలియా థీమ్, ఇక్కడ దాని పేరు నమోదు చేయండి. లేకపోతే ఎంటర్: none.';
$string['mp4opts'] = 'FFMPEG MP4 కన్వర్షన్ ఎంపికలు';
$string['mp4opts_details'] = 'FFMPEG నిర్ణయాలు తీసుకునేలా మీరు ఈ ఖాళీని వదిలేయండి. ఇక్కడ మీరు చాలు ఏదైనా [ffmpeg -i myfile.xx] మరియు [myfile.mp4]';
$string['neverhtml5'] = 'HTML5 ను ఎప్పుడూ ఉపయోగించవద్దు';
$string['no_event_or_task'] = 'వేచి ఉన్న కదలిక పనికి ఏదీ కనుగొనలేదు, లేదా కదలిక-పూర్తి చేసిన సంఘటన: {$a}';
$string['normal'] = 'సాధారణ';
$string['onetwothree_recorder'] = 'ఒకటి రెండు మూడు';
$string['picqual'] = 'టార్గెట్ వెబ్క్యామ్ క్వాలిస్. 1 - 10';
$string['plain_recorder'] = 'సాదా';
$string['player'] = 'క్రీడాకారుడు {$ a}';
$string['playertype'] = 'క్రీడాకారుడు';
$string['pluginname'] = 'PoodLL ఫిల్టర్';
$string['poodll:candownloadmedia'] = 'మీడియాను డౌన్లోడ్ చేయవచ్చు';
$string['poodll:use'] = 'PoodLL ఫిల్టర్ను ఉపయోగించవచ్చు';
$string['poodllsupportinfo'] = 'PoodLL మద్దతు సమాచారం';
$string['poodlltemplatesadmin'] = 'పడెల్ వడపోత టెంప్లేట్లు అడ్మిన్';
$string['presets'] = 'ప్రీసెట్తో స్వీయ పూరింపు టెంప్లేట్';
$string['presets_desc'] = 'PoodLL మీకు డిఫాల్ట్ ప్రీసెట్లు వస్తుంది, మీరు బాక్స్ నుంచి బయటకు వెళ్లవచ్చు లేదా మీ సొంత టెంప్లేట్తో ప్రారంభించడంలో మీకు సహాయపడుతుంది. ఇక్కడ ఉన్నవారిలో ఒకదానిని ఎంచుకోండి లేదా స్క్రాచ్ నుండి మీ సొంత టెంప్లేట్ను సృష్టించండి. ఎగువన ఆకుపచ్చ పెట్టెపై క్లిక్ చేయడం ద్వారా మీరు ఒక బండిల్గా టెంప్లేట్ను ఎగుమతి చేయవచ్చు. ఆకుపచ్చ పెట్టెలో లాగడం ద్వారా మీరు ఒక కట్టను దిగుమతి చేసుకోవచ్చు.';
$string['privacy:metadata'] = 'Poodll వడపోత ప్లగిన్ ఏదైనా వ్యక్తిగత డేటాను నిల్వ చేయదు.';
$string['readaloud_recorder'] = 'గట్టిగ చదువుము';
$string['recorderorder'] = 'ఇష్టపడే రికార్డర్ ఆర్డర్';
$string['recorderorder_audio'] = 'ఆడియో రికార్డర్ ఆర్డర్';
$string['recorderorder_desc'] = 'PoodLL యూజర్ బ్రౌజర్ మరియు ప్లాట్ఫారమ్కు మద్దతు ఇస్తే అది ఉత్తమ రికార్డర్ని ఎన్నుకుంటుంది. మీరు ఆర్డర్ను ఇక్కడ సెట్ చేయండి.';
$string['recorderorder_snapshot'] = 'స్నాప్ షాట్ రికార్డర్ ఆర్డర్';
$string['recorderorder_video'] = 'వీడియో రికార్డర్ ఆర్డర్';
$string['recorderorder_whiteboard'] = 'వైట్బోర్డ్ రికార్డర్ ఆర్డర్';
$string['recorderorder_whiteboard_desc'] = '(ఈ సెట్టింగ్ ప్రస్తుతం ఉపయోగించబడదు మరియు త్వరలో Poodll నుండి తీసివేయబడవచ్చు)';
$string['recui_audiogain'] = 'ఆడియో లాభం';
$string['recui_audiorate'] = 'ఆడియో రేట్';
$string['recui_awaitingconfirmation'] = 'నిర్ధారణ కొఱకు వేచిచూస్తూ';
$string['recui_awaitingconversion'] = 'మార్పిడి కోసం వేచి ఉంది';
$string['recui_btnupload'] = 'రికార్డ్ చేయండి లేదా ఫైల్ను ఎంచుకోండి';
$string['recui_cancelsnapshot'] = 'రద్దు';
$string['recui_close'] = 'Close';
$string['recui_continue'] = 'కొనసాగించు';
$string['recui_converting'] = 'మార్చటం';
$string['recui_echo'] = 'ఎకో అణచివేత';
$string['recui_finished'] = 'పూర్తయ్యింది';
$string['recui_inaudibleerror'] = 'మేము మీకు వినలేము. దయచేసి ఫ్లాష్ మరియు బ్రౌజర్ అనుమతులను తనిఖీ చేయండి.';
$string['recui_loopback'] = 'లూప్ బాక్';
$string['recui_nothingtosaveerror'] = 'ఏమీ బంధించలేదు. క్షమించండి .. అప్లోడ్ చేయడానికి ఏమీ లేదు.';
$string['recui_off'] = 'ఆఫ్';
$string['recui_ok'] = 'అలాగే';
$string['recui_on'] = 'పై';
$string['recui_openrecorderapp'] = 'PoodLL అనువర్తనం';
$string['recui_pause'] = 'పాజ్';
$string['recui_play'] = 'ప్లే';
$string['recui_playing'] = 'సాధన:';
$string['recui_ready'] = 'రెడీ';
$string['recui_record'] = 'రికార్డు';
$string['recui_recording'] = 'రికార్డింగ్:';
$string['recui_recordorchoose'] = 'రికార్డ్ చేయండి లేదా ఎంచుకోండి';
$string['recui_restart'] = 'పునఃప్రారంభించు';
$string['recui_save'] = 'అప్లోడ్';
$string['recui_silencelevel'] = 'సైలెన్స్ స్థాయి';
$string['recui_stop'] = 'ఆపు';
$string['recui_takesnapshot'] = 'చిత్రం తీసుకోండి';
$string['recui_time'] = 'సమయం:';
$string['recui_timeouterror'] = 'అభ్యర్థన సమయం ముగిసింది. క్షమించాలి.';
$string['recui_uploadafile'] = 'ఫైల్ను అప్లోడ్ చేయండి';
$string['recui_uploaderror'] = 'లోపం సంభవించింది మరియు మీ ఫైల్ ఎక్కించబడలేదు.';
$string['recui_uploading'] = 'అప్లోడ్';
$string['recui_uploadsuccess'] = 'విజయవంతంగా అప్లోడ్ చేయబడింది';
$string['registrationkey'] = 'నమోదు కీ';
$string['registrationkey_explanation'] = 'ఇక్కడ మీ PoodLL నమోదు కీని నమోదు చేయండి. మీరు <a href=\'https://poodll.com/pricing\'> https://poodll.com/pricing </a> నుండి ఒక కీని పొందవచ్చు';
$string['serverhttpport'] = 'PoodLL సర్వర్ పోర్ట్ (HTTP)';
$string['serverid'] = 'PoodLL సర్వర్ ఐడి';
$string['servername'] = 'PoodLL హోస్ట్ చిరునామా';
$string['serverport'] = 'PoodLL సర్వర్ పోర్ట్ (RTMP)';
$string['settings'] = 'PoodLL ఫిల్టర్ సెట్టింగ్లు';
$string['shadow_recorder'] = 'నీడ';
$string['showdownloadicon'] = 'ఆటగాళ్ల క్రింద డౌన్లోడ్ బటన్ను చూపించు';
$string['showdownloadicon_desc'] = 'ఇది కొన్ని ఆటగాళ్లలో అమలు చేయబడుతుంది. స్థానిక క్రీడాకారులు, mediaelement క్రీడాకారులు, audiojs_shim, flowplayer మొదటి ఫ్రేమ్ మరియు వీడియో JS';
$string['sitedefault'] = 'సైట్ డిఫాల్ట్';
$string['size'] = 'పరిమాణం';
$string['skinstyleaudio'] = 'స్కిన్ శైలి (ఆడియో)';
$string['skinstyleaudio_details'] = 'రికార్డర్ రూపాన్ని అనుకూలపరచడంలో సహాయం చేయడానికి ఆడియో రికార్డర్కు జోడించబడే CSS తరగతి పేరు.';
$string['skinstylevideo'] = 'స్కిన్ శైలి (వీడియో)';
$string['skinstylevideo_details'] = 'రికార్డర్ రూపాన్ని అనుకూలపరచడంలో సహాయపడటానికి వీడియో రికార్డర్కు జోడించబడే CSS తరగతి పేరు.';
$string['split_recorder'] = 'స్ప్లిట్';
$string['studentcam'] = 'కెమెరా కోసం ఇష్టపడే పరికరం పేరు';
$string['studentmic'] = 'మైక్రోఫోన్ కోసం ప్రాధాన్య పరికరం పేరు';
$string['supportinfo'] = 'మద్దతు సమాచారం';
$string['template'] = 'టెంప్లేట్ యొక్క శరీరం {$a}';
$string['template_desc'] = 'ఈ టెంప్లేట్ను ఇక్కడ ఉంచండి, వాటిలో వేరియబుల్స్ను నిర్వచించండి. గాని వద్ద @ @ మార్కులు. ఉదా @@ వేరియబుల్ @';
$string['template_showatto'] = 'Atto లో చూపించు (టెంప్లేట్ {$a})';
$string['template_showatto_desc'] = 'Atto కోసం PoodLL విడ్జెట్లు డైలాగ్లో ఈ విడ్జెట్ కోసం ఒక బటన్ మరియు రూపం ప్రదర్శించు.';
$string['template_showplayers'] = 'ఆటగాళ్ల జాబితాలో చూపించు (టెంప్లేట్ {$a})';
$string['template_showplayers_desc'] = 'ఫైల్ పొడిగింపుతో అనుబంధించబడిన అందుబాటులో ఉన్న ఆటగాళ్ల డ్రాప్డౌన్ జాబితాలో ప్రదర్శించండి.';
$string['templatealternate'] = 'ప్రత్యామ్నాయ కంటెంట్ (టెంప్లేట్ {$ a})';
$string['templatealternate_desc'] = 'అనుకూల CSS మరియు జావాస్క్రిప్ట్ కంటెంట్ అందుబాటులో లేనప్పుడు ఉపయోగించగల కంటెంట్. వెబ్బ్రేషన్ ద్వారా టెంప్లేట్ ప్రాసెస్ చేయబడినప్పుడు ప్రస్తుతం ఇది ఉపయోగించబడుతుంది, బహుశా మొబైల్ అనువర్తనంలోని కంటెంట్ కోసం';
$string['templatealternate_end'] = 'ప్రత్యామ్నాయ కంటెంట్ ముగింపు (టెంప్లేట్ {$a})';
$string['templatealternate_end_desc'] = 'ప్రారంభం మరియు ముగింపు PoodLL ట్యాగ్లతో వినియోగదారు కంటెంట్ని జతచేసే టెంప్లేట్ల ప్రత్యామ్నాయ కంటెంట్ ట్యాగ్లను మూసివేయడం';
$string['templatecount'] = 'మూస కౌంట్';
$string['templatecount_desc'] = 'మీరు కలిగి ఉన్న టెంప్లేట్ల సంఖ్య. డిఫాల్ట్ 20.';
$string['templatedefaults'] = 'వేరియబుల్ డిఫాల్ట్లు (టెంప్లేట్ {$ a})';
$string['templatedefaults_desc'] = 'పేరు = విలువ జత కామాతో వేరు చేయబడిన సెట్లలో డిఫాల్ట్లను నిర్వచించండి. ఉదా వెడల్పు = 800, ఎత్తు = 900, భావన = ఆనందం';
$string['templateend'] = 'ముగింపు ట్యాగ్లు (టెంప్లేట్ {$a})';
$string['templateend_desc'] = 'మీ టెంప్లేట్ వినియోగదారు కంటెంట్ను జతచేసినట్లయితే, ఉదా. ఒక సమాచార పెట్టె, ఇక్కడ ముగింపు ట్యాగ్లను ఉంచండి. ఫిల్టర్ను మూసివేయడానికి వినియోగదారు {POODLL: mytag_end} వంటి ఏదో ఎంటర్ చేస్తాడు.';
$string['templateheading'] = 'Poodll మూస {$a} కోసం సెట్టింగులు';
$string['templateheadingcss'] = 'CSS / శైలి సెట్టింగులు.';
$string['templateheadingjs'] = 'జావాస్క్రిప్ట్ సెట్టింగులు.';
$string['templateinstructions'] = 'సూచనలు (టెంప్లేట్ {$a})';
$string['templateinstructions_desc'] = 'ఈ టెంప్లేట్ ఇక్కడ చూపించటానికి అందుబాటులో ఉన్నట్లయితే, ఇక్కడ ఎంటర్ చేసిన ఏవైనా సూచనలు PoodLL రూపంలో ప్రదర్శించబడతాయి. వాటిని చిన్నగా ఉంచండి లేదా అది చెడుగా కనిపిస్తుంది.';
$string['templatekey'] = 'టెంప్లేట్ {$a} గుర్తిస్తుంది';
$string['templatekey_desc'] = 'కీ ఒక పదంగా ఉండాలి మరియు సంఖ్యలు మరియు అక్షరాలను, అండర్ స్కోర్, హైపన్లు మరియు చుక్కలను మాత్రమే కలిగి ఉండాలి';
$string['templatename'] = 'టెంప్లేట్ కోసం ప్రదర్శన పేరు {$a}';
$string['templatename_desc'] = 'పేరు కలిగి ఉండవచ్చు.సంఖ్యలు మరియు అక్షరాలు, అండర్స్కోర్స్, హైపన్లు మరియు చుక్కలు.';
$string['templatepageheading'] = '(T): {$a}';
$string['templatepageplayerheading'] = '(P): {$a}';
$string['templatepagewidgetheading'] = '(W): {$a}';
$string['templaterequire_amd'] = 'AMD ద్వారా లోడ్ చేయండి';
$string['templaterequire_amd_desc'] = 'AMD ఒక జావాస్క్రిప్ట్ లోడింగ్ మెకానిజం. మీరు మీ టెంప్లేట్ లో జావాస్క్రిప్ట్ లైబ్రరీలను అప్లోడ్ చేసి లేదా లింక్ చేస్తే, మీరు దాన్ని తొలగించవలసి ఉంటుంది. ఇది Moodle 2.9 లేదా అంతకంటే ఎక్కువ ఉంటే మాత్రమే వర్తిస్తుంది';
$string['templaterequire_css'] = 'CSS అవసరం (టెంప్లేట్ {$a})';
$string['templaterequire_css_desc'] = 'ఈ టెంప్లేట్ బాహ్య CSS ఫైల్కు లింక్ (1 మాత్రమే) ఉంది. ఐచ్ఛిక.';
$string['templaterequire_jquery'] = 'J క్వెరీ అవసరం (టెంప్లేట్ {$a})';
$string['templaterequire_jquery_desc'] = 'ఈ తనిఖీ చేయడం ఉత్తమం కాదు. అనేక AMD టెంప్లేట్లు j క్వెరీ అవసరం. ఇక్కడ తనిఖీ చేస్తోంది J క్వెరీ లోడ్, కానీ చాలా బాగా లేదు. మీ థీమ్ ఇప్పటికే ఏమైనప్పటికీ j క్వెరీ లోడ్ కావచ్చు. లేకపోతే, ఈ సైట్ను అడ్మినిస్ట్రేషన్ -> స్వరూపం -> అదనపు HTML (HEAD లోపు) జోడించండి: <br/> & lt; script src = "https://code.jquery.com/jquery-1.11.2.min.js "& gt; & lt; / లిపి & gt;';
$string['templaterequire_js'] = 'JS (టెంప్లేట్ {$a}) అవసరం';
$string['templaterequire_js_desc'] = 'ఈ టెంప్లేట్ అవసరం బాహ్య JS ఫైల్కు లింక్ (1 మాత్రమే). ఐచ్ఛిక.';
$string['templaterequire_js_shim'] = 'షిమ్ ఎగుమతి (టెంప్లేట్ {$a})';
$string['templaterequire_js_shim_desc'] = 'షిమ్ ఎగుమతుల విలువను నమోదు చేసి, మీకు షిమ్ అవసరం ఉంటే మాత్రమే.';
$string['templates'] = 'లు';
$string['templatescript'] = 'కస్టమ్ JS (టెంప్లేట్ {$a})';
$string['templatescript_desc'] = 'మీ టెంప్లేట్ కస్టమ్ జావాస్క్రిప్ట్ను అమలు చేయాల్సిన అవసరం ఉంటే, దాన్ని ఇక్కడ ఎంటర్ చెయ్యండి. పేజీలో అన్ని ఎలిమెంట్లను లోడ్ చేసిన తర్వాత ఇది అమలు అవుతుంది.';
$string['templatestyle'] = 'కస్టమ్ CSS (టెంప్లేట్ {$a})';
$string['templatestyle_desc'] = 'మీ టెంప్లేట్ ఇక్కడ ఉపయోగించే ఏదైనా అనుకూల CSS ను నమోదు చేయండి. మూస వేరియబుల్స్ ఇక్కడ పనిచేయవు. సాదా పాత CSS.';
$string['templateupdated'] = '{$a} Poodll టెంప్లేట్ నవీకరించబడింది.';
$string['templateversion'] = 'ఈ టెంప్లేట్ యొక్క సంస్కరణ {$a}';
$string['templateversion_desc'] = 'సెమాంటిక్ వెర్షన్ను ఉపయోగించండి ఉదా. 1.0.0. టెంప్లేట్ వెర్షన్ కంటే ముందుగానే అమర్చిన వెర్షన్ ఎక్కువ అయినప్పుడు Poodll నవీకరణ బటన్ను చూపుతుంది.';
$string['tiny'] = 'చిన్న';
$string['transcode_heading'] = 'ఆడియో / వీడియో ఫైల్ కన్వర్షన్ సెట్టింగులు';
$string['transcode_heading_desc'] = 'ఈ విభాగంలోని సెట్టింగులు FFMPEG మరియు Red5 కోసం ఉన్నాయి మరియు క్లౌడ్ రికార్డింగ్ ఉపయోగించినప్పుడు వర్తించవు.';
$string['type'] = 'రకం';
$string['unregistered'] = 'PoodLL అది నమోదు చేయబడనందున అది ప్రదర్శించబడలేదు. PoodLL.com వద్ద PoodLL ను నమోదు చేయడానికి మీ గురువు / నిర్వాహకుడిని అడగండి.';
$string['updateall'] = 'అన్నింటినీ నవీకరించండి.';
$string['updatetoversion'] = '{$a} కు నవీకరించండి';
$string['usecloudnotifications'] = 'మేఘ నోటిఫికేషన్లు';
$string['usecloudnotifications_desc'] = 'PoodLL క్లౌడ్ నోటిఫికేషన్లు. ఇది క్లౌడ్ ట్రాన్స్కోడింగ్ పూర్తయిన తక్షణ నోటిఫికేషన్ను అందిస్తుంది.';
$string['usecloudrecording'] = 'క్లౌడ్ రికార్డింగ్';
$string['usecloudrecording_desc'] = 'PoodLL క్లౌడ్ రికార్డింగ్. ఇది క్లౌడ్ లో ట్రాన్స్కోడింగ్ మరియు ఇతర సేవలను ప్రారంభిస్తుంది. PoodLL iOS అనువర్తనం దీనికి అవసరం, మరియు ఇది కూడా HTML5 ఆడియో మరియు వీడియో రికార్డర్లు చేయండి. రికార్డ్ చేసిన ఫైల్లు క్లౌడ్లో హోస్ట్ చేయబడలేదు.';
$string['useplayer'] = '{$a} ప్లేయర్';
$string['useplayerdesc'] = 'ఎంపిక చేసిన ఆటగాడు తగిన టెంప్లేట్ నుండి సమాచారాన్ని ఉపయోగిస్తాడు.';
$string['value'] = 'విలువ';
$string['videotranscode'] = 'ఆటో కన్వ. MP4 కు';
$string['videotranscodedetails'] = 'Moodle లో భద్రపరచడానికి ముందు రికార్డ్ / అప్లోడ్ చేయబడిన వీడియో ఫైళ్లను MP4 ఫార్మాట్కు మార్చండి. ఇది టోకియో.poodll.com లో చేసిన రికార్డింగ్ల కోసం పనిచేస్తుంది లేదా FFMPEG ను ఉపయోగిస్తున్నట్లయితే రికార్డింగ్లను అప్లోడ్ చేస్తుంది';
$string['wboardautosave'] = 'ఆటోసేవ్ (మిల్లీ సెకన్లు)';
$string['wboardautosave_details'] = 'X మిల్లీసెకన్లు తర్వాత యూజర్ డ్రాయింగ్ పాజ్ చేసినపుడు డ్రాయింగ్ను రక్షిస్తుంది. 0 = ఆటోసేవ్ లేదు';
$string['wboardheight'] = 'వైట్బోర్డ్ డిఫాల్ట్ ఎత్తు';
$string['wboardnozoom'] = 'జూమ్ను ఆపివేయి';
$string['wboardnozoom_details'] = 'మాత్రమే సాహిత్యంగాకన్వాస్ వర్తిస్తుంది. తనిఖీ చేస్తే గరిష్ట మరియు జూమ్ జూమ్ 1.0 కు, సమర్థవంతంగా జూమ్ లక్షణాన్ని నిలిపివేస్తుంది.';
$string['wboardwidth'] = 'వైట్బోర్డ్ డిఫాల్ట్ వెడల్పు';
$string['whiteboardsave'] = 'చిత్రాన్ని సేవ్ చేయండి';
$string['widgetsettings'] = 'విడ్జెట్ సెట్టింగులు';
$string['widgettype'] = 'విడ్జెట్';
