<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oidc', language 'te', version '4.3'.
 *
 * @package     auth_oidc
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_oidcdescription'] = 'OpenID Connect ప్లగ్ఇన్ కన్ఫిగర్ చేయదగిన గుర్తింపు ప్రొవైడర్లను ఉపయోగించే ఏకైక-సైన్-ఆన్ కార్యాచరణను అందిస్తుంది.';
$string['cfg_autoappend_desc'] = '"రిసోర్స్ ఓనర్ పాస్వర్డ్ క్రెడెన్షియల్స్" ధృవీకరణ పద్దతిని వుపయోగించి వినియోగదారులు లాగింగ్ చేసినప్పుడు ఈ స్ట్రింగ్ను స్వయంచాలకంగా చేర్చండి. మీ గుర్తింపు ప్రొవైడర్ ఒక సాధారణ డొమైన్ అవసరం అయినప్పుడు ఇది ఉపయోగకరంగా ఉంటుంది, కానీ లాగిన్ చేసేటప్పుడు దానిని టైప్ చేయడానికి వినియోగదారులని కోరుకోవడం లేదు. ఉదాహరణకు, పూర్తి OpenID Connect యూజర్ "james@example.com" అయితే మీరు "@ example.com "ఇక్కడ, వాడుకరిపేరు" జేమ్స్ "ను వారి వాడుకరిపేరులోకి ప్రవేశించవలసి ఉంటుంది. <br /> <b> గమనిక: </ b> వివాదాస్పద వాడుకరి పేర్లు ఉన్న సందర్భంలో - అనగా ఒక మూడ్ల వాడుకరి అదే పేరుతో ఉంది, ఏ యూజర్ గెలవాలని నిర్ణయించటానికి ప్రామాణీకరణ ప్లగ్ఇన్ యొక్క ప్రాధాన్యత ఉపయోగించబడుతుంది.';
$string['cfg_autoappend_key'] = 'ఆటో-చేర్చు';
$string['cfg_customicon_desc'] = 'మీరు మీ సొంత చిహ్నాన్ని ఉపయోగించాలనుకుంటే, దాన్ని ఇక్కడ అప్లోడ్ చేయండి. ఇది పైన ఎన్నుకున్న ఐచ్చికాన్ని ఓవర్రైడ్ చేస్తుంది. <br /> <b> కస్టమ్ బొమ్మలను ఉపయోగించడం గురించి గమనికలు: </ b> <ul> <li> ఈ చిత్రం <b> కాదు </ b>, లాగిన్ పేజీలో పునఃపరిమాణం చేయబడుతుంది, కాబట్టి మేము </ li> <li> మీరు కస్టమ్ ఐకాన్ను అప్లోడ్ చేసి, స్టాక్ చిహ్నాలలో ఒకదానికి తిరిగి వెళ్లాలనుకుంటే, ఎగువ పెట్టెలోని కస్టమ్ ఐకాన్ను క్లిక్ చేసి, ఆపై "తొలగించు" క్లిక్ చేసి, ఆపై క్లిక్ చేయండి. "OK", అప్పుడు ఈ ఫారమ్ దిగువన "మార్పులను సేవ్ చేయి" క్లిక్ చేయండి. ఎంచుకున్న స్టాక్ చిహ్నం ఇప్పుడు Moodle లాగిన్ పేజీలో కనిపిస్తుంది. </ Li> </ ul>';
$string['cfg_customicon_key'] = 'కస్టమ్ ఐకాన్';
$string['cfg_debugmode_desc'] = 'ప్రారంభించబడితే, సమస్యలను గుర్తించడంలో సహాయపడే Moodle లాగ్కు సమాచారం లాగ్ చెయ్యబడుతుంది.';
$string['cfg_debugmode_key'] = 'డీబగ్ సందేశాలను రికార్డ్ చేయండి';
$string['cfg_domainhint_desc'] = '"ఆథరైజేషన్ కోడ్" ధృవీకరణ పద్దతిని వాడుతున్నప్పుడు, ఈ విలువ "domain_hint" పరామితిగా ఉంటుంది. వినియోగదారులు కోసం లాగిన్ ప్రక్రియ సులభతరం చేయడానికి "డొమైన్_హింట్" కొన్ని OpenID Connect ప్రొవైడర్లచే ఉపయోగించబడుతుంది. ఈ పరామితికి వారు మద్దతు ఇస్తున్నారో లేదో చూడటానికి మీ ప్రొవైడర్తో తనిఖీ చేయండి.';
$string['cfg_domainhint_key'] = 'డొమైన్ సూచన';
$string['cfg_err_invalidauthendpoint'] = 'చెల్లని ప్రామాణీకరణ ముగింపు';
$string['cfg_err_invalidclientid'] = 'చెల్లని క్లయింట్ ID';
$string['cfg_err_invalidclientsecret'] = 'చెల్లని క్లయింట్ రహస్యం';
$string['cfg_err_invalidtokenendpoint'] = 'చెల్లని టోకెన్ ముగింపు';
$string['cfg_icon_desc'] = 'లాగిన్ పేజీలో ప్రొవైడర్ పేరు పక్కన ప్రదర్శించడానికి ఒక చిహ్నం';
$string['cfg_icon_key'] = 'ఐకాన్';
$string['cfg_iconalt_check'] = 'చెక్ మార్క్ చిహ్నం';
$string['cfg_iconalt_go'] = 'గ్రీన్ సర్కిల్';
$string['cfg_iconalt_group'] = 'గుంపు చిహ్నం';
$string['cfg_iconalt_group2'] = 'సమూహం చిహ్నం ప్రత్యామ్నాయ';
$string['cfg_iconalt_key'] = 'కీ చిహ్నం';
$string['cfg_iconalt_lock'] = 'లాక్ చిహ్నం';
$string['cfg_iconalt_locked'] = 'లాక్ చేసిన చిహ్నం';
$string['cfg_iconalt_mnet'] = 'MNET చిహ్నం';
$string['cfg_iconalt_o365'] = 'ఆఫీస్ 365 చిహ్నం';
$string['cfg_iconalt_plus'] = 'ప్లస్ చిహ్నం';
$string['cfg_iconalt_rightarrow'] = 'కుడి బాహ్య బాణం చిహ్నం';
$string['cfg_iconalt_stop'] = 'రెడ్ సర్కిల్';
$string['cfg_iconalt_user'] = 'వాడుకరి చిహ్నం';
$string['cfg_iconalt_user2'] = 'వాడుకరి చిహ్నం ప్రత్యామ్నాయ';
$string['cfg_iconalt_userlock'] = 'లాక్ ico తో వాడుకరి';
$string['cfg_loginflow_authcode'] = 'ప్రామాణీకరణ కోడ్ ఫ్లో (సిఫార్సు చేయబడింది)';
$string['cfg_loginflow_authcode_desc'] = 'ఈ ప్రవాహాన్ని ఉపయోగించి, వినియోగదారుడు గుర్తింపు ప్రొవైడర్ యొక్క పేరును (ఎగువన ఉన్న "ప్రొవైడర్ పేరు" చూడండి) ను క్లిక్ చేసి, లాగిన్ చేయడానికి ప్రొవైడర్కు మళ్ళించబడతారు. ఒకసారి విజయవంతంగా లాగిన్ అయినప్పుడు, వినియోగదారు తిరిగి Moodle కు మళ్లించబడతారు Moodle లాగిన్ పారదర్శకంగా జరుగుతుంది. ఇది యూజర్ లాగ్ కోసం అత్యంత ప్రామాణికమైన, సురక్షిత మార్గం';
$string['cfg_loginflow_key'] = 'ప్రామాణీకరణ పద్ధతి';
$string['cfg_loginflow_rocreds'] = 'రిసోర్స్ ఓనర్ పాస్ వర్డ్ క్రెడెన్షియల్స్ గ్రాంట్';
$string['cfg_loginflow_rocreds_desc'] = 'ఈ ప్రవాహాన్ని ఉపయోగించడం, వినియోగదారు వారి లాగిన్ మరియు వారి పాస్వర్డ్ను వారు లాగిన్ మాన్యువల్ లాగిన్తో వంటి మూడ్ లాగిన్ రూపంలోకి ప్రవేశిస్తారు. ఇది గుర్తింపు ప్రొవైడర్తో వినియోగదారుని అధికారం చేస్తుంది, కానీ గుర్తింపు ప్రొవైడర్ సైట్లో సెషన్ను సృష్టించదు. ఉదాహరణకు, Office 365 ను OpenID Connect తో ఉపయోగించినట్లయితే, వినియోగదారుడు Moodle కు లాగిన్ చేయబడతారు కానీ ఆఫీస్ 365 వెబ్ అప్లికేషన్ లను కాదు. యూజర్లు మూడ్లె మరియు గుర్తింపు ప్రొవైడర్కు లాగిన్ కావాలనుకుంటే అధికార అభ్యర్థనను ఉపయోగించడం సిఫార్సు చేయబడింది. అన్ని గుర్తింపు ప్రొవైడర్లు ఈ ప్రవాహానికి మద్దతు ఇవ్వలేరని గమనించండి. ఇతర అధికార మంజూరు రకాలు అందుబాటులో లేనప్పుడు మాత్రమే ఈ ఎంపికను ఉపయోగించాలి.';
$string['cfg_opname_desc'] = 'ఇది వినియోగదారుడు లాగిన్ అవ్వాల్సిన ఆధారాల యొక్క రకాన్ని గుర్తిస్తున్న తుది-వినియోగదారు-ముఖంగా లేబుల్. ఈ లేబుల్ మీ ప్రొవైడర్ను గుర్తించడానికి ఈ ప్లగ్ఇన్ యొక్క యూజర్-ఫేసింగ్ భాగాలలో ఉపయోగించబడుతుంది.';
$string['cfg_opname_key'] = 'ప్రొవైడర్ పేరు';
$string['cfg_redirecturi_desc'] = '"URI URI" గా నమోదు చేసుకోవడానికి ఇది URI. మీ OpenID Connect గుర్తింపుదారుడు ఒక క్లయింట్గా Moodle ను రిజిస్టర్ చేస్తున్నప్పుడు దాని కొరకు అడగాలి. <br /> <b> గమనిక: </ b> మీ OpenID Connect ప్రొవైడర్ * ఇక్కడ సరిగ్గా కనిపించే సరిగ్గా మీరు దీన్ని నమోదు చేయాలి. ఏ వ్యత్యాసం OpenID Connect ఉపయోగించి లాగ్లను నిరోధిస్తుంది.';
$string['cfg_redirecturi_key'] = 'URI దారిమార్పు';
$string['cfg_userrestrictions_desc'] = 'కొన్ని పరిమితులకు అనుగుణంగా వినియోగదారులు లాగిన్ అవ్వడానికి మాత్రమే అనుమతించు. <br /> <b> వినియోగదారు పరిమితులను ఎలా ఉపయోగించాలి: </ b> <ul> <li> <a href="https://en.wikipedia.org/wiki/Regular_expression"> సాధారణ వ్యక్తీకరణ </ a </ li> <li> పంక్తికి ఒక నమూనాను ఎంటర్ చెయ్యండి </ li> <li> మీరు బహుళ నమూనాలను నమోదు చేస్తే, నమూనాలను ఏవైనా సరిపోలినట్లయితే వినియోగదారు అనుమతించబడతారు. </ li> <li> "\\" తో అక్షరం "/" తప్పించుకొనవలెను. </ li> <li> మీరు పైన ఏవైనా ఆంక్షలను నమోదు చేయకపోతే, OpenID Connect ప్రొవైడర్కు లాగిన్ అవ్వగల అన్ని యూజర్లు </ li> <li> ఏదైనా ఎంటర్ చేసిన నమూనా (లు) కు సరిపోని ఏ యూజర్ అయినా OpenID అనుసంధానితో లాగింగ్ నుండి నిరోధించబడదు. </ li> </ ul>';
$string['cfg_userrestrictions_key'] = 'వాడుకరి పరిమితులు';
$string['errorauthdisconnectemptypassword'] = 'పాస్వర్డ్ ఖాళీగా ఉండకూడదు';
$string['errorauthdisconnectemptyusername'] = 'యూజర్పేరు ఖాళీగా ఉండకూడదు';
$string['errorauthdisconnectifmanual'] = 'మాన్యువల్ లాగిన్ పద్ధతిని ఉపయోగిస్తే, క్రింద ఆధారాలను నమోదు చేయండి.';
$string['errorauthdisconnectinvalidmethod'] = 'చెల్లని లాగిన్ పద్ధతి పొందింది.';
$string['errorauthdisconnectnewmethod'] = 'లాగిన్ పద్ధతిని ఉపయోగించండి';
$string['errorauthdisconnectusernameexists'] = 'ఆ వినియోగదారు పేరు ఇప్పటికే తీసుకోబడింది. దయచేసి వేరొకదాన్ని ఎంచుకోండి.';
$string['errorauthgeneral'] = 'మీకు లాగింగ్ చేయడంలో సమస్య ఉంది. దయచేసి సహాయం కోసం మీ నిర్వాహకుడిని సంప్రదించండి.';
$string['errorauthinvalididtoken'] = 'చెల్లని id_token అందుకుంది.';
$string['errorauthloginfailednouser'] = 'చెల్లని లాగిన్: Moodle లో వినియోగదారు కనుగొనబడలేదు. ఈ సైట్ "authpreventaccountcreation" అమర్పును కలిగి ఉంటే, మీరు మొదట మీ కోసం ఖాతాని సృష్టించుకోవటానికి నిర్వాహకుడి అవసరం అని దీని అర్థం.';
$string['errorauthnoauthcode'] = 'గుర్తింపు సర్వర్ నుండి అధికార కోడ్ ఏదీ పొందలేదు. లోపం లాగ్లకు మరింత సమాచారం ఉండవచ్చు.';
$string['errorauthnohttpclient'] = 'దయచేసి HTTP క్లయింట్ను సెట్ చేయండి.';
$string['errorauthnoidtoken'] = 'OpenID Connect id_token అందుకోలేదు.';
$string['errorauthunknownstate'] = 'తెలియని స్థితి.';
$string['errorauthuseralreadyconnected'] = 'మీరు వేరొక OpenID Connect వినియోగదారుకు ఇప్పటికే కనెక్ట్ అయ్యారు.';
$string['errorauthuserconnectedtodifferent'] = 'ప్రామాణీకరించబడిన OpenID Connect వినియోగదారు ఇప్పటికే Moodle వినియోగదారుకు కనెక్ట్ చేయబడింది.';
$string['errorbadloginflow'] = 'చెల్లని ప్రామాణీకరణ రకం పేర్కొనబడింది. గమనిక: మీరు ఇటీవల సంస్థాపన లేదా అప్గ్రేడ్ తర్వాత దీనిని స్వీకరిస్తే, దయచేసి మీ మూడ్ల కాష్ని క్లియర్ చేయండి.';
$string['errorinvalidredirect_message'] = 'మీరు మళ్ళించడానికి ప్రయత్నిస్తున్న URL ఉనికిలో లేదు.';
$string['errorjwtbadpayload'] = 'JWT పేలోడ్ను చదవడం సాధ్యం కాలేదు.';
$string['errorjwtcouldnotreadheader'] = 'JWT శీర్షికను చదవడం సాధ్యం కాలేదు';
$string['errorjwtempty'] = 'ఖాళీ లేదా స్ట్రింగ్ లేని JWT పొందింది.';
$string['errorjwtinvalidheader'] = 'చెల్లని JWT శీర్షిక';
$string['errorjwtmalformed'] = 'అపకీర్తి పొందిన JWT పొందింది.';
$string['errorjwtunsupportedalg'] = 'JWS ALG లేదా JWE మద్దతు లేదు';
$string['errorlogintoconnectedaccount'] = 'ఈ ఆఫీసు 365 యూజర్ ఒక Moodle ఖాతాకు అనుసంధానించబడి ఉంది, కానీ ఈ Moodle ఖాతా కోసం OpenID Connect లాగిన్ ప్రారంభించబడలేదు. దయచేసి Office 365 లక్షణాలను ఉపయోగించడానికి ఖాతా యొక్క నిర్దిష్ట ప్రామాణీకరణ పద్ధతిని ఉపయోగించి Moodle ఖాతాకు లాగిన్ అవ్వండి';
$string['errornodisconnectionauthmethod'] = 'తిరిగి వదలడానికి ఎనేబుల్ చెయ్యబడిన ప్రామాణీకరణ ప్లగిన్ లేనందున డిస్కనెక్ట్ చేయలేరు. (యూజర్ యొక్క మునుపటి లాగిన్ పద్ధతి లేదా మాన్యువల్ లాగిన్ పద్ధతి).';
$string['erroroidccall'] = 'OpenID Connect లో లోపం. దయచేసి మరింత సమాచారం కోసం లాగ్లను తనిఖీ చేయండి.';
$string['erroroidccall_message'] = 'OpenID Connect లో దోషం: {$a}';
$string['erroroidcclientinsecuretokenendpoint'] = 'టోకెన్ తుది స్థానం తప్పనిసరిగా SSL / TLS ను ఉపయోగించాలి.';
$string['erroroidcclientinvalidendpoint'] = 'చెల్లని ముగింపు పూర్తయింది URI పొందింది.';
$string['erroroidcclientnoauthendpoint'] = 'అధికార ముగింపు పాయింట్ సెట్ కాదు. దయచేసి ఈ $> - సెట్డ్ పాయింట్లను సెట్ చేయండి';
$string['erroroidcclientnocreds'] = 'దయచేసి క్లుప్తాలతో క్లయింట్ ఆధారాలను సెట్ చేయండి';
$string['erroroidcclientnotokenendpoint'] = 'టోకెన్ ముగింపు పాయింట్ సెట్ కాదు. దయచేసి ఈ $> - సెట్డ్ పాయింట్లను సెట్ చేయండి';
$string['erroroidcnotenabled'] = 'OpenID Connect ప్రామాణీకరణ ప్లగ్ఇన్ ప్రారంభించబడలేదు.';
$string['errorrestricted'] = 'ఈ సైట్ OpenID Connect తో లాగ్-ఇన్ చేసే వినియోగదారుల స్థానంలో పరిమితులను కలిగి ఉంది. ఈ పరిమితులు ప్రస్తుతం ఈ లాగిన్ ప్రయత్నాన్ని పూర్తి చేయకుండా నిరోధించబడుతున్నాయి.';
$string['errorucpinvalidaction'] = 'చెల్లని చర్య పొందింది';
$string['event_debug'] = 'డీబగ్ సందేశం';
$string['eventuserauthed'] = 'OpenID అనుసంధానితో వినియోగదారుని అధికారం కలిగి ఉంది';
$string['eventuserconnected'] = 'OpenID కనెక్ట్కు వినియోగదారు కనెక్ట్ చేయబడింది';
$string['eventusercreated'] = 'OpenID Connect తో సృష్టించబడిన వాడుకరి';
$string['eventuserdisconnected'] = 'OpenID కనెక్ట్ నుండి వినియోగదారు డిస్కనెక్ట్ చేయబడింది';
$string['eventuserloggedin'] = 'యూజర్ ఓపెన్ ID తో కనెక్ట్ అయ్యారు';
$string['oidc:manageconnection'] = 'OpenID కనెక్షన్ మరియు డిస్కనెక్ట్ను అనుమతించండి';
$string['oidc:manageconnectionconnect'] = 'OpenID కనెక్షన్ను అనుమతించండి';
$string['oidc:manageconnectiondisconnect'] = 'OpenID డిస్కనెక్ట్ను అనుమతించండి';
$string['pluginname'] = 'OpenID కనెక్ట్';
$string['privacy:metadata:auth_oidc_prevlogin'] = 'Office 365 కనెక్షన్లను అన్డు చేయడానికి యూజర్ల మునుపటి లాగిన్ పద్ధతుల గురించి సమాచారం';
$string['privacy:metadata:auth_oidc_prevlogin:method'] = 'మునుపటి లాగిన్ పద్ధతి';
