define("core/local/reactive/dragdrop",["exports","core/local/reactive/basecomponent"],(function(_exports,_basecomponent){var obj;
/**
   * Drag and drop helper component.
   *
   * This component is used to delegate drag and drop handling.
   *
   * To delegate the logic to this particular element the component should create a new instance
   * passing "this" as param. The component will use all the necessary callbacks and add all the
   * necessary listeners to the component element.
   *
   * Component attributes used by dragdrop module:
   * - element: the draggable or dropzone element.
   * - (optional) classes: object with alternative CSS classes
   * - (optional) fullregion: page element affeted by the elementy dragging. Use this attribute if
   *                          the draggable element affects a bigger region (for example a draggable
   *                          title).
   * - (optional) autoconfigDraggable: by default, the component will be draggable if it has a
   *                                   getDraggableData method. If this value is false draggable
   *                                  property must be defined using setDraggable method.
   * - (optional) relativeDrag: by default the drag image is located at point (0,0) relative to the
   *                            mouse position to prevent the mouse from covering it. If this attribute
   *                            is true the drag image will be located at the click offset.
   *
   * Methods the parent component should have for making it draggable:
   *
   * - getDraggableData(): Object|data
   *      Return the data that will be passed to any valid dropzone while it is dragged.
   *      If the component has this method, the dragdrop module will enable the dragging,
   *      this is the only required method for dragging.
   *      If at the dragging moment this method returns a false|null|undefined, the dragging
   *      actions won't be captured.
   *
   * - (optional) dragStart(Object dropdata, Event event): void
   * - (optional) dragEnd(Object dropdata, Event event): void
   *      Callbacks dragdrop will call when the element is dragged and getDraggableData
   *      return some data.
   *
   * Methods the parent component should have for enabling it as a dropzone:
   *
   * - validateDropData(Object dropdata): boolean
   *      If that method exists, the dragdrop module will automathically configure the element as dropzone.
   *      This method will return true if the dropdata is accepted. In case it returns false, no drag and
   *      drop event will be listened for this specific dragged dropdata.
   *
   * - (Optional) showDropZone(Object dropdata, Event event): void
   * - (Optional) hideDropZone(Object dropdata, Event event): void
   *      Methods called when a valid dragged data pass over the element.
   *
   * - (Optional) drop(Object dropdata, Event event): void
   *      Called when a valid dragged element is dropped over the element.
   *
   *      Note that none of this methods will be called if validateDropData
   *      returns a false value.
   *
   * This module will also add or remove several CSS classes from both dragged elements and dropzones.
   * See the "this.classes" in the create method for more details. In case the parent component wants
   * to use the same classes, it can use the getClasses method. On the other hand, if the parent
   * component has an alternative "classes" attribute, this will override the default drag and drop
   * classes.
   *
   * @module     core/local/reactive/dragdrop
   * @class      core/local/reactive/dragdrop
   * @copyright  2021 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_basecomponent=(obj=_basecomponent)&&obj.__esModule?obj:{default:obj};let activeDropData=new Map,dragStartPoint={};class _default extends _basecomponent.default{create(parent){var _parent$name,_parent$classes,_this$parent$draggabl,_this$parent$relative;this.name="".concat(null!==(_parent$name=parent.name)&&void 0!==_parent$name?_parent$name:"unkown","_dragdrop"),this.classes=Object.assign({BODYDRAGGING:"dragging",DRAGGABLEREADY:"draggable",DROPREADY:"dropready",DRAGOVER:"dragover",DRAGGING:"dragging",DROPUP:"drop-up",DROPDOWN:"drop-down",DROPZONE:"drop-zone",DRAGICON:"dragicon"},null!==(_parent$classes=null==parent?void 0:parent.classes)&&void 0!==_parent$classes?_parent$classes:{}),this.fullregion=parent.fullregion,this.parent=parent,this.autoconfigDraggable=null===(_this$parent$draggabl=this.parent.draggable)||void 0===_this$parent$draggabl||_this$parent$draggabl,this.relativeDrag=null!==(_this$parent$relative=this.parent.relativeDrag)&&void 0!==_this$parent$relative&&_this$parent$relative,this.entercount=0,this.dropzonevisible=!1,this.ismouseover=!1}getClasses(){return this.classes}isDropzoneVisible(){return this.dropzonevisible}stateReady(){"function"==typeof this.parent.validateDropData&&(this.element.classList.add(this.classes.DROPREADY),this.addEventListener(this.element,"dragenter",this._dragEnter),this.addEventListener(this.element,"dragleave",this._dragLeave),this.addEventListener(this.element,"dragover",this._dragOver),this.addEventListener(this.element,"drop",this._drop),this.addEventListener(this.element,"mouseover",this._mouseOver),this.addEventListener(this.element,"mouseleave",this._mouseLeave)),this.autoconfigDraggable&&"function"==typeof this.parent.getDraggableData&&this.setDraggable(!0)}setDraggable(value){if("function"!=typeof this.parent.getDraggableData)throw new Error("Draggable components must have a getDraggableData method");this.element.setAttribute("draggable",value),value?(this.addEventListener(this.element,"dragstart",this._dragStart),this.addEventListener(this.element,"dragend",this._dragEnd),this.element.classList.add(this.classes.DRAGGABLEREADY)):(this.removeEventListener(this.element,"dragstart",this._dragStart),this.removeEventListener(this.element,"dragend",this._dragEnd),this.element.classList.remove(this.classes.DRAGGABLEREADY))}_mouseOver(){this.ismouseover=!0}_mouseLeave(){this.ismouseover=!1}_dragStart(event){var _this$fullregion;if(document.activeElement.matches("textarea, input"))return void event.preventDefault();const dropdata=this.parent.getDraggableData();if(!dropdata)return;dragStartPoint={pageX:event.pageX,pageY:event.pageY},event.stopPropagation(),activeDropData.set(this.reactive,dropdata),document.body.classList.add(this.classes.BODYDRAGGING),this.element.classList.add(this.classes.DRAGGING),null===(_this$fullregion=this.fullregion)||void 0===_this$fullregion||_this$fullregion.classList.add(this.classes.DRAGGING);let dragImage=this.element;if(void 0!==this.parent.setDragImage){const customImage=this.parent.setDragImage(dropdata,event);customImage&&(dragImage=customImage)}const position={x:0,y:0};this.relativeDrag&&(position.x=event.offsetX,position.y=event.offsetY),event.dataTransfer.setDragImage(dragImage,position.x,position.y),this._callParentMethod("dragStart",dropdata,event)}_dragEnd(event){var _this$fullregion2;const dropdata=activeDropData.get(this.reactive);dropdata&&(activeDropData.delete(this.reactive),document.body.classList.remove(this.classes.BODYDRAGGING),this.element.classList.remove(this.classes.DRAGGING),null===(_this$fullregion2=this.fullregion)||void 0===_this$fullregion2||_this$fullregion2.classList.remove(this.classes.DRAGGING),this.removeAllOverlays(),this._addEventTotalMovement(event),this._callParentMethod("dragEnd",dropdata,event))}_dragEnter(event){const dropdata=this._processEvent(event);dropdata&&(this.entercount++,this.element.classList.add(this.classes.DRAGOVER),1!=this.entercount||this.dropzonevisible||(this.dropzonevisible=!0,this.element.classList.add(this.classes.DRAGOVER),this._callParentMethod("showDropZone",dropdata,event)))}_dragOver(event){const dropdata=this._processEvent(event);dropdata&&!this.dropzonevisible&&(this.dropzonevisible=!0,this.element.classList.add(this.classes.DRAGOVER),this._callParentMethod("showDropZone",dropdata,event))}_dragLeave(event){const dropdata=this._processEvent(event);dropdata&&(this.entercount--,this.entercount<=0&&this.dropzonevisible&&(this.dropzonevisible=!1,this.element.classList.remove(this.classes.DRAGOVER),this._callParentMethod("hideDropZone",dropdata,event)))}_drop(event){const dropdata=this._processEvent(event);dropdata&&(this.entercount=0,this.dropzonevisible&&(this.dropzonevisible=!1,this._callParentMethod("hideDropZone",dropdata,event)),this.element.classList.remove(this.classes.DRAGOVER),this.removeAllOverlays(),this._callParentMethod("drop",dropdata,event),dragStartPoint={})}_processEvent(event){const dropdata=this._getDropData(event);return dropdata&&this.parent.validateDropData(dropdata)?(event.preventDefault(),event.stopPropagation(),this._addEventTotalMovement(event),dropdata):null}_addEventTotalMovement(event){if(void 0===dragStartPoint.pageX||void 0===event.pageX)return;event.fixedMovementX=event.pageX-dragStartPoint.pageX,event.fixedMovementY=event.pageY-dragStartPoint.pageY,event.initialPageX=dragStartPoint.pageX,event.initialPageY=dragStartPoint.pageY;const current=this.element.getBoundingClientRect();if(event.newFixedTop=current.top+event.fixedMovementY,event.newFixedLeft=current.left+event.fixedMovementX,void 0!==this.fullregion){const current=this.fullregion.getBoundingClientRect();event.newRegionFixedxTop=current.top+event.fixedMovementY,event.newRegionFixedxLeft=current.left+event.fixedMovementX}}_callParentMethod(methodname,dropdata,event){"function"==typeof this.parent[methodname]&&this.parent[methodname](dropdata,event)}_getDropData(event){return this._isOnlyFilesDragging=this._containsOnlyFiles(event),this._isOnlyFilesDragging?void 0!==this.reactive.getFilesDraggableData&&"function"==typeof this.reactive.getFilesDraggableData?this.reactive.getFilesDraggableData(event.dataTransfer):void 0:activeDropData.get(this.reactive)}_containsOnlyFiles(event){return!!event.dataTransfer.types.includes("Files")&&event.dataTransfer.types.every((type=>"text/uri-list"!=type.toLowerCase()&&"text/html"!=type.toLowerCase()&&"text/plain"!=type.toLowerCase()))}}return _exports.default=_default,_exports.default}));

//# sourceMappingURL=dragdrop.min.js.map